/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.tools4a.display;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.github.panpf.tools4a.systemproperties.SystemPropertiesx;

public class Displayx {
    private Displayx() {
    }

    @NonNull
    public static Point getScreenSize(@NonNull Context context) {
        Point point = new Point();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getSize(point);
        return point;
    }

    public static int getScreenWidth(@NonNull Context context) {
        Point point = new Point();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getSize(point);
        return point.x;
    }

    public static int getScreenHeight(@NonNull Context context) {
        Point point = new Point();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getSize(point);
        return point.y;
    }

    public static int getActionBarSize(@NonNull Context context) {
        TypedValue tv = new TypedValue();
        if (context.getTheme().resolveAttribute(16843499, tv, true)) {
            return TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
        return 0;
    }

    @NonNull
    public static DisplayMetrics getMetrics(@NonNull Context context) {
        return context.getResources().getDisplayMetrics();
    }

    public static float getDensity(@NonNull Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static int getDensityDpi(@NonNull Context context) {
        return context.getResources().getDisplayMetrics().densityDpi;
    }

    public static int getRotation(@NonNull Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        switch (windowManager.getDefaultDisplay().getRotation()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static int getRotation(@NonNull Fragment fragment) {
        return Displayx.getRotation(fragment.requireContext());
    }

    public static int getRotation(@NonNull View view) {
        return Displayx.getRotation(view.getContext());
    }

    public static int getOrientation(@NonNull Context context) {
        return context.getResources().getConfiguration().orientation;
    }

    public static int getOrientation(@NonNull Fragment fragment) {
        return fragment.requireContext().getResources().getConfiguration().orientation;
    }

    public static int getOrientation(@NonNull View view) {
        return view.getContext().getResources().getConfiguration().orientation;
    }

    public static boolean isOrientationPortrait(@NonNull Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }

    public static boolean isOrientationPortrait(@NonNull Fragment fragment) {
        return fragment.requireContext().getResources().getConfiguration().orientation == 1;
    }

    public static boolean isOrientationPortrait(@NonNull View view) {
        return view.getContext().getResources().getConfiguration().orientation == 1;
    }

    public static boolean isOrientationLandscape(@NonNull Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    public static boolean isOrientationLandscape(@NonNull Fragment fragment) {
        return fragment.requireContext().getResources().getConfiguration().orientation == 2;
    }

    public static boolean isOrientationLandscape(@NonNull View view) {
        return view.getContext().getResources().getConfiguration().orientation == 2;
    }

    public static boolean isOrientationUndefined(@NonNull Context context) {
        return context.getResources().getConfiguration().orientation == 0;
    }

    public static boolean isOrientationUndefined(@NonNull Fragment fragment) {
        return fragment.requireContext().getResources().getConfiguration().orientation == 0;
    }

    public static boolean isOrientationUndefined(@NonNull View view) {
        return view.getContext().getResources().getConfiguration().orientation == 0;
    }

    private static int getInternalDimensionSize(@NonNull Resources res, @NonNull String resName) {
        int result = 0;
        int resourceId = res.getIdentifier(resName, "dimen", "android");
        if (resourceId > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static int getStatusBarHeight(@NonNull Context context) {
        return Displayx.getInternalDimensionSize(context.getResources(), "status_bar_height");
    }

    public static boolean hasNavigationBar(@NonNull Context context) {
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("config_showNavigationBar", "bool", "android");
        if (resourceId != 0) {
            boolean hasNav = res.getBoolean(resourceId);
            if ("1".equals(NavBarOverrideHolder.navBarOverride)) {
                hasNav = false;
            } else if ("0".equals(NavBarOverrideHolder.navBarOverride)) {
                hasNav = true;
            }
            return hasNav;
        }
        return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
    }

    public static int getNavigationBarHeight(@NonNull Context context) {
        Resources res = context.getResources();
        if (Displayx.hasNavigationBar(context)) {
            if (res.getConfiguration().orientation == 1) {
                return Displayx.getInternalDimensionSize(res, "navigation_bar_height");
            }
            return Displayx.getInternalDimensionSize(res, "navigation_bar_height_landscape");
        }
        return 0;
    }

    public static int getNavigationBarWidth(@NonNull Context context) {
        if (Displayx.hasNavigationBar(context)) {
            return Displayx.getInternalDimensionSize(context.getResources(), "navigation_bar_width");
        }
        return 0;
    }

    private static final class NavBarOverrideHolder {
        @Nullable
        private static final String navBarOverride;

        private NavBarOverrideHolder() {
        }

        static {
            String navBarOverrideTemp;
            if (Build.VERSION.SDK_INT >= 19) {
                try {
                    navBarOverrideTemp = SystemPropertiesx.get((String)"qemu.hw.mainkeys");
                }
                catch (Throwable e) {
                    navBarOverrideTemp = null;
                }
            } else {
                navBarOverrideTemp = null;
            }
            navBarOverride = navBarOverrideTemp;
        }
    }
}

