/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.tools4a.context;

import android.accounts.AccountManager;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.DownloadManager;
import android.app.KeyguardManager;
import android.app.NotificationManager;
import android.app.SearchManager;
import android.app.UiModeManager;
import android.app.WallpaperManager;
import android.app.admin.DevicePolicyManager;
import android.app.job.JobScheduler;
import android.app.usage.NetworkStatsManager;
import android.app.usage.StorageStatsManager;
import android.app.usage.UsageStatsManager;
import android.appwidget.AppWidgetManager;
import android.bluetooth.BluetoothManager;
import android.companion.CompanionDeviceManager;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.RestrictionsManager;
import android.content.pm.CrossProfileApps;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.pm.ShortcutManager;
import android.hardware.ConsumerIrManager;
import android.hardware.SensorManager;
import android.hardware.camera2.CameraManager;
import android.hardware.display.DisplayManager;
import android.hardware.fingerprint.FingerprintManager;
import android.hardware.input.InputManager;
import android.hardware.usb.UsbManager;
import android.location.LocationManager;
import android.media.AudioManager;
import android.media.MediaRouter;
import android.media.midi.MidiManager;
import android.media.projection.MediaProjectionManager;
import android.media.session.MediaSessionManager;
import android.media.tv.TvInputManager;
import android.net.ConnectivityManager;
import android.net.IpSecManager;
import android.net.nsd.NsdManager;
import android.net.wifi.WifiManager;
import android.net.wifi.aware.WifiAwareManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.net.wifi.rtt.WifiRttManager;
import android.nfc.NfcManager;
import android.os.BatteryManager;
import android.os.DropBoxManager;
import android.os.HardwarePropertiesManager;
import android.os.PowerManager;
import android.os.UserManager;
import android.os.Vibrator;
import android.os.health.SystemHealthManager;
import android.os.storage.StorageManager;
import android.print.PrintManager;
import android.telecom.TelecomManager;
import android.telephony.CarrierConfigManager;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.CaptioningManager;
import android.view.inputmethod.InputMethodManager;
import android.view.textclassifier.TextClassificationManager;
import android.view.textservice.TextServicesManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import com.github.panpf.tools4a.run.Runx;
import java.lang.ref.WeakReference;

public class Contextx {
    private Contextx() {
    }

    @NonNull
    public static Context appContext(@NonNull Activity activity) {
        return activity.getApplicationContext();
    }

    @NonNull
    public static Context appContext(@NonNull View view) {
        return view.getContext().getApplicationContext();
    }

    @NonNull
    public static Context requireContext(@NonNull Fragment fragment) {
        return fragment.requireContext();
    }

    @NonNull
    public static Context requireAppContext(@NonNull Fragment fragment) {
        return Contextx.requireContext(fragment).getApplicationContext();
    }

    @NonNull
    public static <T> T systemService(@NonNull Context context, @NonNull String serviceName) {
        Object t = context.getSystemService(serviceName);
        if (t != null) {
            return (T)t;
        }
        throw new IllegalArgumentException("Not found service '" + serviceName + "'");
    }

    @Nullable
    public static <T> T systemServiceOrNull(@NonNull Context context, @NonNull String serviceName) {
        return (T)context.getSystemService(serviceName);
    }

    @NonNull
    public static <T> T systemServiceOnUiThread(@NonNull Context context, @NonNull String serviceName) {
        WeakReference<Context> contextWeakReference = new WeakReference<Context>(context);
        return (T)Runx.runOnMainThreadSyncResult(() -> {
            Context nowContext = (Context)contextWeakReference.get();
            if (nowContext == null) {
                throw new IllegalStateException("Context has death");
            }
            Object t = nowContext.getSystemService(serviceName);
            if (t != null) {
                return t;
            }
            throw new IllegalArgumentException("Not found service '" + serviceName + "'");
        });
    }

    @Nullable
    public static <T> T systemServiceOrNullOnUiThread(@NonNull Context context, @NonNull String serviceName) {
        WeakReference<Context> contextWeakReference = new WeakReference<Context>(context);
        return (T)Runx.runOnMainThreadSyncResultNullable(() -> {
            Context nowContext = (Context)contextWeakReference.get();
            return nowContext != null ? nowContext.getSystemService(serviceName) : null;
        });
    }

    @NonNull
    public static PackageManager packageManager(@NonNull Context context) {
        PackageManager packageManager = context.getPackageManager();
        if (packageManager != null) {
            return packageManager;
        }
        throw new IllegalArgumentException("Not found service 'PackageManager'");
    }

    @NonNull
    public static PowerManager powerManager(@NonNull Context context) {
        return (PowerManager)Contextx.systemService(context, "power");
    }

    @NonNull
    public static WindowManager windowManager(@NonNull Context context) {
        return (WindowManager)Contextx.systemService(context, "window");
    }

    @NonNull
    public static LayoutInflater layoutInflater(@NonNull Context context) {
        return (LayoutInflater)Contextx.systemService(context, "layout_inflater");
    }

    @NonNull
    public static AccountManager accountManager(@NonNull Context context) {
        return (AccountManager)Contextx.systemService(context, "account");
    }

    @NonNull
    public static ActivityManager activityManager(@NonNull Context context) {
        return (ActivityManager)Contextx.systemService(context, "activity");
    }

    @NonNull
    public static AlarmManager alarmManager(@NonNull Context context) {
        return (AlarmManager)Contextx.systemService(context, "alarm");
    }

    @NonNull
    public static NotificationManager notificationManager(@NonNull Context context) {
        return (NotificationManager)Contextx.systemService(context, "notification");
    }

    @NonNull
    public static AccessibilityManager accessibilityManager(@NonNull Context context) {
        return (AccessibilityManager)Contextx.systemService(context, "accessibility");
    }

    @NonNull
    @RequiresApi(api=19)
    public static CaptioningManager captioningManager(@NonNull Context context) {
        return (CaptioningManager)Contextx.systemServiceOnUiThread(context, "captioning");
    }

    @NonNull
    public static KeyguardManager keyguardManager(@NonNull Context context) {
        return (KeyguardManager)Contextx.systemService(context, "keyguard");
    }

    @NonNull
    public static LocationManager locationManager(@NonNull Context context) {
        return (LocationManager)Contextx.systemService(context, "location");
    }

    @NonNull
    public static SearchManager searchManager(@NonNull Context context) {
        return (SearchManager)Contextx.systemService(context, "search");
    }

    @NonNull
    public static SensorManager sensorManager(@NonNull Context context) {
        return (SensorManager)Contextx.systemService(context, "sensor");
    }

    @NonNull
    public static StorageManager storageManager(@NonNull Context context) {
        return (StorageManager)Contextx.systemService(context, "storage");
    }

    @NonNull
    @RequiresApi(api=26)
    public static StorageStatsManager storageStatsManager(@NonNull Context context) {
        return (StorageStatsManager)Contextx.systemService(context, "storagestats");
    }

    @NonNull
    public static WallpaperManager wallpaperManager(@NonNull Context context) {
        return (WallpaperManager)Contextx.systemService(context, "wallpaper");
    }

    @NonNull
    public static Vibrator vibrator(@NonNull Context context) {
        return (Vibrator)Contextx.systemService(context, "vibrator");
    }

    @NonNull
    public static ConnectivityManager connectivityManager(@NonNull Context context) {
        return (ConnectivityManager)Contextx.systemService(context, "connectivity");
    }

    @NonNull
    @RequiresApi(api=28)
    public static IpSecManager ipSecManager(@NonNull Context context) {
        return (IpSecManager)Contextx.systemService(context, "ipsec");
    }

    @NonNull
    @RequiresApi(api=23)
    public static NetworkStatsManager networkStatsManager(@NonNull Context context) {
        return (NetworkStatsManager)Contextx.systemService(context, "netstats");
    }

    @NonNull
    public static WifiManager wifiManager(@NonNull Context context) {
        return (WifiManager)Contextx.systemService(context.getApplicationContext(), "wifi");
    }

    @Nullable
    public static WifiManager wifiManagerOrNull(@NonNull Context context) {
        return (WifiManager)Contextx.systemServiceOrNull(context.getApplicationContext(), "wifi");
    }

    @NonNull
    @RequiresApi(api=26)
    public static WifiAwareManager wifiAwareManager(@NonNull Context context) {
        return (WifiAwareManager)Contextx.systemService(context, "wifiaware");
    }

    @Nullable
    @RequiresApi(api=26)
    public static WifiAwareManager wifiAwareManagerOrNull(@NonNull Context context) {
        return (WifiAwareManager)Contextx.systemServiceOrNull(context, "wifiaware");
    }

    @NonNull
    public static WifiP2pManager wifiP2pManager(@NonNull Context context) {
        return (WifiP2pManager)Contextx.systemService(context, "wifip2p");
    }

    @Nullable
    @RequiresApi(api=28)
    public static WifiRttManager wifiRttManagerOrNull(@NonNull Context context) {
        return (WifiRttManager)Contextx.systemServiceOrNull(context, "wifirtt");
    }

    @NonNull
    public static NsdManager nsdManager(@NonNull Context context) {
        return (NsdManager)Contextx.systemService(context, "servicediscovery");
    }

    @NonNull
    public static AudioManager audioManager(@NonNull Context context) {
        return (AudioManager)Contextx.systemService(context, "audio");
    }

    @NonNull
    @RequiresApi(api=23)
    public static FingerprintManager fingerprintManager(@NonNull Context context) {
        return (FingerprintManager)Contextx.systemService(context, "fingerprint");
    }

    @Nullable
    @RequiresApi(api=23)
    public static FingerprintManager fingerprintManagerOrNull(@NonNull Context context) {
        return (FingerprintManager)Contextx.systemServiceOrNull(context, "fingerprint");
    }

    @NonNull
    public static MediaRouter mediaRouter(@NonNull Context context) {
        return (MediaRouter)Contextx.systemService(context, "media_router");
    }

    @NonNull
    public static TelephonyManager telephonyManager(@NonNull Context context) {
        return (TelephonyManager)Contextx.systemService(context, "phone");
    }

    @Nullable
    public static TelephonyManager telephonyManagerOrNull(@NonNull Context context) {
        return (TelephonyManager)Contextx.systemServiceOrNull(context, "phone");
    }

    @NonNull
    @RequiresApi(api=22)
    public static SubscriptionManager telephonySubscriptionManager(@NonNull Context context) {
        return (SubscriptionManager)Contextx.systemService(context, "telephony_subscription_service");
    }

    @NonNull
    @RequiresApi(api=23)
    public static CarrierConfigManager carrierConfigManager(@NonNull Context context) {
        return (CarrierConfigManager)Contextx.systemService(context, "carrier_config");
    }

    @NonNull
    @RequiresApi(api=21)
    public static TelecomManager telecomManager(@NonNull Context context) {
        return (TelecomManager)Contextx.systemService(context, "telecom");
    }

    @NonNull
    public static ClipboardManager clipboardManager(@NonNull Context context) {
        return (ClipboardManager)Contextx.systemServiceOnUiThread(context, "clipboard");
    }

    @NonNull
    public static InputMethodManager inputMethodManager(@NonNull Context context) {
        return (InputMethodManager)Contextx.systemService(context, "input_method");
    }

    @NonNull
    public static TextServicesManager textServicesManager(@NonNull Context context) {
        return (TextServicesManager)Contextx.systemService(context, "textservices");
    }

    @NonNull
    @RequiresApi(api=26)
    public static TextClassificationManager textClassificationManager(@NonNull Context context) {
        return (TextClassificationManager)Contextx.systemService(context, "textclassification");
    }

    @NonNull
    @RequiresApi(api=21)
    public static AppWidgetManager appWidgetManager(@NonNull Context context) {
        return (AppWidgetManager)Contextx.systemService(context, "appwidget");
    }

    @NonNull
    public static DropBoxManager dropBoxManager(@NonNull Context context) {
        return (DropBoxManager)Contextx.systemService(context, "dropbox");
    }

    @NonNull
    public static DevicePolicyManager devicePolicyManager(@NonNull Context context) {
        return (DevicePolicyManager)Contextx.systemService(context, "device_policy");
    }

    @NonNull
    public static UiModeManager uiModeManager(@NonNull Context context) {
        return (UiModeManager)Contextx.systemService(context, "uimode");
    }

    @NonNull
    public static DownloadManager downloadManager(@NonNull Context context) {
        return (DownloadManager)Contextx.systemService(context, "download");
    }

    @NonNull
    public static NfcManager nfcManager(@NonNull Context context) {
        return (NfcManager)Contextx.systemService(context, "nfc");
    }

    @NonNull
    @RequiresApi(api=18)
    public static BluetoothManager bluetoothManager(@NonNull Context context) {
        return (BluetoothManager)Contextx.systemService(context, "bluetooth");
    }

    @NonNull
    public static UsbManager usbManager(@NonNull Context context) {
        return (UsbManager)Contextx.systemService(context, "usb");
    }

    @NonNull
    @RequiresApi(api=21)
    public static LauncherApps launcherApps(@NonNull Context context) {
        return (LauncherApps)Contextx.systemService(context, "launcherapps");
    }

    @NonNull
    public static InputManager inputManager(@NonNull Context context) {
        return (InputManager)Contextx.systemService(context, "input");
    }

    @NonNull
    @RequiresApi(api=17)
    public static DisplayManager displayManager(@NonNull Context context) {
        return (DisplayManager)Contextx.systemService(context, "display");
    }

    @NonNull
    @RequiresApi(api=17)
    public static UserManager userManager(@NonNull Context context) {
        return (UserManager)Contextx.systemService(context, "user");
    }

    @NonNull
    @RequiresApi(api=21)
    public static RestrictionsManager restrictionsManager(@NonNull Context context) {
        return (RestrictionsManager)Contextx.systemService(context, "restrictions");
    }

    @NonNull
    @RequiresApi(api=19)
    public static AppOpsManager appOpsManager(@NonNull Context context) {
        return (AppOpsManager)Contextx.systemService(context, "appops");
    }

    @NonNull
    @RequiresApi(api=21)
    public static CameraManager cameraManager(@NonNull Context context) {
        return (CameraManager)Contextx.systemService(context, "camera");
    }

    @NonNull
    @RequiresApi(api=19)
    public static PrintManager printManager(@NonNull Context context) {
        return (PrintManager)Contextx.systemService(context, "print");
    }

    @NonNull
    @RequiresApi(api=19)
    public static ConsumerIrManager consumerIrManager(@NonNull Context context) {
        return (ConsumerIrManager)Contextx.systemService(context, "consumer_ir");
    }

    @NonNull
    @RequiresApi(api=21)
    public static TvInputManager tvInputManager(@NonNull Context context) {
        return (TvInputManager)Contextx.systemService(context, "tv_input");
    }

    @Nullable
    @RequiresApi(api=21)
    public static TvInputManager tvInputManagerOrNull(@NonNull Context context) {
        return (TvInputManager)Contextx.systemServiceOrNull(context, "tv_input");
    }

    @NonNull
    @RequiresApi(api=22)
    public static UsageStatsManager usageStatsManager(@NonNull Context context) {
        return (UsageStatsManager)Contextx.systemService(context, "usagestats");
    }

    @NonNull
    @RequiresApi(api=21)
    public static MediaSessionManager mediaSessionManager(@NonNull Context context) {
        return (MediaSessionManager)Contextx.systemService(context, "media_session");
    }

    @NonNull
    @RequiresApi(api=21)
    public static BatteryManager batteryManager(@NonNull Context context) {
        return (BatteryManager)Contextx.systemService(context, "batterymanager");
    }

    @NonNull
    @RequiresApi(api=21)
    public static JobScheduler jobScheduler(@NonNull Context context) {
        return (JobScheduler)Contextx.systemService(context, "jobscheduler");
    }

    @NonNull
    @RequiresApi(api=21)
    public static MediaProjectionManager mediaProjectionManager(@NonNull Context context) {
        return (MediaProjectionManager)Contextx.systemService(context, "media_projection");
    }

    @NonNull
    @RequiresApi(api=23)
    public static MidiManager midiManager(@NonNull Context context) {
        return (MidiManager)Contextx.systemService(context, "midi");
    }

    @Nullable
    @RequiresApi(api=23)
    public static MidiManager midiManagerOrNull(@NonNull Context context) {
        return (MidiManager)Contextx.systemServiceOrNull(context, "midi");
    }

    @NonNull
    @RequiresApi(api=24)
    public static HardwarePropertiesManager hardwarePropertiesManager(@NonNull Context context) {
        return (HardwarePropertiesManager)Contextx.systemService(context, "hardware_properties");
    }

    @NonNull
    @RequiresApi(api=25)
    public static ShortcutManager shortcutManager(@NonNull Context context) {
        return (ShortcutManager)Contextx.systemService(context, "shortcut");
    }

    @NonNull
    @RequiresApi(api=24)
    public static SystemHealthManager systemHealthManager(@NonNull Context context) {
        return (SystemHealthManager)Contextx.systemService(context, "systemhealth");
    }

    @NonNull
    @RequiresApi(api=26)
    public static CompanionDeviceManager companionDeviceManager(@NonNull Context context) {
        return (CompanionDeviceManager)Contextx.systemService(context, "companiondevice");
    }

    @NonNull
    @RequiresApi(api=28)
    public static CrossProfileApps crossProfileApps(@NonNull Context context) {
        return (CrossProfileApps)Contextx.systemService(context, "crossprofileapps");
    }
}

