/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.liveevent;

import android.annotation.SuppressLint;
import androidx.annotation.CallSuper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.internal.SafeIterableMap;
import com.github.panpf.liveevent.Listener;
import com.github.panpf.liveevent.LiveEvent;
import java.util.Map;

@SuppressLint(value={"RestrictedApi"})
public class MediatorLiveEvent<T>
extends LiveEvent<T> {
    private SafeIterableMap<LiveEvent<?>, Source<?>> mSources = new SafeIterableMap();

    @MainThread
    public <S> void addSource(@NonNull LiveEvent<S> source, @NonNull Listener<? super S> onChanged) {
        Source<S> e = new Source<S>(source, onChanged);
        Source existing = (Source)this.mSources.putIfAbsent(source, e);
        if (existing != null && existing.mListener != onChanged) {
            throw new IllegalArgumentException("This source was already added with the different listener");
        }
        if (existing != null) {
            return;
        }
        if (this.hasActiveListeners()) {
            e.plug();
        }
    }

    @MainThread
    public <S> void removeSource(@NonNull LiveEvent<S> toRemote) {
        Source source = (Source)this.mSources.remove(toRemote);
        if (source != null) {
            source.unplug();
        }
    }

    @Override
    @CallSuper
    protected void onActive() {
        for (Map.Entry source : this.mSources) {
            ((Source)source.getValue()).plug();
        }
    }

    @Override
    @CallSuper
    protected void onInactive() {
        for (Map.Entry source : this.mSources) {
            ((Source)source.getValue()).unplug();
        }
    }

    private static class Source<V>
    implements Listener<V> {
        final LiveEvent<V> mLiveEvent;
        final Listener<? super V> mListener;
        int mVersion = -1;

        Source(LiveEvent<V> liveEvent, Listener<? super V> listener) {
            this.mLiveEvent = liveEvent;
            this.mListener = listener;
        }

        void plug() {
            this.mLiveEvent.listenForever(this);
        }

        void unplug() {
            this.mLiveEvent.removeListener(this);
        }

        @Override
        public void onChanged(@Nullable V v) {
            if (this.mVersion != this.mLiveEvent.getVersion()) {
                this.mVersion = this.mLiveEvent.getVersion();
                this.mListener.onChanged(v);
            }
        }
    }
}

