/*
 * Decompiled with CFR 0.152.
 */
package com.master.permissionhelper;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.master.permissionhelper.PermissionHelper;
import com.master.permissionhelper.PermissionHelperJava;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\t\u0018\u00002\u00020\u0001:\u00019B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fB'\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\b\u0010!\u001a\u00020\u0016H\u0002J\u001b\u0010\"\u001a\u00020\u00122\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010#J)\u0010$\u001a\u00020\u00162!\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0011J!\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010'J\u0019\u0010(\u001a\u0004\u0018\u0001H)\"\b\b\u0000\u0010)*\u00020*H\u0002\u00a2\u0006\u0002\u0010+J\u0006\u0010,\u001a\u00020\u0012J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\bH\u0002J)\u0010/\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00100\u001a\u000201\u00a2\u0006\u0002\u00102J\u0006\u00103\u001a\u00020\u0016J\u0010\u00104\u001a\u00020\u00162\b\u00105\u001a\u0004\u0018\u00010\u0018J\u0014\u00106\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dJ/\u00107\u001a\u00020\u00162'\u0010%\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00160\u0011J\u001b\u00108\u001a\u00020\u00122\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010#R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0010\u001a\u001f\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0016\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u001e\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/master/permissionhelper/PermissionHelper;", "", "activity", "Landroid/app/Activity;", "fragment", "Landroidx/fragment/app/Fragment;", "permissions", "", "", "requestCode", "", "(Landroid/app/Activity;Landroidx/fragment/app/Fragment;[Ljava/lang/String;I)V", "(Landroid/app/Activity;[Ljava/lang/String;I)V", "(Landroidx/fragment/app/Fragment;[Ljava/lang/String;I)V", "REQUEST_CODE", "TAG", "deniedCallback", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "isSystem", "", "mPermissionCallback", "Lcom/master/permissionhelper/PermissionHelper$PermissionCallback;", "permissionHelper", "Lcom/master/permissionhelper/PermissionHelperJava;", "[Ljava/lang/String;", "requestAllCallback", "Lkotlin/Function0;", "requestIndividualCallback", "grantedPermission", "showRational", "checkIfPermissionPresentInAndroidManifest", "checkSelfPermission", "([Ljava/lang/String;)Z", "denied", "callback", "filterNotGrantedPermission", "([Ljava/lang/String;)[Ljava/lang/String;", "getContext", "T", "Landroid/content/Context;", "()Landroid/content/Context;", "hasPermission", "hasPermissionInManifest", "permission", "onRequestPermissionsResult", "grantResults", "", "(I[Ljava/lang/String;[I)V", "openAppDetailsActivity", "request", "permissionCallback", "requestAll", "requestIndividual", "shouldShowRational", "PermissionCallback", "permissionhelper_release"})
public final class PermissionHelper {
    private final String TAG;
    private final PermissionHelperJava permissionHelper;
    private int REQUEST_CODE;
    private Activity activity;
    private Fragment fragment;
    private String[] permissions;
    private PermissionCallback mPermissionCallback;
    private boolean showRational;
    private Function0<Unit> requestAllCallback;
    private Function1<? super String[], Unit> requestIndividualCallback;
    private Function1<? super Boolean, Unit> deniedCallback;

    private final void checkIfPermissionPresentInAndroidManifest() {
        Intrinsics.checkNotNull((Object)this.permissions);
        for (String permission : this.permissions) {
            if (this.hasPermissionInManifest(permission)) continue;
            throw (Throwable)new RuntimeException("Permission (" + permission + ") Not Declared in manifest");
        }
    }

    public final void request(@Nullable PermissionCallback permissionCallback) {
        this.mPermissionCallback = permissionCallback;
        if (!this.hasPermission()) {
            Intrinsics.checkNotNull((Object)this.permissions);
            this.showRational = this.shouldShowRational(this.permissions);
            if (this.activity != null) {
                Activity activity = this.activity;
                Intrinsics.checkNotNull((Object)activity);
                Intrinsics.checkNotNull((Object)this.permissions);
                ActivityCompat.requestPermissions((Activity)activity, (String[])this.filterNotGrantedPermission(this.permissions), (int)this.REQUEST_CODE);
            } else {
                Fragment fragment = this.fragment;
                Intrinsics.checkNotNull((Object)fragment);
                Intrinsics.checkNotNull((Object)this.permissions);
                fragment.requestPermissions(this.filterNotGrantedPermission(this.permissions), this.REQUEST_CODE);
            }
        } else {
            Log.i((String)this.TAG, (String)"PERMISSION: Permission Granted");
            PermissionCallback permissionCallback2 = this.mPermissionCallback;
            if (permissionCallback2 != null) {
                permissionCallback2.onPermissionGranted();
            }
            this.requestAllCallback.invoke();
        }
    }

    public final void requestAll(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.requestAllCallback = callback;
        this.request(null);
    }

    public final void requestIndividual(@NotNull Function1<? super String[], Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.requestIndividualCallback = callback;
        this.request(null);
    }

    public final void denied(@NotNull Function1<? super Boolean, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.deniedCallback = callback;
    }

    public final void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        if (requestCode == this.REQUEST_CODE) {
            boolean denied = false;
            int i = 0;
            ArrayList<String> grantedPermissions = new ArrayList<String>();
            for (int grantResult : grantResults) {
                if (grantResult != 0) {
                    denied = true;
                } else {
                    grantedPermissions.add(permissions[i]);
                }
                ++i;
            }
            if (denied) {
                boolean currentShowRational = this.shouldShowRational(permissions);
                if (!this.showRational && !currentShowRational) {
                    Log.d((String)this.TAG, (String)"PERMISSION: Permission Denied By System");
                    PermissionCallback permissionCallback = this.mPermissionCallback;
                    if (permissionCallback != null) {
                        permissionCallback.onPermissionDeniedBySystem();
                    }
                    this.deniedCallback.invoke((Object)true);
                } else {
                    Log.i((String)this.TAG, (String)"PERMISSION: Permission Denied");
                    if (!grantedPermissions.isEmpty()) {
                        PermissionCallback permissionCallback = this.mPermissionCallback;
                        if (permissionCallback != null) {
                            Collection $this$toTypedArray$iv = grantedPermissions;
                            boolean $i$f$toTypedArray = false;
                            Collection thisCollection$iv = $this$toTypedArray$iv;
                            String[] stringArray = thisCollection$iv.toArray(new String[0]);
                            if (stringArray == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                            }
                            permissionCallback.onIndividualPermissionGranted(stringArray);
                        }
                        Collection $this$toTypedArray$iv = grantedPermissions;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        this.requestIndividualCallback.invoke((Object)stringArray);
                    }
                    PermissionCallback permissionCallback = this.mPermissionCallback;
                    if (permissionCallback != null) {
                        permissionCallback.onPermissionDenied();
                    }
                    this.deniedCallback.invoke((Object)false);
                }
            } else {
                Log.i((String)this.TAG, (String)"PERMISSION: Permission Granted");
                PermissionCallback permissionCallback = this.mPermissionCallback;
                if (permissionCallback != null) {
                    permissionCallback.onPermissionGranted();
                }
                this.requestAllCallback.invoke();
            }
        }
    }

    private final <T extends Context> T getContext() {
        Context context;
        if (this.activity != null) {
            context = (Context)this.activity;
        } else {
            Fragment fragment = this.fragment;
            Intrinsics.checkNotNull((Object)fragment);
            context = fragment.getContext();
            if (context == null) {
                throw new NullPointerException("null cannot be cast to non-null type T");
            }
        }
        return (T)context;
    }

    private final String[] filterNotGrantedPermission(String[] permissions) {
        ArrayList<String> notGrantedPermission = new ArrayList<String>();
        for (String permission : permissions) {
            Object t = this.getContext();
            Intrinsics.checkNotNull(t);
            if (ContextCompat.checkSelfPermission(t, (String)permission) == 0) continue;
            notGrantedPermission.add(permission);
        }
        Collection $this$toTypedArray$iv = notGrantedPermission;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    public final boolean hasPermission() {
        Intrinsics.checkNotNull((Object)this.permissions);
        for (String permission : this.permissions) {
            Object t = this.getContext();
            Intrinsics.checkNotNull(t);
            if (ContextCompat.checkSelfPermission(t, (String)permission) == 0) continue;
            return false;
        }
        return true;
    }

    public final boolean checkSelfPermission(@Nullable String[] permissions) {
        Intrinsics.checkNotNull((Object)permissions);
        for (String permission : permissions) {
            Object t = this.getContext();
            Intrinsics.checkNotNull(t);
            if (ContextCompat.checkSelfPermission(t, (String)permission) == 0) continue;
            return false;
        }
        return true;
    }

    private final boolean shouldShowRational(String[] permissions) {
        boolean currentShowRational = false;
        for (String permission : permissions) {
            if (this.activity != null) {
                Activity activity = this.activity;
                Intrinsics.checkNotNull((Object)activity);
                if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission)) continue;
                currentShowRational = true;
                break;
            }
            Fragment fragment = this.fragment;
            Intrinsics.checkNotNull((Object)fragment);
            if (!fragment.shouldShowRequestPermissionRationale(permission)) continue;
            currentShowRational = true;
            break;
        }
        return currentShowRational;
    }

    private final boolean hasPermissionInManifest(String permission) {
        try {
            Activity context;
            Activity activity;
            PackageInfo info;
            Activity activity2;
            if (this.activity != null) {
                activity2 = this.activity;
            } else {
                Fragment fragment = this.fragment;
                Intrinsics.checkNotNull((Object)fragment);
                activity2 = (Activity)fragment.getActivity();
            }
            PackageInfo packageInfo = info = (activity = (context = activity2)) != null && (activity = activity.getPackageManager()) != null ? activity.getPackageInfo(context.getPackageName(), 4096) : null;
            if ((packageInfo != null ? packageInfo.requestedPermissions : null) != null) {
                PackageInfo packageInfo2 = info;
                for (String p : packageInfo2 != null ? packageInfo2.requestedPermissions : null) {
                    if (!Intrinsics.areEqual((Object)p, (Object)permission)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public final void openAppDetailsActivity() {
        if (this.getContext() == null) {
            return;
        }
        Intent i = new Intent();
        i.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        i.addCategory("android.intent.category.DEFAULT");
        StringBuilder stringBuilder = new StringBuilder().append("package:");
        Object t = this.getContext();
        Intrinsics.checkNotNull(t);
        i.setData(Uri.parse((String)stringBuilder.append(t.getPackageName()).toString()));
        i.addFlags(0x10000000);
        i.addFlags(0x40000000);
        i.addFlags(0x800000);
        Object t2 = this.getContext();
        Intrinsics.checkNotNull(t2);
        t2.startActivity(i);
    }

    public PermissionHelper(@NotNull Activity activity, @NotNull Fragment fragment, @NotNull String[] permissions, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        this.TAG = "PermissionHelperJava";
        this.requestAllCallback = requestAllCallback.1.INSTANCE;
        this.requestIndividualCallback = requestIndividualCallback.1.INSTANCE;
        this.deniedCallback = deniedCallback.1.INSTANCE;
        this.activity = activity;
        this.fragment = fragment;
        this.permissions = permissions;
        this.REQUEST_CODE = requestCode;
        this.checkIfPermissionPresentInAndroidManifest();
    }

    public PermissionHelper(@NotNull Activity activity, @NotNull String[] permissions, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        this.TAG = "PermissionHelperJava";
        this.requestAllCallback = requestAllCallback.1.INSTANCE;
        this.requestIndividualCallback = requestIndividualCallback.1.INSTANCE;
        this.deniedCallback = deniedCallback.1.INSTANCE;
        this.activity = activity;
        this.permissions = permissions;
        this.REQUEST_CODE = requestCode;
        this.checkIfPermissionPresentInAndroidManifest();
    }

    public /* synthetic */ PermissionHelper(Activity activity, String[] stringArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 100;
        }
        this(activity, stringArray, n);
    }

    public PermissionHelper(@NotNull Fragment fragment, @NotNull String[] permissions, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        this.TAG = "PermissionHelperJava";
        this.requestAllCallback = requestAllCallback.1.INSTANCE;
        this.requestIndividualCallback = requestIndividualCallback.1.INSTANCE;
        this.deniedCallback = deniedCallback.1.INSTANCE;
        this.fragment = fragment;
        this.permissions = permissions;
        this.REQUEST_CODE = requestCode;
        this.checkIfPermissionPresentInAndroidManifest();
    }

    public /* synthetic */ PermissionHelper(Fragment fragment, String[] stringArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 100;
        }
        this(fragment, stringArray, n);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u001b\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H&J\b\u0010\t\u001a\u00020\u0003H&J\b\u0010\n\u001a\u00020\u0003H&\u00a8\u0006\u000b"}, d2={"Lcom/master/permissionhelper/PermissionHelper$PermissionCallback;", "", "onIndividualPermissionGranted", "", "grantedPermission", "", "", "([Ljava/lang/String;)V", "onPermissionDenied", "onPermissionDeniedBySystem", "onPermissionGranted", "permissionhelper_release"})
    public static interface PermissionCallback {
        public void onPermissionGranted();

        public void onIndividualPermissionGranted(@NotNull String[] var1);

        public void onPermissionDenied();

        public void onPermissionDeniedBySystem();
    }
}

