/*
 * Decompiled with CFR 0.152.
 */
package panda.roid.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;

public class Bitmaps {
    public static final int UNCONSTRAINED = -1;

    public static Bitmap rotate(Bitmap b, int degrees) {
        return Bitmaps.rotate(b, degrees, null);
    }

    public static Bitmap rotate(Bitmap b, int degrees, Matrix m) {
        if (degrees != 0 && b != null) {
            if (m == null) {
                m = new Matrix();
            }
            m.setRotate((float)degrees, (float)b.getWidth() / 2.0f, (float)b.getHeight() / 2.0f);
            Bitmap b2 = Bitmap.createBitmap((Bitmap)b, (int)0, (int)0, (int)b.getWidth(), (int)b.getHeight(), (Matrix)m, (boolean)true);
            if (b != b2) {
                b.recycle();
                b = b2;
            }
        }
        return b;
    }

    public static int computeSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int roundedSize;
        int initialSize = Bitmaps.computeInitialSampleSize(options, minSideLength, maxNumOfPixels);
        if (initialSize <= 8) {
            for (roundedSize = 1; roundedSize < initialSize; roundedSize <<= 1) {
            }
        } else {
            roundedSize = (initialSize + 7) / 8 * 8;
        }
        return roundedSize;
    }

    private static int computeInitialSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int upperBound;
        double w = options.outWidth;
        double h = options.outHeight;
        int lowerBound = maxNumOfPixels == -1 ? 1 : (int)Math.ceil(Math.sqrt(w * h / (double)maxNumOfPixels));
        int n = upperBound = minSideLength == -1 ? 128 : (int)Math.min(Math.floor(w / (double)minSideLength), Math.floor(h / (double)minSideLength));
        if (upperBound < lowerBound) {
            return lowerBound;
        }
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        if (minSideLength == -1) {
            return lowerBound;
        }
        return upperBound;
    }

    public static Bitmap transform(Matrix scaler, Bitmap source, int targetWidth, int targetHeight, boolean scaleUp, boolean recycle) {
        int dy1;
        int dx1;
        Bitmap b2;
        float scale;
        float viewAspect;
        float bitmapHeightF;
        int deltaX = source.getWidth() - targetWidth;
        int deltaY = source.getHeight() - targetHeight;
        if (!(scaleUp || deltaX >= 0 && deltaY >= 0)) {
            Bitmap b22 = Bitmap.createBitmap((int)targetWidth, (int)targetHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(b22);
            int deltaXHalf = Math.max(0, deltaX / 2);
            int deltaYHalf = Math.max(0, deltaY / 2);
            Rect src = new Rect(deltaXHalf, deltaYHalf, deltaXHalf + Math.min(targetWidth, source.getWidth()), deltaYHalf + Math.min(targetHeight, source.getHeight()));
            int dstX = (targetWidth - src.width()) / 2;
            int dstY = (targetHeight - src.height()) / 2;
            Rect dst = new Rect(dstX, dstY, targetWidth - dstX, targetHeight - dstY);
            c.drawBitmap(source, src, dst, null);
            if (recycle) {
                source.recycle();
            }
            return b22;
        }
        float bitmapWidthF = source.getWidth();
        float bitmapAspect = bitmapWidthF / (bitmapHeightF = (float)source.getHeight());
        if (bitmapAspect > (viewAspect = (float)targetWidth / (float)targetHeight)) {
            scale = (float)targetHeight / bitmapHeightF;
            if (scale < 0.9f || scale > 1.0f) {
                scaler.setScale(scale, scale);
            } else {
                scaler = null;
            }
        } else {
            scale = (float)targetWidth / bitmapWidthF;
            if (scale < 0.9f || scale > 1.0f) {
                scaler.setScale(scale, scale);
            } else {
                scaler = null;
            }
        }
        Bitmap b1 = scaler != null ? Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)scaler, (boolean)true) : source;
        if (recycle && b1 != source) {
            source.recycle();
        }
        if ((b2 = Bitmap.createBitmap((Bitmap)b1, (int)((dx1 = Math.max(0, b1.getWidth() - targetWidth)) / 2), (int)((dy1 = Math.max(0, b1.getHeight() - targetHeight)) / 2), (int)targetWidth, (int)targetHeight)) != b1 && (recycle || b1 != source)) {
            b1.recycle();
        }
        return b2;
    }

    public static Bitmap makeBitmap(int minSideLength, int maxNumOfPixels, String pathName, BitmapFactory.Options options) {
        if (options == null) {
            options = new BitmapFactory.Options();
        }
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        if (options.outWidth == -1 || options.outHeight == -1) {
            return null;
        }
        options.inSampleSize = Bitmaps.computeSampleSize(options, minSideLength, maxNumOfPixels);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
    }
}

