/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.facebook;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.facebook.ads.Ad;
import com.facebook.ads.AdChoicesView;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.ImpressionListener;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdViewAttributes;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class FacebookAdapter
implements MediationInterstitialAdapter,
MediationBannerAdapter,
MediationNativeAdapter {
    public static final String KEY_AD_VIEW_ATTRIBUTES = "ad_view_attributes";
    public static final String KEY_AUTOPLAY = "autoplay";
    public static final String KEY_BACKGROUND_COLOR = "background_color";
    public static final String KEY_BUTTON_BORDER_COLOR = "button_border_color";
    public static final String KEY_BUTTON_COLOR = "button_color";
    public static final String KEY_BUTTON_TEXT_COLOR = "button_text_color";
    public static final String KEY_DESCRIPTION_TEXT_COLOR = "description_text_color";
    public static final String KEY_DESCRIPTION_TEXT_SIZE = "description_text_size";
    public static final String KEY_ID = "id";
    public static final String KEY_IS_BOLD = "is_bold";
    public static final String KEY_IS_ITALIC = "is_italic";
    public static final String KEY_SOCIAL_CONTEXT_ASSET = "social_context";
    public static final String KEY_STYLE = "style";
    public static final String KEY_SUBTITLE_ASSET = "subtitle";
    public static final String KEY_TITLE_TEXT_COLOR = "title_text_color";
    public static final String KEY_TITLE_TEXT_SIZE = "title_text_size";
    public static final String KEY_TYPEFACE = "typeface";
    private static final int DRAWABLE_FUTURE_TIMEOUT_SECONDS = 10;
    private static final String PLACEMENT_PARAMETER = "pubid";
    private static final int MAX_STAR_RATING = 5;
    private static final String TAG = "FacebookAdapter";
    private MediationBannerListener mBannerListener;
    private MediationInterstitialListener mInterstitialListener;
    private MediationNativeListener mNativeListener;
    private AdView mAdView;
    private RelativeLayout mWrappedAdView;
    private InterstitialAd mInterstitialAd;
    private NativeAd mNativeAd;
    private boolean mIsImpressionRecorded;
    private boolean mIsAdChoicesIconExpandable = true;

    public void onDestroy() {
        if (this.mAdView != null) {
            this.mAdView.destroy();
        }
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.destroy();
        }
        if (this.mNativeAd != null) {
            this.mNativeAd.unregisterView();
            this.mNativeAd.destroy();
        }
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public View getBannerView() {
        return this.mWrappedAdView;
    }

    public void requestBannerAd(Context context, MediationBannerListener listener, Bundle serverParameters, com.google.android.gms.ads.AdSize adSize, MediationAdRequest adRequest, Bundle mediationExtras) {
        this.mBannerListener = listener;
        if (context == null || serverParameters == null || adSize == null) {
            String str = "context";
            if (serverParameters == null) {
                str = "serverParameters";
            } else if (adSize == null) {
                str = "adSize";
            }
            Log.w((String)TAG, (String)("Fail to request banner ad, " + str + " is null"));
            this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, 0);
            return;
        }
        String placementId = serverParameters.getString(PLACEMENT_PARAMETER);
        if (placementId == null) {
            Log.w((String)TAG, (String)"Fail to request banner Ad, placementId is null");
            this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, 0);
            return;
        }
        AdSize facebookAdSize = this.getAdSize(context, adSize);
        if (facebookAdSize == null) {
            Log.w((String)TAG, (String)("The input ad size " + adSize.toString() + " is not supported at this moment."));
            this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, 3);
            return;
        }
        this.mAdView = new AdView(context, placementId, facebookAdSize);
        this.mAdView.setAdListener((AdListener)new BannerListener());
        this.buildAdRequest(adRequest);
        RelativeLayout.LayoutParams wrappedLayoutParams = new RelativeLayout.LayoutParams(adSize.getWidthInPixels(context), adSize.getHeightInPixels(context));
        this.mWrappedAdView = new RelativeLayout(context);
        this.mWrappedAdView.setLayoutParams((ViewGroup.LayoutParams)wrappedLayoutParams);
        this.mWrappedAdView.addView((View)this.mAdView);
        this.mAdView.loadAd();
    }

    public void requestInterstitialAd(Context context, MediationInterstitialListener listener, Bundle serverParameters, MediationAdRequest adRequest, Bundle mediationExtras) {
        this.mInterstitialListener = listener;
        if (context == null || serverParameters == null) {
            String str = context == null ? "context" : "serverParameters";
            Log.w((String)TAG, (String)("Fail to request interstitial ad, " + str + " is null"));
            this.mInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        String placementId = serverParameters.getString(PLACEMENT_PARAMETER);
        if (placementId == null) {
            Log.w((String)TAG, (String)"Fail to request interstitial Ad, placementId is null");
            this.mInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        this.mInterstitialAd = new InterstitialAd(context, placementId);
        this.mInterstitialAd.setAdListener((InterstitialAdListener)new InterstitialListener());
        this.buildAdRequest(adRequest);
        this.mInterstitialAd.loadAd();
    }

    public void showInterstitial() {
        if (this.mInterstitialAd.isAdLoaded()) {
            this.mInterstitialAd.show();
        }
    }

    public void requestNativeAd(Context context, MediationNativeListener listener, Bundle serverParameters, NativeMediationAdRequest mediationAdRequest, Bundle mediationExtras) {
        this.mNativeListener = listener;
        if (context == null || serverParameters == null) {
            String str = context == null ? "context" : "serverParameters";
            Log.w((String)TAG, (String)("Failed to request native ad, " + str + " is null"));
            this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)this, 1);
            return;
        }
        if (!mediationAdRequest.isAppInstallAdRequested() || !mediationAdRequest.isContentAdRequested()) {
            Log.w((String)TAG, (String)"Failed to request native ad. Both app install and content ad should be requested");
            this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)this, 1);
            return;
        }
        String placementId = serverParameters.getString(PLACEMENT_PARAMETER);
        if (placementId == null) {
            Log.w((String)TAG, (String)"Failed to request native ad, placementId is null");
            this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)this, 1);
            return;
        }
        if (mediationExtras != null) {
            this.mIsAdChoicesIconExpandable = mediationExtras.getBoolean("expandable_icon", true);
        }
        this.mNativeAd = new NativeAd(context, placementId);
        this.mNativeAd.setAdListener((AdListener)new NativeListener(this.mNativeAd, mediationAdRequest));
        this.mNativeAd.setImpressionListener(new ImpressionListener(){

            public void onLoggingImpression(Ad ad) {
                if (FacebookAdapter.this.mIsImpressionRecorded) {
                    Log.d((String)FacebookAdapter.TAG, (String)"Received onLoggingImpression callback for a native whose impression is already recorded. Ignoring the duplicate callback.");
                    return;
                }
                FacebookAdapter.this.mNativeListener.onAdImpression((MediationNativeAdapter)FacebookAdapter.this);
                FacebookAdapter.this.mIsImpressionRecorded = true;
            }
        });
        this.buildAdRequest((MediationAdRequest)mediationAdRequest);
        this.mNativeAd.loadAd();
    }

    private int convertErrorCode(AdError adError) {
        if (adError == null) {
            return 0;
        }
        int errorCode = adError.getErrorCode();
        if (errorCode == 2001 || errorCode == 2000) {
            return 0;
        }
        if (errorCode == 1000) {
            return 2;
        }
        if (errorCode == 1002) {
            return 1;
        }
        return 3;
    }

    private void buildAdRequest(MediationAdRequest adRequest) {
        if (adRequest != null) {
            AdSettings.setIsChildDirected((adRequest.taggedForChildDirectedTreatment() == 1 ? 1 : 0) != 0);
        }
    }

    private AdSize getAdSize(Context context, com.google.android.gms.ads.AdSize adSize) {
        if (adSize.getWidth() == AdSize.BANNER_320_50.getWidth() && adSize.getHeight() == AdSize.BANNER_320_50.getHeight()) {
            return AdSize.BANNER_320_50;
        }
        int heightInDip = this.pixelToDip(adSize.getHeightInPixels(context));
        if (heightInDip == AdSize.BANNER_HEIGHT_50.getHeight()) {
            return AdSize.BANNER_HEIGHT_50;
        }
        if (heightInDip == AdSize.BANNER_HEIGHT_90.getHeight()) {
            return AdSize.BANNER_HEIGHT_90;
        }
        if (heightInDip == AdSize.RECTANGLE_HEIGHT_250.getHeight()) {
            return AdSize.RECTANGLE_HEIGHT_250;
        }
        return null;
    }

    private int pixelToDip(int pixel) {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        return Math.round((float)pixel / displayMetrics.density);
    }

    private static interface NativeAdMapperListener {
        public void onMappingSuccess();

        public void onMappingFailed();
    }

    private class FacebookAdapterNativeAdImage
    extends NativeAd.Image {
        private Drawable mDrawable;
        private Uri mUri;

        public FacebookAdapterNativeAdImage(Uri uri) {
            this.mUri = uri;
        }

        protected void setDrawable(Drawable drawable) {
            this.mDrawable = drawable;
        }

        public Drawable getDrawable() {
            return this.mDrawable;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public double getScale() {
            return 1.0;
        }
    }

    public static class FacebookExtrasBundleBuilder {
        private static final String KEY_EXPANDABLE_ICON = "expandable_icon";
        private boolean mIsExpandableIcon;

        public FacebookExtrasBundleBuilder setNativeAdChoicesIconExpandable(boolean isExpandableIcon) {
            this.mIsExpandableIcon = isExpandableIcon;
            return this;
        }

        public Bundle build() {
            Bundle bundle = new Bundle();
            bundle.putBoolean(KEY_EXPANDABLE_ICON, this.mIsExpandableIcon);
            return bundle;
        }
    }

    private static class DownloadDrawablesAsync
    extends AsyncTask<Object, Void, Boolean> {
        private NativeAdMapperListener mDrawableListener;

        public DownloadDrawablesAsync(NativeAdMapperListener listener) {
            this.mDrawableListener = listener;
        }

        protected Boolean doInBackground(Object ... params) {
            AppInstallMapper mapper = (AppInstallMapper)((Object)params[0]);
            ExecutorService executorService = Executors.newCachedThreadPool();
            HashMap<FacebookAdapterNativeAdImage, Future<Drawable>> futuresMap = new HashMap<FacebookAdapterNativeAdImage, Future<Drawable>>();
            List images = mapper.getImages();
            for (int i = 0; i < images.size(); ++i) {
                FacebookAdapterNativeAdImage image = (FacebookAdapterNativeAdImage)((Object)images.get(i));
                Future<Drawable> drawableFuture = this.getDrawableFuture(image.getUri(), executorService);
                futuresMap.put(image, drawableFuture);
            }
            FacebookAdapterNativeAdImage iconImage = (FacebookAdapterNativeAdImage)mapper.getIcon();
            Future<Drawable> drawableFuture = this.getDrawableFuture(iconImage.getUri(), executorService);
            futuresMap.put(iconImage, drawableFuture);
            for (Map.Entry pair : futuresMap.entrySet()) {
                Drawable drawable;
                try {
                    drawable = (Drawable)((Future)pair.getValue()).get(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException exception) {
                    Log.w((String)FacebookAdapter.TAG, (String)("Exception occurred while waiting for future to return. Returning null as drawable : " + exception));
                    return false;
                }
                ((FacebookAdapterNativeAdImage)((Object)pair.getKey())).setDrawable(drawable);
            }
            return true;
        }

        private Future<Drawable> getDrawableFuture(final Uri uri, ExecutorService executorService) {
            return executorService.submit(new Callable<Drawable>(){

                @Override
                public Drawable call() throws Exception {
                    InputStream in = new URL(uri.toString()).openStream();
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)in);
                    bitmap.setDensity(160);
                    return new BitmapDrawable(Resources.getSystem(), bitmap);
                }
            });
        }

        protected void onPostExecute(Boolean isDownloadSuccessful) {
            super.onPostExecute((Object)isDownloadSuccessful);
            if (isDownloadSuccessful.booleanValue()) {
                this.mDrawableListener.onMappingSuccess();
            } else {
                this.mDrawableListener.onMappingFailed();
            }
        }
    }

    class AppInstallMapper
    extends NativeAppInstallAdMapper {
        private NativeAd mNativeAd;
        private NativeAdOptions mNativeAdOptions;

        public AppInstallMapper(NativeAd nativeAd, NativeAdOptions adOptions) {
            this.mNativeAd = nativeAd;
            this.mNativeAdOptions = adOptions;
        }

        public void mapNativeAd(NativeAdMapperListener mapperListener) {
            if (!this.containsRequiredFieldsForNativeAppInstallAd(this.mNativeAd)) {
                Log.w((String)FacebookAdapter.TAG, (String)"Ad from Facebook doesn't have all assets required for the app install format.");
                mapperListener.onMappingFailed();
                return;
            }
            this.setHeadline(this.mNativeAd.getAdTitle());
            ArrayList<FacebookAdapterNativeAdImage> images = new ArrayList<FacebookAdapterNativeAdImage>();
            images.add(new FacebookAdapterNativeAdImage(Uri.parse((String)this.mNativeAd.getAdCoverImage().getUrl())));
            this.setImages(images);
            this.setBody(this.mNativeAd.getAdBody());
            this.setIcon(new FacebookAdapterNativeAdImage(Uri.parse((String)this.mNativeAd.getAdIcon().getUrl())));
            this.setCallToAction(this.mNativeAd.getAdCallToAction());
            Double starRating = this.getRating(this.mNativeAd.getAdStarRating());
            if (starRating != null) {
                this.setStarRating(starRating);
            }
            Bundle extras = new Bundle();
            extras.putCharSequence(FacebookAdapter.KEY_ID, (CharSequence)this.mNativeAd.getId());
            extras.putCharSequence(FacebookAdapter.KEY_SOCIAL_CONTEXT_ASSET, (CharSequence)this.mNativeAd.getAdSocialContext());
            extras.putCharSequence(FacebookAdapter.KEY_SUBTITLE_ASSET, (CharSequence)this.mNativeAd.getAdSubtitle());
            NativeAdViewAttributes attributes = this.mNativeAd.getAdViewAttributes();
            if (attributes != null) {
                Bundle attributesBundle = new Bundle();
                attributesBundle.putBoolean(FacebookAdapter.KEY_AUTOPLAY, attributes.getAutoplay());
                attributesBundle.putInt(FacebookAdapter.KEY_BACKGROUND_COLOR, attributes.getBackgroundColor());
                attributesBundle.putInt(FacebookAdapter.KEY_BUTTON_BORDER_COLOR, attributes.getButtonBorderColor());
                attributesBundle.putInt(FacebookAdapter.KEY_BUTTON_COLOR, attributes.getButtonColor());
                attributesBundle.putInt(FacebookAdapter.KEY_BUTTON_TEXT_COLOR, attributes.getButtonTextColor());
                attributesBundle.putInt(FacebookAdapter.KEY_DESCRIPTION_TEXT_COLOR, attributes.getDescriptionTextColor());
                attributesBundle.putInt(FacebookAdapter.KEY_DESCRIPTION_TEXT_SIZE, attributes.getDescriptionTextSize());
                attributesBundle.putInt(FacebookAdapter.KEY_TITLE_TEXT_COLOR, attributes.getTitleTextColor());
                attributesBundle.putInt(FacebookAdapter.KEY_TITLE_TEXT_SIZE, attributes.getTitleTextSize());
                Typeface typeface = attributes.getTypeface();
                if (typeface != null) {
                    Bundle typefaceBundle = new Bundle();
                    typefaceBundle.putBoolean(FacebookAdapter.KEY_IS_BOLD, typeface.isBold());
                    typefaceBundle.putBoolean(FacebookAdapter.KEY_IS_ITALIC, typeface.isItalic());
                    typefaceBundle.putInt(FacebookAdapter.KEY_STYLE, typeface.getStyle());
                    attributesBundle.putBundle(FacebookAdapter.KEY_TYPEFACE, typefaceBundle);
                }
                extras.putBundle(FacebookAdapter.KEY_AD_VIEW_ATTRIBUTES, attributesBundle);
            }
            this.setExtras(extras);
            boolean urlsOnly = false;
            if (this.mNativeAdOptions != null) {
                urlsOnly = this.mNativeAdOptions.shouldReturnUrlsForImageAssets();
            }
            if (urlsOnly) {
                mapperListener.onMappingSuccess();
            } else {
                new DownloadDrawablesAsync(mapperListener).execute(new Object[]{this});
            }
        }

        private boolean containsRequiredFieldsForNativeAppInstallAd(NativeAd nativeAd) {
            return nativeAd.getAdTitle() != null && nativeAd.getAdCoverImage() != null && nativeAd.getAdBody() != null && nativeAd.getAdIcon() != null && nativeAd.getAdCallToAction() != null;
        }

        public void trackView(View view) {
            ViewGroup adView = (ViewGroup)view;
            View overlayView = adView.getChildAt(adView.getChildCount() - 1);
            if (overlayView instanceof FrameLayout) {
                AdChoicesView adChoicesView = new AdChoicesView(view.getContext(), this.mNativeAd, FacebookAdapter.this.mIsAdChoicesIconExpandable);
                ((ViewGroup)overlayView).addView((View)adChoicesView);
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)adChoicesView.getLayoutParams();
                if (this.mNativeAdOptions != null) {
                    switch (this.mNativeAdOptions.getAdChoicesPlacement()) {
                        case 0: {
                            params.gravity = 51;
                            break;
                        }
                        case 2: {
                            params.gravity = 85;
                            break;
                        }
                        case 3: {
                            params.gravity = 83;
                            break;
                        }
                        default: {
                            params.gravity = 53;
                            break;
                        }
                    }
                } else {
                    params.gravity = 53;
                }
                adView.requestLayout();
            } else {
                Log.w((String)FacebookAdapter.TAG, (String)"Failed to show AdChoices icon.");
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.mNativeAd.registerViewForInteraction(view);
        }

        public void untrackView(View view) {
            super.untrackView(view);
            ViewGroup adView = (ViewGroup)view;
            View overlayView = adView.getChildAt(adView.getChildCount() - 1);
            if (overlayView instanceof FrameLayout) {
                ((FrameLayout)overlayView).removeAllViews();
            }
            this.mNativeAd.unregisterView();
        }

        private Double getRating(NativeAd.Rating rating) {
            if (rating == null) {
                return null;
            }
            return 5.0 * rating.getValue() / rating.getScale();
        }
    }

    private class NativeListener
    implements AdListener {
        private NativeAd mNativeAd;
        private NativeMediationAdRequest mMediationAdRequest;

        private NativeListener(NativeAd nativeAd, NativeMediationAdRequest mediationAdRequest) {
            this.mNativeAd = nativeAd;
            this.mMediationAdRequest = mediationAdRequest;
        }

        public void onAdClicked(Ad ad) {
            FacebookAdapter.this.mNativeListener.onAdClicked((MediationNativeAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mNativeListener.onAdOpened((MediationNativeAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mNativeListener.onAdLeftApplication((MediationNativeAdapter)FacebookAdapter.this);
        }

        public void onAdLoaded(Ad ad) {
            if (ad != this.mNativeAd) {
                Log.w((String)FacebookAdapter.TAG, (String)"Ad loaded is not a native ad.");
                FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, 0);
                return;
            }
            NativeAdOptions options = this.mMediationAdRequest.getNativeAdOptions();
            final AppInstallMapper mapper = new AppInstallMapper(this.mNativeAd, options);
            mapper.mapNativeAd(new NativeAdMapperListener(){

                @Override
                public void onMappingSuccess() {
                    FacebookAdapter.this.mNativeListener.onAdLoaded((MediationNativeAdapter)FacebookAdapter.this, (NativeAdMapper)mapper);
                }

                @Override
                public void onMappingFailed() {
                    FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, 3);
                }
            });
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = adError.getErrorMessage();
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
            }
            FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, FacebookAdapter.this.convertErrorCode(adError));
        }
    }

    private class InterstitialListener
    implements InterstitialAdListener {
        private InterstitialListener() {
        }

        public void onAdClicked(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdClicked((MediationInterstitialAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mInterstitialListener.onAdLeftApplication((MediationInterstitialAdapter)FacebookAdapter.this);
        }

        public void onAdLoaded(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdLoaded((MediationInterstitialAdapter)FacebookAdapter.this);
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = adError.getErrorMessage();
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
            }
            FacebookAdapter.this.mInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)FacebookAdapter.this, FacebookAdapter.this.convertErrorCode(adError));
        }

        public void onInterstitialDismissed(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdClosed((MediationInterstitialAdapter)FacebookAdapter.this);
        }

        public void onInterstitialDisplayed(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdOpened((MediationInterstitialAdapter)FacebookAdapter.this);
        }
    }

    private class BannerListener
    implements AdListener {
        private BannerListener() {
        }

        public void onAdClicked(Ad ad) {
            FacebookAdapter.this.mBannerListener.onAdClicked((MediationBannerAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mBannerListener.onAdOpened((MediationBannerAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mBannerListener.onAdLeftApplication((MediationBannerAdapter)FacebookAdapter.this);
        }

        public void onAdLoaded(Ad ad) {
            FacebookAdapter.this.mBannerListener.onAdLoaded((MediationBannerAdapter)FacebookAdapter.this);
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = adError.getErrorMessage();
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
            }
            FacebookAdapter.this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)FacebookAdapter.this, FacebookAdapter.this.convertErrorCode(adError));
        }
    }
}

