/*
 * Decompiled with CFR 0.152.
 */
package com.github.palindromicity.syslog.dsl;

import com.github.palindromicity.syslog.AllowableDeviations;
import com.github.palindromicity.syslog.KeyProvider;
import com.github.palindromicity.syslog.NilPolicy;
import com.github.palindromicity.syslog.StructuredDataPolicy;
import com.github.palindromicity.syslog.dsl.ParseException;
import com.github.palindromicity.syslog.dsl.generated.Rfc5424BaseListener;
import com.github.palindromicity.syslog.dsl.generated.Rfc5424Parser;
import com.github.palindromicity.syslog.util.Validate;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class Syslog5424Listener
extends Rfc5424BaseListener {
    private static final String DASH = "-";
    private KeyProvider keyProvider;
    private NilPolicy nilPolicy = NilPolicy.OMIT;
    private StructuredDataPolicy structuredDataPolicy = StructuredDataPolicy.FLATTEN;
    private EnumSet<AllowableDeviations> deviations;
    private final Map<String, Object> msgMap = new HashMap<String, Object>();

    public Syslog5424Listener(KeyProvider keyProvider) {
        this(keyProvider, null, null, EnumSet.of(AllowableDeviations.NONE));
    }

    public Syslog5424Listener(KeyProvider keyProvider, NilPolicy nilPolicy, StructuredDataPolicy structuredDataPolicy) {
        this(keyProvider, nilPolicy, structuredDataPolicy, EnumSet.of(AllowableDeviations.NONE));
    }

    public Syslog5424Listener(KeyProvider keyProvider, NilPolicy nilPolicy, StructuredDataPolicy structuredDataPolicy, EnumSet<AllowableDeviations> deviations) {
        Validate.notNull(keyProvider, "keyProvider");
        this.keyProvider = keyProvider;
        if (nilPolicy != null) {
            this.nilPolicy = nilPolicy;
        }
        if (structuredDataPolicy != null) {
            this.structuredDataPolicy = structuredDataPolicy;
        }
        this.deviations = deviations;
    }

    public Map<String, Object> getMsgMap() {
        if (this.msgMap.get(this.keyProvider.getHeaderPriority()) == null && !this.deviations.contains((Object)AllowableDeviations.PRIORITY)) {
            throw new ParseException("Priority missing with strict parsing");
        }
        if (this.msgMap.get(this.keyProvider.getHeaderVersion()) == null && !this.deviations.contains((Object)AllowableDeviations.VERSION)) {
            throw new ParseException("Version missing with strict parsing");
        }
        return Collections.unmodifiableMap(this.msgMap);
    }

    @Override
    public void exitHeaderPriorityValue(Rfc5424Parser.HeaderPriorityValueContext ctx) {
        String priority = ctx.getText();
        this.msgMap.put(this.keyProvider.getHeaderPriority(), priority);
        int pri = Integer.parseInt(priority);
        int sev = pri % 8;
        int facility = pri / 8;
        this.msgMap.put(this.keyProvider.getHeaderSeverity(), String.valueOf(sev));
        this.msgMap.put(this.keyProvider.getHeaderFacility(), String.valueOf(facility));
    }

    @Override
    public void exitHeaderVersion(Rfc5424Parser.HeaderVersionContext ctx) {
        this.msgMap.put(this.keyProvider.getHeaderVersion(), ctx.getText());
    }

    @Override
    public void exitHeaderHostName(Rfc5424Parser.HeaderHostNameContext ctx) {
        this.msgMap.put(this.keyProvider.getHeaderHostName(), ctx.getText());
    }

    @Override
    public void exitHeaderNilHostName(Rfc5424Parser.HeaderNilHostNameContext ctx) {
        if (this.nilPolicy != NilPolicy.OMIT) {
            this.handleNil(this.keyProvider::getHeaderHostName);
        }
    }

    @Override
    public void exitHeaderAppName(Rfc5424Parser.HeaderAppNameContext ctx) {
        this.msgMap.put(this.keyProvider.getHeaderAppName(), ctx.getText());
    }

    @Override
    public void exitHeaderNilAppName(Rfc5424Parser.HeaderNilAppNameContext ctx) {
        if (this.nilPolicy != NilPolicy.OMIT) {
            this.handleNil(this.keyProvider::getHeaderAppName);
        }
    }

    @Override
    public void exitHeaderProcId(Rfc5424Parser.HeaderProcIdContext ctx) {
        this.msgMap.put(this.keyProvider.getHeaderProcessId(), ctx.getText());
    }

    @Override
    public void exitHeaderNilProcId(Rfc5424Parser.HeaderNilProcIdContext ctx) {
        if (this.nilPolicy != NilPolicy.OMIT) {
            this.handleNil(this.keyProvider::getHeaderProcessId);
        }
    }

    @Override
    public void exitHeaderMsgId(Rfc5424Parser.HeaderMsgIdContext ctx) {
        this.msgMap.put(this.keyProvider.getHeaderMessageId(), ctx.getText());
    }

    @Override
    public void exitHeaderNilMsgId(Rfc5424Parser.HeaderNilMsgIdContext ctx) {
        if (this.nilPolicy != NilPolicy.OMIT) {
            this.handleNil(this.keyProvider::getHeaderMessageId);
        }
    }

    @Override
    public void exitHeaderTimeStamp(Rfc5424Parser.HeaderTimeStampContext ctx) {
        this.msgMap.put(this.keyProvider.getHeaderTimeStamp(), ctx.full_date().getText() + "T" + ctx.full_time().getText());
    }

    @Override
    public void exitHeaderNilTimestamp(Rfc5424Parser.HeaderNilTimestampContext ctx) {
        if (this.nilPolicy != NilPolicy.OMIT) {
            this.handleNil(this.keyProvider::getHeaderTimeStamp);
        }
    }

    @Override
    public void exitSdElement(Rfc5424Parser.SdElementContext ctx) {
        String id = ctx.sd_id().getText();
        if (this.structuredDataPolicy == StructuredDataPolicy.FLATTEN) {
            for (Rfc5424Parser.Sd_paramContext paramContext : ctx.sd_param()) {
                this.msgMap.put(String.format(this.keyProvider.getStructuredElementIdParamNameFormat(), id, ((Rfc5424Parser.SdParamContext)paramContext).param_name().getText()), ((Rfc5424Parser.SdParamContext)paramContext).param_value().getText());
            }
        } else if (this.structuredDataPolicy == StructuredDataPolicy.MAP_OF_MAPS) {
            this.msgMap.putIfAbsent(this.keyProvider.getStructuredBase(), new HashMap());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            for (Rfc5424Parser.Sd_paramContext paramContext : ctx.sd_param()) {
                paramMap.put(((Rfc5424Parser.SdParamContext)paramContext).param_name().getText(), ((Rfc5424Parser.SdParamContext)paramContext).param_value().getText());
            }
            ((Map)this.msgMap.get(this.keyProvider.getStructuredBase())).put(id, paramMap);
        }
    }

    @Override
    public void exitMsg_any(Rfc5424Parser.Msg_anyContext ctx) {
        this.msgMap.put(this.keyProvider.getMessage(), ctx.getText().trim());
    }

    @Override
    public void exitMsg_utf8(Rfc5424Parser.Msg_utf8Context ctx) {
        this.msgMap.put(this.keyProvider.getMessage(), ctx.getText().trim());
    }

    private void handleNil(Supplier<String> supplier) {
        if (this.nilPolicy == NilPolicy.DASH) {
            this.msgMap.put(supplier.get(), DASH);
        } else if (this.nilPolicy == NilPolicy.NULL) {
            this.msgMap.put(supplier.get(), null);
        }
    }
}

