/*
 * Decompiled with CFR 0.152.
 */
package com.github.palindromicity.syslog;

import com.github.palindromicity.syslog.AllowableDeviations;
import com.github.palindromicity.syslog.DefaultKeyProvider;
import com.github.palindromicity.syslog.KeyProvider;
import com.github.palindromicity.syslog.NilPolicy;
import com.github.palindromicity.syslog.Rfc5424SyslogParser;
import com.github.palindromicity.syslog.StructuredDataPolicy;
import com.github.palindromicity.syslog.SyslogParser;
import java.util.EnumSet;

public class SyslogParserBuilder {
    private EnumSet<AllowableDeviations> deviations = EnumSet.of(AllowableDeviations.NONE);
    private KeyProvider keyProvider = new DefaultKeyProvider();
    private NilPolicy nilPolicy = NilPolicy.OMIT;
    private StructuredDataPolicy structuredDataPolicy = StructuredDataPolicy.FLATTEN;

    public SyslogParserBuilder withDeviations(EnumSet<AllowableDeviations> specification) {
        this.deviations = specification;
        return this;
    }

    public SyslogParserBuilder withKeyProvider(KeyProvider keyProvider) {
        this.keyProvider = keyProvider;
        return this;
    }

    public SyslogParserBuilder withNilPolicy(NilPolicy nilPolicy) {
        this.nilPolicy = nilPolicy;
        return this;
    }

    public SyslogParserBuilder withStructuredDataPolicy(StructuredDataPolicy structuredDataPolicy) {
        this.structuredDataPolicy = structuredDataPolicy;
        return this;
    }

    public SyslogParser build() {
        return new Rfc5424SyslogParser(this.keyProvider, this.nilPolicy, this.structuredDataPolicy, this.deviations);
    }
}

