/*
 * Decompiled with CFR 0.152.
 */
package com.github.palindromicity.syslog;

import com.github.palindromicity.syslog.AllowableDeviations;
import com.github.palindromicity.syslog.KeyProvider;
import com.github.palindromicity.syslog.NilPolicy;
import com.github.palindromicity.syslog.StructuredDataPolicy;
import com.github.palindromicity.syslog.SyslogParser;
import com.github.palindromicity.syslog.dsl.DefaultErrorListener;
import com.github.palindromicity.syslog.dsl.Syslog5424Listener;
import com.github.palindromicity.syslog.dsl.generated.Rfc5424Lexer;
import com.github.palindromicity.syslog.dsl.generated.Rfc5424Parser;
import com.github.palindromicity.syslog.util.Validate;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

class Rfc5424SyslogParser
implements SyslogParser {
    private KeyProvider keyProvider;
    private NilPolicy nilPolicy = NilPolicy.OMIT;
    private StructuredDataPolicy structuredDataPolicy = StructuredDataPolicy.FLATTEN;
    private EnumSet<AllowableDeviations> deviations;

    Rfc5424SyslogParser(KeyProvider keyProvider) {
        this(keyProvider, null, null, EnumSet.of(AllowableDeviations.NONE));
    }

    Rfc5424SyslogParser(KeyProvider keyProvider, NilPolicy nilPolicy, StructuredDataPolicy structuredDataPolicy) {
        this(keyProvider, nilPolicy, structuredDataPolicy, EnumSet.of(AllowableDeviations.NONE));
    }

    Rfc5424SyslogParser(KeyProvider keyProvider, NilPolicy nilPolicy, StructuredDataPolicy structuredDataPolicy, EnumSet<AllowableDeviations> deviations) {
        Validate.notNull(keyProvider, "keyProvider");
        this.keyProvider = keyProvider;
        if (nilPolicy != null) {
            this.nilPolicy = nilPolicy;
        }
        if (structuredDataPolicy != null) {
            this.structuredDataPolicy = structuredDataPolicy;
        }
        this.deviations = deviations;
    }

    @Override
    public Map<String, Object> parseLine(String syslogLine) {
        Validate.notBlank(syslogLine, "syslogLine");
        Rfc5424Lexer lexer = new Rfc5424Lexer((CharStream)CharStreams.fromString((String)syslogLine));
        lexer.removeErrorListeners();
        lexer.addErrorListener(new DefaultErrorListener());
        Rfc5424Parser parser = new Rfc5424Parser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        Syslog5424Listener listener = new Syslog5424Listener(this.keyProvider, this.nilPolicy, this.structuredDataPolicy, this.deviations);
        parser.addParseListener(listener);
        parser.removeErrorListeners();
        parser.addErrorListener(new DefaultErrorListener());
        parser.syslog_msg();
        return listener.getMsgMap();
    }

    @Override
    public void parseLine(String line, Consumer<Map<String, Object>> consumer) {
        Validate.notNull(consumer, "consumer");
        consumer.accept(this.parseLine(line));
    }

    @Override
    public List<Map<String, Object>> parseLines(Reader reader) {
        Validate.notNull(reader, "reader");
        return new BufferedReader(reader).lines().map(this::parseLine).collect(Collectors.toList());
    }

    @Override
    public void parseLines(Reader reader, Consumer<Map<String, Object>> consumer) {
        Validate.notNull(reader, "reader");
        Validate.notNull(consumer, "consumer");
        new BufferedReader(reader).lines().map(this::parseLine).forEach(consumer);
    }

    @Override
    public void parseLines(Reader reader, Consumer<Map<String, Object>> messageConsumer, BiConsumer<String, Throwable> errorConsumer) {
        Validate.notNull(reader, "reader");
        Validate.notNull(reader, "messageConsumer");
        Validate.notNull(reader, "errorConsumer");
        List<String> lines = new BufferedReader(reader).lines().collect(Collectors.toList());
        lines.forEach(line -> {
            try {
                messageConsumer.accept(this.parseLine((String)line));
            }
            catch (Throwable throwable) {
                errorConsumer.accept((String)line, throwable);
            }
        });
    }
}

