/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.autoconfigure;

import com.github.pagehelper.autoconfigure.PageHelperProperties;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="pagehelper")
public class PageHelperStandardProperties {
    private final PageHelperProperties properties;
    private Boolean offsetAsPageNum;
    private Boolean rowBoundsWithCount;
    private Boolean pageSizeZero;
    private Boolean reasonable;
    private Boolean supportMethodsArguments;
    private String dialect;
    private String helperDialect;
    private Boolean autoRuntimeDialect;
    private Boolean autoDialect;
    private Boolean closeConn;
    private String params;
    private Boolean defaultCount;
    private String dialectAlias;
    private String autoDialectClass;
    private Boolean useSqlserver2012;
    private String countColumn;
    private String replaceSql;
    private String sqlCacheClass;
    private String boundSqlInterceptors;
    private Boolean keepOrderBy;
    private Boolean keepSubSelectOrderBy;
    private String sqlParser;
    private Boolean asyncCount;
    private String countSqlParser;

    @Autowired
    public PageHelperStandardProperties(PageHelperProperties properties) {
        this.properties = properties;
    }

    public PageHelperProperties getProperties() {
        return this.properties;
    }

    public Boolean getOffsetAsPageNum() {
        return this.offsetAsPageNum;
    }

    public void setOffsetAsPageNum(Boolean offsetAsPageNum) {
        this.offsetAsPageNum = offsetAsPageNum;
        Optional.ofNullable(offsetAsPageNum).ifPresent(this.properties::setOffsetAsPageNum);
    }

    public Boolean getRowBoundsWithCount() {
        return this.rowBoundsWithCount;
    }

    public void setRowBoundsWithCount(Boolean rowBoundsWithCount) {
        this.rowBoundsWithCount = rowBoundsWithCount;
        Optional.ofNullable(rowBoundsWithCount).ifPresent(this.properties::setRowBoundsWithCount);
    }

    public Boolean getPageSizeZero() {
        return this.pageSizeZero;
    }

    public void setPageSizeZero(Boolean pageSizeZero) {
        this.pageSizeZero = pageSizeZero;
        Optional.ofNullable(pageSizeZero).ifPresent(this.properties::setPageSizeZero);
    }

    public Boolean getReasonable() {
        return this.reasonable;
    }

    public void setReasonable(Boolean reasonable) {
        this.reasonable = reasonable;
        Optional.ofNullable(reasonable).ifPresent(this.properties::setReasonable);
    }

    public Boolean getSupportMethodsArguments() {
        return this.supportMethodsArguments;
    }

    public void setSupportMethodsArguments(Boolean supportMethodsArguments) {
        this.supportMethodsArguments = supportMethodsArguments;
        Optional.ofNullable(supportMethodsArguments).ifPresent(this.properties::setSupportMethodsArguments);
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
        Optional.ofNullable(dialect).ifPresent(this.properties::setDialect);
    }

    public String getHelperDialect() {
        return this.helperDialect;
    }

    public void setHelperDialect(String helperDialect) {
        this.helperDialect = helperDialect;
        Optional.ofNullable(helperDialect).ifPresent(this.properties::setHelperDialect);
    }

    public Boolean getAutoRuntimeDialect() {
        return this.autoRuntimeDialect;
    }

    public void setAutoRuntimeDialect(Boolean autoRuntimeDialect) {
        this.autoRuntimeDialect = autoRuntimeDialect;
        Optional.ofNullable(autoRuntimeDialect).ifPresent(this.properties::setAutoRuntimeDialect);
    }

    public Boolean getAutoDialect() {
        return this.autoDialect;
    }

    public void setAutoDialect(Boolean autoDialect) {
        this.autoDialect = autoDialect;
        Optional.ofNullable(autoDialect).ifPresent(this.properties::setAutoDialect);
    }

    public Boolean getCloseConn() {
        return this.closeConn;
    }

    public void setCloseConn(Boolean closeConn) {
        this.closeConn = closeConn;
        Optional.ofNullable(closeConn).ifPresent(this.properties::setCloseConn);
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
        Optional.ofNullable(params).ifPresent(this.properties::setParams);
    }

    public Boolean getDefaultCount() {
        return this.defaultCount;
    }

    public void setDefaultCount(Boolean defaultCount) {
        this.defaultCount = defaultCount;
        Optional.ofNullable(defaultCount).ifPresent(this.properties::setDefaultCount);
    }

    public String getDialectAlias() {
        return this.dialectAlias;
    }

    public void setDialectAlias(String dialectAlias) {
        this.dialectAlias = dialectAlias;
        Optional.ofNullable(dialectAlias).ifPresent(this.properties::setDialectAlias);
    }

    public String getAutoDialectClass() {
        return this.autoDialectClass;
    }

    public void setAutoDialectClass(String autoDialectClass) {
        this.autoDialectClass = autoDialectClass;
        Optional.ofNullable(autoDialectClass).ifPresent(this.properties::setAutoDialectClass);
    }

    public Boolean getUseSqlserver2012() {
        return this.useSqlserver2012;
    }

    public void setUseSqlserver2012(Boolean useSqlserver2012) {
        this.useSqlserver2012 = useSqlserver2012;
        Optional.ofNullable(useSqlserver2012).ifPresent(v -> this.properties.setProperty("useSqlserver2012", v.toString()));
    }

    public String getCountColumn() {
        return this.countColumn;
    }

    public void setCountColumn(String countColumn) {
        this.countColumn = countColumn;
        Optional.ofNullable(countColumn).ifPresent(v -> this.properties.setProperty("countColumn", (String)v));
    }

    public String getReplaceSql() {
        return this.replaceSql;
    }

    public void setReplaceSql(String replaceSql) {
        this.replaceSql = replaceSql;
        Optional.ofNullable(replaceSql).ifPresent(v -> this.properties.setProperty("replaceSql", (String)v));
    }

    public String getSqlCacheClass() {
        return this.sqlCacheClass;
    }

    public void setSqlCacheClass(String sqlCacheClass) {
        this.sqlCacheClass = sqlCacheClass;
        Optional.ofNullable(sqlCacheClass).ifPresent(v -> this.properties.setProperty("sqlCacheClass", (String)v));
    }

    public String getBoundSqlInterceptors() {
        return this.boundSqlInterceptors;
    }

    public void setBoundSqlInterceptors(String boundSqlInterceptors) {
        this.boundSqlInterceptors = boundSqlInterceptors;
        Optional.ofNullable(boundSqlInterceptors).ifPresent(v -> this.properties.setProperty("boundSqlInterceptors", (String)v));
    }

    public Boolean getKeepOrderBy() {
        return this.keepOrderBy;
    }

    public void setKeepOrderBy(Boolean keepOrderBy) {
        this.keepOrderBy = keepOrderBy;
        Optional.ofNullable(keepOrderBy).ifPresent(v -> this.properties.setProperty("keepOrderBy", v.toString()));
    }

    public Boolean getKeepSubSelectOrderBy() {
        return this.keepSubSelectOrderBy;
    }

    public void setKeepSubSelectOrderBy(Boolean keepSubSelectOrderBy) {
        this.keepSubSelectOrderBy = keepSubSelectOrderBy;
        Optional.ofNullable(keepSubSelectOrderBy).ifPresent(v -> this.properties.setProperty("keepSubSelectOrderBy", v.toString()));
    }

    public String getSqlParser() {
        return this.sqlParser;
    }

    public void setSqlParser(String sqlParser) {
        this.sqlParser = sqlParser;
        Optional.ofNullable(sqlParser).ifPresent(v -> this.properties.setProperty("sqlParser", (String)v));
    }

    public Boolean getAsyncCount() {
        return this.asyncCount;
    }

    public void setAsyncCount(Boolean asyncCount) {
        this.asyncCount = asyncCount;
        Optional.ofNullable(asyncCount).ifPresent(v -> this.properties.setProperty("asyncCount", v.toString()));
    }

    public String getCountSqlParser() {
        return this.countSqlParser;
    }

    public void setCountSqlParser(String countSqlParser) {
        this.countSqlParser = countSqlParser;
        Optional.ofNullable(countSqlParser).ifPresent(v -> this.properties.setProperty("countSqlParser", (String)v));
    }
}

