/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.support.annotation.FloatRange;
import io.codetail.animation.Force;

final class SpringForce
implements Force {
    public static final float STIFFNESS_HIGH = 10000.0f;
    public static final float STIFFNESS_MEDIUM = 1500.0f;
    public static final float STIFFNESS_LOW = 200.0f;
    public static final float STIFFNESS_VERY_LOW = 50.0f;
    public static final float DAMPING_RATIO_HIGH_BOUNCY = 0.2f;
    public static final float DAMPING_RATIO_MEDIUM_BOUNCY = 0.5f;
    public static final float DAMPING_RATIO_LOW_BOUNCY = 0.75f;
    public static final float DAMPING_RATIO_NO_BOUNCY = 1.0f;
    private static final double VELOCITY_THRESHOLD_MULTIPLIER = 62.5;
    static final double VALUE_THRESHOLD_IN_PIXEL = 0.75;
    static final double VALUE_THRESHOLD_ALPHA = 0.0029411764705882353;
    static final double VALUE_THRESHOLD_SCALE = 0.0015;
    static final double VALUE_THRESHOLD_ROTATION = 0.0020833333333333333;
    double mNaturalFreq = Math.sqrt(1500.0);
    double mDampingRatio = 0.5;
    private static final double UNSET = Double.MAX_VALUE;
    private boolean mInitialized = false;
    private double mValueThreshold = 0.75;
    private double mVelocityThreshold = 46.875;
    private double mGammaPlus;
    private double mGammaMinus;
    private double mDampedFreq;
    private double mFinalPosition = Double.MAX_VALUE;
    private final MassState mMassState = new MassState();

    public SpringForce() {
    }

    public SpringForce(float finalPosition) {
        this.mFinalPosition = finalPosition;
    }

    public SpringForce setStiffness(@FloatRange(from=0.0) float stiffness) {
        if (stiffness < 0.0f) {
            throw new IllegalArgumentException("Spring stiffness constant cannot be negative");
        }
        this.mNaturalFreq = Math.sqrt(stiffness);
        this.mInitialized = false;
        return this;
    }

    public float getStiffness() {
        return (float)(this.mNaturalFreq * this.mNaturalFreq);
    }

    public SpringForce setDampingRatio(@FloatRange(from=0.0) float dampingRatio) {
        if (dampingRatio < 0.0f) {
            throw new IllegalArgumentException("Damping ratio must be non-negative");
        }
        this.mDampingRatio = dampingRatio;
        this.mInitialized = false;
        return this;
    }

    public float getDampingRatio() {
        return (float)this.mDampingRatio;
    }

    public SpringForce setFinalPosition(float finalPosition) {
        this.mFinalPosition = finalPosition;
        return this;
    }

    public float getFinalPosition() {
        return (float)this.mFinalPosition;
    }

    @Override
    public float getAcceleration(float lastDisplacement, float lastVelocity) {
        double k = this.mNaturalFreq * this.mNaturalFreq;
        double c = 2.0 * this.mNaturalFreq * this.mDampingRatio;
        return (float)(-k * (double)(lastDisplacement -= this.getFinalPosition()) - c * (double)lastVelocity);
    }

    @Override
    public boolean isAtEquilibrium(float value, float velocity) {
        return (double)Math.abs(velocity) < this.mVelocityThreshold && (double)Math.abs(value - this.getFinalPosition()) < this.mValueThreshold;
    }

    private void init() {
        if (this.mInitialized) {
            return;
        }
        if (this.mFinalPosition == Double.MAX_VALUE) {
            throw new IllegalStateException("Error: Final position of the spring must be set before the animation starts");
        }
        if (this.mDampingRatio > 1.0) {
            this.mGammaPlus = -this.mDampingRatio * this.mNaturalFreq + this.mNaturalFreq * Math.sqrt(this.mDampingRatio * this.mDampingRatio - 1.0);
            this.mGammaMinus = -this.mDampingRatio * this.mNaturalFreq - this.mNaturalFreq * Math.sqrt(this.mDampingRatio * this.mDampingRatio - 1.0);
        } else if (this.mDampingRatio >= 0.0 && this.mDampingRatio < 1.0) {
            this.mDampedFreq = this.mNaturalFreq * Math.sqrt(1.0 - this.mDampingRatio * this.mDampingRatio);
        }
        this.mInitialized = true;
    }

    MassState updateValues(double lastDisplacement, double lastVelocity, long timeElapsed) {
        double currentVelocity;
        double displacement;
        this.init();
        double deltaT = (double)timeElapsed / 1000.0;
        lastDisplacement -= this.mFinalPosition;
        if (this.mDampingRatio > 1.0) {
            double coeffA = lastDisplacement - (this.mGammaMinus * lastDisplacement - lastVelocity) / (this.mGammaMinus - this.mGammaPlus);
            double coeffB = (this.mGammaMinus * lastDisplacement - lastVelocity) / (this.mGammaMinus - this.mGammaPlus);
            displacement = coeffA * Math.pow(Math.E, this.mGammaMinus * deltaT) + coeffB * Math.pow(Math.E, this.mGammaPlus * deltaT);
            currentVelocity = coeffA * this.mGammaMinus * Math.pow(Math.E, this.mGammaMinus * deltaT) + coeffB * this.mGammaPlus * Math.pow(Math.E, this.mGammaPlus * deltaT);
        } else if (this.mDampingRatio == 1.0) {
            double coeffA = lastDisplacement;
            double coeffB = lastVelocity + this.mNaturalFreq * lastDisplacement;
            displacement = (coeffA + coeffB * deltaT) * Math.pow(Math.E, -this.mNaturalFreq * deltaT);
            currentVelocity = (coeffA + coeffB * deltaT) * Math.pow(Math.E, -this.mNaturalFreq * deltaT) * -this.mNaturalFreq + coeffB * Math.pow(Math.E, -this.mNaturalFreq * deltaT);
        } else {
            double cosCoeff = lastDisplacement;
            double sinCoeff = 1.0 / this.mDampedFreq * (this.mDampingRatio * this.mNaturalFreq * lastDisplacement + lastVelocity);
            displacement = Math.pow(Math.E, -this.mDampingRatio * this.mNaturalFreq * deltaT) * (cosCoeff * Math.cos(this.mDampedFreq * deltaT) + sinCoeff * Math.sin(this.mDampedFreq * deltaT));
            currentVelocity = displacement * -this.mNaturalFreq * this.mDampingRatio + Math.pow(Math.E, -this.mDampingRatio * this.mNaturalFreq * deltaT) * (-this.mDampedFreq * cosCoeff * Math.sin(this.mDampedFreq * deltaT) + this.mDampedFreq * sinCoeff * Math.cos(this.mDampedFreq * deltaT));
        }
        this.mMassState.mValue = (float)(displacement + this.mFinalPosition);
        this.mMassState.mVelocity = (float)currentVelocity;
        return this.mMassState;
    }

    void setDefaultThreshold(double threshold) {
        this.mValueThreshold = Math.abs(threshold);
        this.mVelocityThreshold = this.mValueThreshold * 62.5;
    }

    static class MassState {
        float mValue;
        float mVelocity;

        MassState() {
        }
    }
}

