/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.animation.Animator;
import android.animation.ValueAnimator;
import io.codetail.animation.DynamicAnimation;

class DynamicAnimator<T extends DynamicAnimation<T>>
extends ValueAnimator
implements DynamicAnimation.OnAnimationEndListener {
    private final DynamicAnimation<T> animation;

    public DynamicAnimator(DynamicAnimation<T> animation) {
        this.animation = animation;
        this.animation.addEndListener(this);
    }

    public void start() {
        this.animation.start();
        for (Animator.AnimatorListener listener : this.getListeners()) {
            listener.onAnimationStart((Animator)this);
        }
    }

    public void cancel() {
        this.animation.cancel();
    }

    public boolean isRunning() {
        return this.animation.isRunning();
    }

    @Override
    public void onAnimationEnd(DynamicAnimation animation, boolean canceled, float value, float velocity) {
        for (Animator.AnimatorListener listener : this.getListeners()) {
            if (canceled) {
                listener.onAnimationCancel((Animator)this);
                continue;
            }
            listener.onAnimationEnd((Animator)this);
        }
    }
}

