/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.os.Build;
import android.os.Looper;
import android.util.AndroidRuntimeException;
import android.view.View;
import io.codetail.animation.AnimationHandler;
import java.util.ArrayList;

abstract class DynamicAnimation<T extends DynamicAnimation<T>>
implements AnimationHandler.AnimationFrameCallback {
    public static final ViewProperty TRANSLATION_X = new ViewProperty("translationX"){

        @Override
        public void setValue(View view, float value) {
            view.setTranslationX(value);
        }

        @Override
        public float getValue(View view) {
            return view.getTranslationX();
        }
    };
    public static final ViewProperty TRANSLATION_Y = new ViewProperty("translationY"){

        @Override
        public void setValue(View view, float value) {
            view.setTranslationY(value);
        }

        @Override
        public float getValue(View view) {
            return view.getTranslationY();
        }
    };
    public static final ViewProperty TRANSLATION_Z = new ViewProperty("translationZ"){

        @Override
        public void setValue(View view, float value) {
            if (DynamicAnimation.isZSupported()) {
                view.setTranslationZ(value);
            }
        }

        @Override
        public float getValue(View view) {
            if (DynamicAnimation.isZSupported()) {
                return view.getTranslationZ();
            }
            return 0.0f;
        }
    };
    public static final ViewProperty SCALE_X = new ViewProperty("scaleX"){

        @Override
        public void setValue(View view, float value) {
            view.setScaleX(value);
        }

        @Override
        public float getValue(View view) {
            return view.getScaleX();
        }
    };
    public static final ViewProperty SCALE_Y = new ViewProperty("scaleY"){

        @Override
        public void setValue(View view, float value) {
            view.setScaleY(value);
        }

        @Override
        public float getValue(View view) {
            return view.getScaleY();
        }
    };
    public static final ViewProperty ROTATION = new ViewProperty("rotation"){

        @Override
        public void setValue(View view, float value) {
            view.setRotation(value);
        }

        @Override
        public float getValue(View view) {
            return view.getRotation();
        }
    };
    public static final ViewProperty ROTATION_X = new ViewProperty("rotationX"){

        @Override
        public void setValue(View view, float value) {
            view.setRotationX(value);
        }

        @Override
        public float getValue(View view) {
            return view.getRotationX();
        }
    };
    public static final ViewProperty ROTATION_Y = new ViewProperty("rotationY"){

        @Override
        public void setValue(View view, float value) {
            view.setRotationY(value);
        }

        @Override
        public float getValue(View view) {
            return view.getRotationY();
        }
    };
    public static final ViewProperty X = new ViewProperty("x"){

        @Override
        public void setValue(View view, float value) {
            view.setX(value);
        }

        @Override
        public float getValue(View view) {
            return view.getX();
        }
    };
    public static final ViewProperty Y = new ViewProperty("y"){

        @Override
        public void setValue(View view, float value) {
            view.setY(value);
        }

        @Override
        public float getValue(View view) {
            return view.getY();
        }
    };
    public static final ViewProperty Z = new ViewProperty("z"){

        @Override
        public void setValue(View view, float value) {
            if (DynamicAnimation.isZSupported()) {
                view.setZ(value);
            }
        }

        @Override
        public float getValue(View view) {
            if (DynamicAnimation.isZSupported()) {
                return view.getZ();
            }
            return 0.0f;
        }
    };
    public static final ViewProperty ALPHA = new ViewProperty("alpha"){

        @Override
        public void setValue(View view, float value) {
            view.setAlpha(value);
        }

        @Override
        public float getValue(View view) {
            return view.getAlpha();
        }
    };
    public static final ViewProperty SCROLL_X = new ViewProperty("scrollX"){

        @Override
        public void setValue(View view, float value) {
            view.setScrollX((int)value);
        }

        @Override
        public float getValue(View view) {
            return view.getScrollX();
        }
    };
    public static final ViewProperty SCROLL_Y = new ViewProperty("scrollY"){

        @Override
        public void setValue(View view, float value) {
            view.setScrollY((int)value);
        }

        @Override
        public float getValue(View view) {
            return view.getScrollY();
        }
    };
    private static final float UNSET = Float.MAX_VALUE;
    float mVelocity = 0.0f;
    float mValue = Float.MAX_VALUE;
    boolean mStartValueIsSet = false;
    final Object mTarget;
    final Property mViewProperty;
    boolean mRunning = false;
    float mMaxValue = Float.MAX_VALUE;
    float mMinValue = -this.mMaxValue;
    private long mLastFrameTime = 0L;
    private final ArrayList<OnAnimationEndListener> mEndListeners = new ArrayList();
    private final ArrayList<OnAnimationUpdateListener> mUpdateListeners = new ArrayList();

    <T> DynamicAnimation(T view, Property<T> property) {
        this.mTarget = view;
        this.mViewProperty = property;
    }

    public T setStartValue(float startValue) {
        this.mValue = startValue;
        this.mStartValueIsSet = true;
        return (T)this;
    }

    public T setStartVelocity(float startVelocity) {
        this.mVelocity = startVelocity;
        return (T)this;
    }

    public T setMaxValue(float max) {
        this.mMaxValue = max;
        return (T)this;
    }

    public T setMinValue(float min) {
        this.mMinValue = min;
        return (T)this;
    }

    public T addEndListener(OnAnimationEndListener listener) {
        if (!this.mEndListeners.contains(listener)) {
            this.mEndListeners.add(listener);
        }
        return (T)this;
    }

    public void removeEndListener(OnAnimationEndListener listener) {
        DynamicAnimation.removeEntry(this.mEndListeners, listener);
    }

    public T addUpdateListener(OnAnimationUpdateListener listener) {
        if (this.isRunning()) {
            throw new UnsupportedOperationException("Error: Update listeners must be added beforethe animation.");
        }
        if (!this.mUpdateListeners.contains(listener)) {
            this.mUpdateListeners.add(listener);
        }
        return (T)this;
    }

    public void removeUpdateListener(OnAnimationUpdateListener listener) {
        DynamicAnimation.removeEntry(this.mUpdateListeners, listener);
    }

    private static <T> void removeNullEntries(ArrayList<T> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get(i) != null) continue;
            list.remove(i);
        }
    }

    private static <T> void removeEntry(ArrayList<T> list, T entry) {
        int id = list.indexOf(entry);
        if (id >= 0) {
            list.set(id, null);
        }
    }

    public void start() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new AndroidRuntimeException("Animations may only be started on the main thread");
        }
        if (!this.mRunning) {
            this.startAnimationInternal();
        }
    }

    public void cancel() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new AndroidRuntimeException("Animations may only be canceled on the main thread");
        }
        if (this.mRunning) {
            this.endAnimationInternal(true);
        }
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    private void startAnimationInternal() {
        if (!this.mRunning) {
            this.mRunning = true;
            if (!this.mStartValueIsSet) {
                this.mValue = this.getPropertyValue();
            }
            if (this.mValue > this.mMaxValue || this.mValue < this.mMinValue) {
                throw new IllegalArgumentException("Starting value need to be in between min value and max value");
            }
            AnimationHandler.getInstance().addAnimationFrameCallback(this, 0L);
        }
    }

    @Override
    public boolean doAnimationFrame(long frameTime) {
        if (this.mLastFrameTime == 0L) {
            this.mLastFrameTime = frameTime;
            if (this.mStartValueIsSet) {
                this.setPropertyValue(this.mValue);
            }
            return false;
        }
        long deltaT = frameTime - this.mLastFrameTime;
        this.mLastFrameTime = frameTime;
        boolean finished = this.updateValueAndVelocity(deltaT);
        this.mValue = Math.min(this.mValue, this.mMaxValue);
        this.mValue = Math.max(this.mValue, this.mMinValue);
        this.setPropertyValue(this.mValue);
        if (finished) {
            this.endAnimationInternal(false);
        }
        return finished;
    }

    boolean updateValueAndVelocity(long deltaT) {
        if (deltaT < 0L) {
            throw new UnsupportedOperationException("Cannot play animation backwards");
        }
        if (deltaT == 0L) {
            return false;
        }
        long increment = Math.min(4L, deltaT);
        int totalT = (int)deltaT;
        int i = 0;
        float velocity = this.mVelocity;
        float value = this.mValue;
        i = 0;
        while (i <= totalT) {
            float acceleration = this.getAcceleration(value, velocity);
            float newVelocity = acceleration * (float)increment / 1000.0f + velocity;
            value += (velocity + newVelocity) / 2.0f * (float)increment / 1000.0f;
            velocity = newVelocity;
            if (i == totalT) break;
            if ((long)i + increment > deltaT) {
                increment = totalT - i;
            }
            i = (int)((long)i + increment);
        }
        this.mVelocity = velocity;
        this.mValue = value;
        return this.isAtEquilibrium(this.mValue, this.mVelocity);
    }

    private void endAnimationInternal(boolean canceled) {
        this.mRunning = false;
        AnimationHandler.getInstance().removeCallback(this);
        this.mLastFrameTime = 0L;
        this.mStartValueIsSet = false;
        for (int i = 0; i < this.mEndListeners.size(); ++i) {
            if (this.mEndListeners.get(i) == null) continue;
            this.mEndListeners.get(i).onAnimationEnd(this, canceled, this.mValue, this.mVelocity);
        }
        DynamicAnimation.removeNullEntries(this.mEndListeners);
    }

    private static boolean isZSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    void setPropertyValue(float value) {
        this.mViewProperty.setValue(this.mTarget, value);
        for (int i = 0; i < this.mUpdateListeners.size(); ++i) {
            if (this.mUpdateListeners.get(i) == null) continue;
            this.mUpdateListeners.get(i).onAnimationUpdate(this, this.mValue, this.mVelocity);
        }
        DynamicAnimation.removeNullEntries(this.mUpdateListeners);
    }

    private float getPropertyValue() {
        return this.mViewProperty.getValue(this.mTarget);
    }

    abstract float getAcceleration(float var1, float var2);

    abstract boolean isAtEquilibrium(float var1, float var2);

    public static interface OnAnimationUpdateListener {
        public void onAnimationUpdate(DynamicAnimation var1, float var2, float var3);
    }

    public static interface OnAnimationEndListener {
        public void onAnimationEnd(DynamicAnimation var1, boolean var2, float var3, float var4);
    }

    public static abstract class ViewProperty
    extends Property<View> {
        public ViewProperty(String name) {
            super(name);
        }
    }

    public static abstract class Property<T> {
        private final String mPropertyName;

        public Property(String name) {
            this.mPropertyName = name;
        }

        public abstract void setValue(T var1, float var2);

        public abstract float getValue(T var1);
    }
}

