/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.os.SystemClock;
import android.support.v4.util.SimpleArrayMap;
import android.view.Choreographer;
import java.util.ArrayList;

class AnimationHandler {
    private final SimpleArrayMap<AnimationFrameCallback, Long> mDelayedCallbackStartTime = new SimpleArrayMap();
    public static final ThreadLocal<AnimationHandler> sAnimatorHandler = new ThreadLocal();
    private final ArrayList<AnimationFrameCallback> mAnimationCallbacks = new ArrayList();
    private AnimationFrameCallbackProvider mProvider;
    private long mCurrentFrameTime = 0L;
    private final Choreographer.FrameCallback mFrameCallback = new Choreographer.FrameCallback(){

        public void doFrame(long frameTimeNanos) {
            AnimationHandler.this.mCurrentFrameTime = System.currentTimeMillis();
            AnimationHandler.this.doAnimationFrame(AnimationHandler.this.mCurrentFrameTime);
            if (AnimationHandler.this.mAnimationCallbacks.size() > 0) {
                AnimationHandler.this.getProvider().postFrameCallback(this);
            }
        }
    };
    private boolean mListDirty = false;

    AnimationHandler() {
    }

    public static AnimationHandler getInstance() {
        if (sAnimatorHandler.get() == null) {
            sAnimatorHandler.set(new AnimationHandler());
        }
        return sAnimatorHandler.get();
    }

    public static long getFrameTime() {
        if (sAnimatorHandler.get() == null) {
            return 0L;
        }
        return AnimationHandler.sAnimatorHandler.get().mCurrentFrameTime;
    }

    public void setProvider(AnimationFrameCallbackProvider provider) {
        this.mProvider = provider == null ? new MyFrameCallbackProvider() : provider;
    }

    private AnimationFrameCallbackProvider getProvider() {
        if (this.mProvider == null) {
            this.mProvider = new MyFrameCallbackProvider();
        }
        return this.mProvider;
    }

    public void addAnimationFrameCallback(AnimationFrameCallback callback, long delay) {
        if (this.mAnimationCallbacks.size() == 0) {
            this.getProvider().postFrameCallback(this.mFrameCallback);
        }
        if (!this.mAnimationCallbacks.contains(callback)) {
            this.mAnimationCallbacks.add(callback);
        }
        if (delay > 0L) {
            this.mDelayedCallbackStartTime.put((Object)callback, (Object)(SystemClock.uptimeMillis() + delay));
        }
    }

    public void removeCallback(AnimationFrameCallback callback) {
        this.mDelayedCallbackStartTime.remove((Object)callback);
        int id = this.mAnimationCallbacks.indexOf(callback);
        if (id >= 0) {
            this.mAnimationCallbacks.set(id, null);
            this.mListDirty = true;
        }
    }

    private void doAnimationFrame(long frameTime) {
        long currentTime = SystemClock.uptimeMillis();
        for (int i = 0; i < this.mAnimationCallbacks.size(); ++i) {
            AnimationFrameCallback callback = this.mAnimationCallbacks.get(i);
            if (callback == null || !this.isCallbackDue(callback, currentTime)) continue;
            callback.doAnimationFrame(frameTime);
        }
        this.cleanUpList();
    }

    private boolean isCallbackDue(AnimationFrameCallback callback, long currentTime) {
        Long startTime = (Long)this.mDelayedCallbackStartTime.get((Object)callback);
        if (startTime == null) {
            return true;
        }
        if (startTime < currentTime) {
            this.mDelayedCallbackStartTime.remove((Object)callback);
            return true;
        }
        return false;
    }

    private void cleanUpList() {
        if (this.mListDirty) {
            for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
                if (this.mAnimationCallbacks.get(i) != null) continue;
                this.mAnimationCallbacks.remove(i);
            }
            this.mListDirty = false;
        }
    }

    private int getCallbackSize() {
        int count = 0;
        int size = this.mAnimationCallbacks.size();
        for (int i = size - 1; i >= 0; --i) {
            if (this.mAnimationCallbacks.get(i) == null) continue;
            ++count;
        }
        return count;
    }

    public static interface AnimationFrameCallbackProvider {
        public void postFrameCallback(Choreographer.FrameCallback var1);
    }

    private class MyFrameCallbackProvider
    implements AnimationFrameCallbackProvider {
        final Choreographer mChoreographer = Choreographer.getInstance();

        private MyFrameCallbackProvider() {
        }

        @Override
        public void postFrameCallback(Choreographer.FrameCallback callback) {
            this.mChoreographer.postFrameCallback(callback);
        }
    }

    static interface AnimationFrameCallback {
        public boolean doAnimationFrame(long var1);
    }
}

