/*
 * Decompiled with CFR 0.152.
 */
package dreamers.graphics;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import dreamers.graphics.Ripple;
import dreamers.graphics.RippleBackground;
import dreamers.graphics.TouchTracker;
import java.util.Arrays;

public class RippleDrawable
extends Drawable {
    private static final PorterDuffXfermode DST_IN = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private static final PorterDuffXfermode SRC_ATOP = new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP);
    private static final PorterDuffXfermode SRC_OVER = new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER);
    public static final int RADIUS_AUTO = -1;
    private static final int MAX_RIPPLES = 10;
    private final Rect mHotspotBounds = new Rect();
    ColorStateList mColor = ColorStateList.valueOf((int)-65281);
    int mMaxRadius = -1;
    private Drawable mContent;
    private Drawable mMask;
    private RippleBackground mBackground;
    private boolean mBackgroundActive;
    private Ripple mRipple;
    private boolean mRippleActive;
    private float mPendingX;
    private float mPendingY;
    private boolean mHasPending;
    private Ripple[] mExitingRipples;
    private int mExitingRipplesCount = 0;
    private Paint mRipplePaint;
    private Paint mMaskingPaint;
    private float mDensity = 1.0f;
    private boolean mOverrideBounds;
    private boolean mNeedsDraw;

    public RippleDrawable(ColorStateList color) {
        this.setColor(color);
    }

    public RippleDrawable(ColorStateList color, Drawable content) {
        this(color);
        this.mContent = content;
    }

    public void jumpToCurrentState() {
        boolean needsDraw;
        if (Build.VERSION.SDK_INT > 11) {
            super.jumpToCurrentState();
        }
        if (this.mRipple != null) {
            this.mRipple.jump();
        }
        if (this.mBackground != null) {
            this.mBackground.jump();
        }
        this.mNeedsDraw = needsDraw = this.cancelExitingRipples();
        this.invalidateSelf();
    }

    private boolean cancelExitingRipples() {
        int count = this.mExitingRipplesCount;
        Object[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].cancel();
        }
        if (ripples != null) {
            Arrays.fill(ripples, 0, count, null);
        }
        this.mExitingRipplesCount = 0;
        return false;
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return -3;
    }

    protected boolean onStateChange(int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        boolean enabled = false;
        boolean pressed = false;
        boolean focused = false;
        for (int state : stateSet) {
            if (state == 16842910) {
                enabled = true;
            }
            if (state == 16842908) {
                focused = true;
            }
            if (state != 16842919) continue;
            pressed = true;
        }
        this.setRippleActive(enabled && pressed);
        this.setBackgroundActive(focused || enabled && pressed);
        return changed;
    }

    private void setRippleActive(boolean active) {
        if (this.mRippleActive != active) {
            this.mRippleActive = active;
            if (active) {
                this.tryRippleEnter();
            } else {
                this.tryRippleExit();
            }
        }
    }

    private void setBackgroundActive(boolean active) {
        if (this.mBackgroundActive != active) {
            this.mBackgroundActive = active;
            if (active) {
                this.tryBackgroundEnter();
            } else {
                this.tryBackgroundExit();
            }
        }
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (!this.mOverrideBounds) {
            this.mHotspotBounds.set(bounds);
            this.onHotspotBoundsChanged();
        }
        this.invalidateSelf();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (!visible) {
            this.clearHotspots();
        } else if (changed) {
            if (this.mRippleActive) {
                this.tryRippleEnter();
            }
            if (this.mBackgroundActive) {
                this.tryBackgroundEnter();
            }
        }
        return changed;
    }

    public void setHotspot(float x, float y) {
        if (this.mRipple == null || this.mBackground == null) {
            this.mPendingX = x;
            this.mPendingY = y;
            this.mHasPending = true;
        }
        if (this.mRipple != null) {
            this.mRipple.move(x, y);
        }
    }

    private void tryRippleEnter() {
        if (this.mExitingRipplesCount >= 10) {
            return;
        }
        if (this.mRipple == null) {
            float y;
            float x;
            if (this.mHasPending) {
                this.mHasPending = false;
                x = this.mPendingX;
                y = this.mPendingY;
            } else {
                x = this.mHotspotBounds.exactCenterX();
                y = this.mHotspotBounds.exactCenterY();
            }
            this.mRipple = new Ripple(this, this.mHotspotBounds, x, y);
        }
        int color = this.mColor.getColorForState(this.getState(), 0);
        this.mRipple.setup(this.mMaxRadius, color, this.mDensity);
        this.mRipple.enter();
    }

    private void tryRippleExit() {
        if (this.mRipple != null) {
            if (this.mExitingRipples == null) {
                this.mExitingRipples = new Ripple[10];
            }
            this.mExitingRipples[this.mExitingRipplesCount++] = this.mRipple;
            this.mRipple.exit();
            this.mRipple = null;
        }
    }

    private void clearHotspots() {
        boolean needsDraw = false;
        if (this.mRipple != null) {
            needsDraw = false;
            this.mRipple.cancel();
            this.mRipple = null;
        }
        if (this.mBackground != null) {
            needsDraw = this.mBackground.isHardwareAnimating();
            this.mBackground.cancel();
            this.mBackground = null;
        }
        this.mNeedsDraw = needsDraw |= this.cancelExitingRipples();
        this.invalidateSelf();
    }

    public void setHotspotBounds(int left, int top, int right, int bottom) {
        this.mOverrideBounds = true;
        this.mHotspotBounds.set(left, top, right, bottom);
        this.onHotspotBoundsChanged();
    }

    public void getHotspotBounds(Rect outRect) {
        outRect.set(this.mHotspotBounds);
    }

    private void onHotspotBoundsChanged() {
        int count = this.mExitingRipplesCount;
        Ripple[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].onHotspotBoundsChanged();
        }
        if (this.mRipple != null) {
            this.mRipple.onHotspotBoundsChanged();
        }
        if (this.mBackground != null) {
            this.mBackground.onHotspotBoundsChanged();
        }
    }

    private void tryBackgroundEnter() {
        if (this.mBackground == null) {
            this.mBackground = new RippleBackground(this, this.mHotspotBounds);
        }
        int color = this.mColor.getColorForState(this.getState(), 0);
        this.mBackground.setup(this.mMaxRadius, color, this.mDensity);
        this.mBackground.enter();
    }

    private void tryBackgroundExit() {
        if (this.mBackground != null) {
            this.mBackground.exit();
        }
    }

    public void draw(Canvas canvas) {
        int rippleLayer;
        PorterDuffXfermode xfermode;
        int backgroundLayer;
        boolean hasMask = this.mMask != null;
        boolean drawNonMaskContent = this.mContent != null;
        boolean drawMask = hasMask && this.mMask.getOpacity() != -1;
        Rect bounds = this.getDirtyBounds();
        int saveCount = canvas.save(2);
        canvas.clipRect(bounds);
        if (drawNonMaskContent) {
            this.drawContentLayer(canvas, bounds, SRC_OVER);
        }
        if ((backgroundLayer = this.drawBackgroundLayer(canvas, bounds, xfermode = hasMask || !drawNonMaskContent ? SRC_OVER : SRC_ATOP, drawMask)) >= 0) {
            if (drawMask) {
                this.drawMaskingLayer(canvas, bounds, DST_IN);
            }
            canvas.restoreToCount(backgroundLayer);
        }
        if ((rippleLayer = this.drawRippleLayer(canvas, bounds, xfermode)) >= 0) {
            if (drawMask) {
                this.drawMaskingLayer(canvas, bounds, DST_IN);
            }
            canvas.restoreToCount(rippleLayer);
        }
        if (this.mNeedsDraw) {
            canvas.drawColor(0);
            this.invalidateSelf();
        }
        this.mNeedsDraw = false;
        canvas.restoreToCount(saveCount);
    }

    void removeRipple(Ripple ripple) {
        Ripple[] ripples = this.mExitingRipples;
        int count = this.mExitingRipplesCount--;
        int index = this.getRippleIndex(ripple);
        if (index >= 0) {
            System.arraycopy(ripples, index + 1, ripples, index, count - (index + 1));
            ripples[count - 1] = null;
            this.invalidateSelf();
        }
    }

    private int getRippleIndex(Ripple ripple) {
        Ripple[] ripples = this.mExitingRipples;
        int count = this.mExitingRipplesCount;
        for (int i = 0; i < count; ++i) {
            if (ripples[i] != ripple) continue;
            return i;
        }
        return -1;
    }

    private int drawContentLayer(Canvas canvas, Rect bounds, PorterDuffXfermode mode) {
        this.mContent.setBounds(bounds);
        this.mContent.draw(canvas);
        return -1;
    }

    private int drawBackgroundLayer(Canvas canvas, Rect bounds, PorterDuffXfermode mode, boolean drawMask) {
        int saveCount = -1;
        if (this.mBackground != null && this.mBackground.shouldDraw()) {
            if (drawMask || mode != SRC_OVER) {
                // empty if block
            }
            float x = this.mHotspotBounds.exactCenterX();
            float y = this.mHotspotBounds.exactCenterY();
            canvas.translate(x, y);
            this.mBackground.draw(canvas, this.getRipplePaint());
            canvas.translate(-x, -y);
        }
        return saveCount;
    }

    private int drawRippleLayer(Canvas canvas, Rect bounds, PorterDuffXfermode mode) {
        boolean drewRipples = false;
        int restoreToCount = -1;
        int restoreTranslate = -1;
        int count = this.mExitingRipplesCount;
        Ripple[] ripples = this.mExitingRipples;
        for (int i = 0; i <= count; ++i) {
            Ripple ripple;
            if (i < count) {
                ripple = ripples[i];
            } else {
                if (this.mRipple == null) continue;
                ripple = this.mRipple;
            }
            if (restoreToCount < 0) {
                Paint maskingPaint = this.getMaskingPaint(mode);
                int color = this.mColor.getColorForState(this.getState(), 0);
                int alpha = Color.alpha((int)color);
                maskingPaint.setAlpha(alpha / 2);
                restoreTranslate = canvas.save();
                canvas.translate(this.mHotspotBounds.exactCenterX(), this.mHotspotBounds.exactCenterY());
            }
            drewRipples |= ripple.draw(canvas, this.getRipplePaint());
        }
        if (restoreTranslate >= 0) {
            canvas.restoreToCount(restoreTranslate);
        }
        if (restoreToCount >= 0 && !drewRipples) {
            canvas.restoreToCount(restoreToCount);
            restoreToCount = -1;
        }
        return restoreToCount;
    }

    private int drawMaskingLayer(Canvas canvas, Rect bounds, PorterDuffXfermode mode) {
        canvas.drawColor(0);
        this.mMask.draw(canvas);
        return -1;
    }

    private Paint getRipplePaint() {
        if (this.mRipplePaint == null) {
            this.mRipplePaint = new Paint();
            this.mRipplePaint.setAntiAlias(true);
        }
        return this.mRipplePaint;
    }

    private Paint getMaskingPaint(PorterDuffXfermode xfermode) {
        if (this.mMaskingPaint == null) {
            this.mMaskingPaint = new Paint();
        }
        this.mMaskingPaint.setXfermode((Xfermode)xfermode);
        this.mMaskingPaint.setAlpha(255);
        return this.mMaskingPaint;
    }

    private void setTargetDensity(DisplayMetrics metrics) {
        if (this.mDensity != metrics.density) {
            this.mDensity = metrics.density;
            this.invalidateSelf();
        }
    }

    public boolean isStateful() {
        return true;
    }

    public void setColor(ColorStateList color) {
        this.mColor = color;
        this.invalidateSelf();
    }

    public Rect getDirtyBounds() {
        return this.getBounds();
    }

    public void setMaxRadius(int maxRadius) {
        if (maxRadius != -1 && maxRadius < 0) {
            throw new IllegalArgumentException("maxRadius must be RADIUS_AUTO or >= 0");
        }
        this.mMaxRadius = maxRadius;
    }

    public int getMaxRadius() {
        return this.mMaxRadius;
    }

    public static RippleDrawable createRipple(View target, int color) {
        return RippleDrawable.For(target, color);
    }

    public static RippleDrawable For(View target, int color) {
        return RippleDrawable.makeFor(target, ColorStateList.valueOf((int)color));
    }

    public static RippleDrawable makeFor(View target, ColorStateList colors) {
        return RippleDrawable.makeFor(target, colors, false);
    }

    public static RippleDrawable makeFor(View target, ColorStateList colors, boolean parentIsScrollContainer) {
        RippleDrawable drawable = new RippleDrawable(colors, target.getBackground());
        TouchTracker tracker = new TouchTracker(drawable);
        tracker.setInsideScrollContainer(parentIsScrollContainer);
        RippleDrawable.setBackground(target, drawable);
        target.setOnTouchListener((View.OnTouchListener)tracker);
        return drawable;
    }

    private static void setBackground(View target, Drawable drawable) {
        if (Build.VERSION.SDK_INT > 16) {
            target.setBackground(drawable);
        } else {
            target.setBackgroundDrawable(drawable);
        }
    }
}

