/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Region;
import android.os.Build;
import android.util.Property;
import android.view.View;
import java.util.HashMap;
import java.util.Map;

public class ViewRevealManager {
    public static final ClipRadiusProperty REVEAL = new ClipRadiusProperty();
    private final ViewTransformation viewTransformation;
    private final Map<View, RevealValues> targets = new HashMap<View, RevealValues>();
    private final Map<Animator, RevealValues> animators = new HashMap<Animator, RevealValues>();
    private final AnimatorListenerAdapter animatorCallback = new AnimatorListenerAdapter(){

        public void onAnimationStart(Animator animation) {
            RevealValues values = ViewRevealManager.this.getValues(animation);
            values.clip(true);
        }

        public void onAnimationCancel(Animator animation) {
            this.endAnimation(animation);
        }

        public void onAnimationEnd(Animator animation) {
            this.endAnimation(animation);
        }

        private void endAnimation(Animator animation) {
            RevealValues values = ViewRevealManager.this.getValues(animation);
            values.clip(false);
            ViewRevealManager.this.targets.remove(values.target);
            ViewRevealManager.this.animators.remove(animation);
        }
    };

    public ViewRevealManager() {
        this(new PathTransformation());
    }

    public ViewRevealManager(ViewTransformation transformation) {
        this.viewTransformation = transformation;
    }

    Animator dispatchCreateAnimator(RevealValues data) {
        Animator animator = this.createAnimator(data);
        this.targets.put(data.target(), data);
        this.animators.put(animator, data);
        return animator;
    }

    protected Animator createAnimator(RevealValues data) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)data, (Property)REVEAL, (float[])new float[]{data.startRadius, data.endRadius});
        animator.addListener((Animator.AnimatorListener)this.getAnimatorCallback());
        return animator;
    }

    protected final AnimatorListenerAdapter getAnimatorCallback() {
        return this.animatorCallback;
    }

    protected final RevealValues getValues(Animator animator) {
        return this.animators.get(animator);
    }

    protected final RevealValues getValues(View view) {
        return this.targets.get(view);
    }

    protected boolean overrideNativeAnimator() {
        return false;
    }

    public boolean isClipped(View child) {
        RevealValues data = this.getValues(child);
        return data != null && data.isClipping();
    }

    public final boolean transform(Canvas canvas, View child) {
        RevealValues revealData = this.targets.get(child);
        if (revealData == null) {
            return false;
        }
        if (revealData.target != child) {
            throw new IllegalStateException("Inconsistency detected, contains incorrect target view");
        }
        if (!revealData.clipping) {
            return false;
        }
        return this.viewTransformation.transform(canvas, child, revealData);
    }

    static class ChangeViewLayerTypeAdapter
    extends AnimatorListenerAdapter {
        private RevealValues viewData;
        private int featuredLayerType;
        private int originalLayerType;

        ChangeViewLayerTypeAdapter(RevealValues viewData, int layerType) {
            this.viewData = viewData;
            this.featuredLayerType = layerType;
            this.originalLayerType = viewData.target.getLayerType();
        }

        public void onAnimationStart(Animator animation) {
            this.viewData.target().setLayerType(this.featuredLayerType, null);
        }

        public void onAnimationCancel(Animator animation) {
            this.viewData.target().setLayerType(this.originalLayerType, null);
        }

        public void onAnimationEnd(Animator animation) {
            this.viewData.target().setLayerType(this.originalLayerType, null);
        }
    }

    private static final class ClipRadiusProperty
    extends Property<RevealValues, Float> {
        ClipRadiusProperty() {
            super(Float.class, "supportCircularReveal");
        }

        public void set(RevealValues data, Float value) {
            data.radius = value.floatValue();
            data.target.invalidate();
        }

        public Float get(RevealValues v) {
            return Float.valueOf(v.radius());
        }
    }

    public static class PathTransformation
    implements ViewTransformation {
        private final Path path = new Path();
        private Region.Op op = Region.Op.REPLACE;

        public Region.Op op() {
            return this.op;
        }

        public void op(Region.Op op) {
            this.op = op;
        }

        @Override
        public boolean transform(Canvas canvas, View child, RevealValues values) {
            this.path.reset();
            this.path.addCircle(child.getX() + (float)values.centerX, child.getY() + (float)values.centerY, values.radius, Path.Direction.CW);
            canvas.clipPath(this.path, this.op);
            if (Build.VERSION.SDK_INT >= 21) {
                child.invalidateOutline();
            }
            return false;
        }
    }

    static interface ViewTransformation {
        public boolean transform(Canvas var1, View var2, RevealValues var3);
    }

    public static final class RevealValues {
        private static final Paint debugPaint = new Paint(1);
        final int centerX;
        final int centerY;
        final float startRadius;
        final float endRadius;
        boolean clipping;
        float radius;
        View target;

        public RevealValues(View target, int centerX, int centerY, float startRadius, float endRadius) {
            this.target = target;
            this.centerX = centerX;
            this.centerY = centerY;
            this.startRadius = startRadius;
            this.endRadius = endRadius;
        }

        public void radius(float radius) {
            this.radius = radius;
        }

        public float radius() {
            return this.radius;
        }

        public View target() {
            return this.target;
        }

        public void clip(boolean clipping) {
            this.clipping = clipping;
        }

        public boolean isClipping() {
            return this.clipping;
        }

        static {
            debugPaint.setColor(-16711936);
            debugPaint.setStyle(Paint.Style.FILL);
            debugPaint.setStrokeWidth(2.0f);
        }
    }
}

