/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.os.Build;
import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import java.util.ArrayList;

public class Animator {
    public static final boolean LOLLIPOP = Build.VERSION.SDK_INT >= 21;
    android.animation.Animator mNativeAnimator;
    com.nineoldandroids.animation.Animator mSupportAnimator;

    public Animator(com.nineoldandroids.animation.Animator animator) {
        this.mSupportAnimator = animator;
    }

    public Animator(android.animation.Animator animator) {
        this.mNativeAnimator = animator;
    }

    @TargetApi(value=11)
    public Animator setInterpolator(Interpolator interpolator) {
        if (LOLLIPOP) {
            this.mNativeAnimator.setInterpolator((TimeInterpolator)interpolator);
        } else {
            this.mSupportAnimator.setInterpolator(interpolator);
        }
        return this;
    }

    @TargetApi(value=11)
    public Animator setDuration(int duration) {
        if (LOLLIPOP) {
            this.mNativeAnimator.setDuration((long)duration);
        } else {
            this.mSupportAnimator.setDuration((long)duration);
        }
        return this;
    }

    public Animator addListener(Animator.AnimatorListener listener) {
        this.mSupportAnimator.addListener(listener);
        return this;
    }

    @TargetApi(value=11)
    public Animator addListener(Animator.AnimatorListener listener) {
        this.mNativeAnimator.addListener(listener);
        return this;
    }

    public Animator addPauseListener(Animator.AnimatorPauseListener pauseListener) {
        this.mSupportAnimator.addPauseListener(pauseListener);
        return this;
    }

    @TargetApi(value=19)
    public Animator addPauseListener(Animator.AnimatorPauseListener pauseListener) {
        this.mNativeAnimator.addPauseListener(pauseListener);
        return this;
    }

    @TargetApi(value=11)
    public long getDuration() {
        if (LOLLIPOP) {
            return this.mNativeAnimator.getDuration();
        }
        return this.mSupportAnimator.getDuration();
    }

    @TargetApi(value=11)
    public boolean isRunning() {
        if (LOLLIPOP) {
            return this.mNativeAnimator.isRunning();
        }
        return this.mSupportAnimator.isRunning();
    }

    public boolean isStarted() {
        return this.isRunning();
    }

    public void removeListener(Animator.AnimatorListener listener) {
        this.mSupportAnimator.removeListener(listener);
    }

    @TargetApi(value=11)
    public void removeListener(Animator.AnimatorListener listener) {
        this.mNativeAnimator.removeListener(listener);
    }

    public ArrayList<Animator.AnimatorListener> getSupportListeners() {
        return this.mSupportAnimator.getListeners();
    }

    @TargetApi(value=11)
    public ArrayList<Animator.AnimatorListener> getNativeListeners() {
        return this.mNativeAnimator.getListeners();
    }

    public void removePauseListener(Animator.AnimatorPauseListener listener) {
        this.mSupportAnimator.removePauseListener(listener);
    }

    @TargetApi(value=19)
    public void removePauseListener(Animator.AnimatorPauseListener listener) {
        this.mNativeAnimator.removePauseListener(listener);
    }

    @TargetApi(value=11)
    public void removeAllListeners() {
        if (LOLLIPOP) {
            this.mNativeAnimator.removeAllListeners();
        } else {
            this.mSupportAnimator.removeAllListeners();
        }
    }

    @TargetApi(value=11)
    public void start() {
        if (LOLLIPOP) {
            this.mNativeAnimator.start();
        } else {
            this.mSupportAnimator.start();
        }
    }

    public com.nineoldandroids.animation.Animator getSupportAnimator() {
        return this.mSupportAnimator;
    }

    public android.animation.Animator getNativeAnimator() {
        return this.mNativeAnimator;
    }
}

