/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.view.View;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.util.FloatProperty;
import io.codetail.animation.SupportAnimator;
import io.codetail.animation.ViewAnimationUtils;
import java.lang.ref.WeakReference;

public interface RevealAnimator {
    public static final RevealRadius CLIP_RADIUS = new RevealRadius();

    public void setClipOutlines(boolean var1);

    public void setCenter(int var1, int var2);

    public void setTarget(View var1);

    public void setRevealRadius(float var1);

    public float getRevealRadius();

    public void invalidate(Rect var1);

    public void setupStartValues();

    public void setRadius(float var1, float var2);

    public Rect getTargetBounds();

    public SupportAnimator startReverseAnimation();

    public static class RevealRadius
    extends FloatProperty<RevealAnimator> {
        public RevealRadius() {
            super("revealRadius");
        }

        public void setValue(RevealAnimator object, float value) {
            object.setRevealRadius(value);
        }

        public Float get(RevealAnimator object) {
            return Float.valueOf(object.getRevealRadius());
        }
    }

    public static class RevealFinishedJellyBeanMr2
    extends RevealFinishedIceCreamSandwich {
        @TargetApi(value=11)
        RevealFinishedJellyBeanMr2(RevealAnimator target, Rect bounds) {
            super(target, bounds);
            this.mFeaturedLayerType = 2;
        }
    }

    @TargetApi(value=11)
    public static class RevealFinishedIceCreamSandwich
    extends RevealFinishedGingerbread {
        int mFeaturedLayerType;
        int mLayerType;

        RevealFinishedIceCreamSandwich(RevealAnimator target, Rect bounds) {
            super(target, bounds);
            this.mLayerType = ((View)target).getLayerType();
            this.mFeaturedLayerType = 1;
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            this.onAnimationEnd(animation);
        }

        @Override
        public void onAnimationStart(Animator animation) {
            ((View)this.mReference.get()).setLayerType(this.mFeaturedLayerType, null);
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            ((View)this.mReference.get()).setLayerType(this.mLayerType, null);
            super.onAnimationEnd(animation);
        }
    }

    public static class RevealFinishedGingerbread
    extends ViewAnimationUtils.SimpleAnimationListener {
        WeakReference<RevealAnimator> mReference;
        volatile Rect mInvalidateBounds;

        RevealFinishedGingerbread(RevealAnimator target, Rect bounds) {
            this.mReference = new WeakReference<RevealAnimator>(target);
            this.mInvalidateBounds = bounds;
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            RevealAnimator target = (RevealAnimator)this.mReference.get();
            target.setupStartValues();
            target.invalidate(this.mInvalidateBounds);
        }
    }
}

