/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.annotation.ExcelCell;
import com.poiji.annotation.ExcelCellName;
import com.poiji.annotation.ExcelCellRange;
import com.poiji.annotation.ExcelRow;
import com.poiji.annotation.ExcelUnknownCells;
import com.poiji.config.Casting;
import com.poiji.config.Formatting;
import com.poiji.exception.IllegalCastException;
import com.poiji.option.PoijiOptions;
import com.poiji.util.AnnotationUtil;
import com.poiji.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.usermodel.XSSFComment;

final class PoijiHandler<T>
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private T instance;
    private final Consumer<? super T> consumer;
    private int internalRow;
    private int internalCount;
    private final int limit;
    private final Class<T> type;
    private final PoijiOptions options;
    private final Casting casting;
    private final Formatting formatting;
    private final Map<String, Integer> titleToIndex;
    private final Map<Integer, String> indexToTitle;
    private Map<String, Object> fieldInstances;
    private final Map<Integer, Field> columnToField;
    private final Map<Integer, Field> columnToSuperClassField;
    private final Set<ExcelCellName> excelCellNameAnnotations;

    PoijiHandler(Class<T> type, PoijiOptions options, Consumer<? super T> consumer) {
        this.type = type;
        this.options = options;
        this.consumer = consumer;
        this.limit = options.getLimit();
        this.casting = options.getCasting();
        this.formatting = options.getFormatting();
        this.titleToIndex = new HashMap<String, Integer>();
        this.indexToTitle = new HashMap<Integer, String>();
        this.columnToField = new HashMap<Integer, Field>();
        this.columnToSuperClassField = new HashMap<Integer, Field>();
        this.excelCellNameAnnotations = new HashSet<ExcelCellName>();
    }

    private void setFieldValue(String content, Class<? super T> subclass, int column) {
        if (subclass != Object.class) {
            if (this.setValue(content, subclass, column)) {
                return;
            }
            this.setFieldValue(content, subclass.getSuperclass(), column);
        }
    }

    private Object getInstance(Field field) {
        Object ins;
        if (this.fieldInstances.containsKey(field.getName())) {
            ins = this.fieldInstances.get(field.getName());
        } else {
            ins = ReflectUtil.newInstanceOf(field.getType());
            this.fieldInstances.put(field.getName(), ins);
        }
        return ins;
    }

    private boolean setValue(String content, Class<? super T> type, int column) {
        Field field2;
        Stream.of(type.getDeclaredFields()).filter(field -> field.getAnnotation(ExcelUnknownCells.class) == null).forEach(field -> {
            ExcelCellRange range;
            ExcelRow excelRow = field.getAnnotation(ExcelRow.class);
            if (excelRow != null) {
                Object o = this.casting.castValue((Field)field, String.valueOf(this.internalRow), this.internalRow, column, this.options);
                ReflectUtil.setFieldData(field, o, this.instance);
                this.columnToField.put(-1, (Field)field);
            }
            if ((range = field.getAnnotation(ExcelCellRange.class)) != null) {
                Object ins = this.getInstance((Field)field);
                for (Field f : field.getType().getDeclaredFields()) {
                    if (!this.setValue(f, column, content, ins)) continue;
                    ReflectUtil.setFieldData(field, ins, this.instance);
                    this.columnToField.put(column, f);
                    this.columnToSuperClassField.put(column, (Field)field);
                }
            } else if (this.setValue((Field)field, column, content, this.instance)) {
                this.columnToField.put(column, (Field)field);
            }
        });
        Stream.of(type.getDeclaredFields()).filter(field -> field.getAnnotation(ExcelUnknownCells.class) != null).forEach(field -> {
            if (!this.columnToField.containsKey(column)) {
                try {
                    Map<String, String> excelUnknownCellsMap;
                    field.setAccessible(true);
                    if (field.get(this.instance) == null) {
                        excelUnknownCellsMap = new HashMap();
                        ReflectUtil.setFieldData(field, excelUnknownCellsMap, this.instance);
                    } else {
                        excelUnknownCellsMap = (Map)field.get(this.instance);
                    }
                    excelUnknownCellsMap.put(this.indexToTitle.get(column), content);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalCastException("Could not read content of field " + field.getName() + " on Object {" + this.instance + "}");
                }
            }
        });
        if (this.columnToField.containsKey(-1)) {
            field2 = this.columnToField.get(-1);
            Object o = this.casting.castValue(field2, String.valueOf(this.internalRow), this.internalRow, column, this.options);
            ReflectUtil.setFieldData(field2, o, this.instance);
        }
        if (this.columnToField.containsKey(column) && this.columnToSuperClassField.containsKey(column)) {
            Object ins;
            field2 = this.columnToField.get(column);
            if (this.setValue(field2, column, content, ins = this.getInstance(this.columnToSuperClassField.get(column)))) {
                ReflectUtil.setFieldData(this.columnToSuperClassField.get(column), ins, this.instance);
                return true;
            }
            return this.setValue(field2, column, content, this.instance);
        }
        return false;
    }

    private boolean setValue(Field field, int column, String content, Object ins) {
        ExcelCell index = field.getAnnotation(ExcelCell.class);
        if (index != null) {
            if (column == index.value()) {
                Object o = this.casting.castValue(field, content, this.internalRow, column, this.options);
                ReflectUtil.setFieldData(field, o, ins);
                return true;
            }
        } else {
            ExcelCellName excelCellName = field.getAnnotation(ExcelCellName.class);
            if (excelCellName != null) {
                this.excelCellNameAnnotations.add(excelCellName);
                String titleName = this.formatting.transform(this.options, excelCellName.value());
                Integer titleColumn = this.titleToIndex.get(titleName);
                if (titleColumn != null && titleColumn == column) {
                    Object o = this.casting.castValue(field, content, this.internalRow, column, this.options);
                    ReflectUtil.setFieldData(field, o, ins);
                    return true;
                }
            }
        }
        return false;
    }

    public void startRow(int rowNum) {
        if (rowNum + 1 > this.options.skip()) {
            ++this.internalCount;
            this.instance = ReflectUtil.newInstanceOf(this.type);
            this.fieldInstances = new HashMap<String, Object>();
        }
    }

    public void endRow(int rowNum) {
        if (this.internalRow != rowNum) {
            return;
        }
        if (rowNum + 1 > this.options.skip()) {
            this.consumer.accept(this.instance);
        }
    }

    public void cell(String cellReference, String formattedValue, XSSFComment comment) {
        if (cellReference == null) {
            return;
        }
        CellAddress cellAddress = new CellAddress(cellReference);
        int row = cellAddress.getRow();
        int headerStart = this.options.getHeaderStart();
        int headerCount = this.options.getHeaderCount();
        int column = cellAddress.getColumn();
        if (row >= headerStart && row < headerStart + headerCount) {
            String transformedValue = this.formatting.transform(this.options, formattedValue);
            this.titleToIndex.put(transformedValue, column);
            this.indexToTitle.put(column, this.getTitleNameForMap(transformedValue, column));
        }
        if (row + 1 <= this.options.skip()) {
            return;
        }
        if (this.limit != 0 && this.internalCount > this.limit) {
            return;
        }
        this.internalRow = row;
        this.setFieldValue(formattedValue, this.type, column);
    }

    private String getTitleNameForMap(String cellContent, int columnIndex) {
        if (this.indexToTitle.containsValue(cellContent) || cellContent.isEmpty()) {
            return cellContent + "@" + columnIndex;
        }
        return cellContent;
    }

    public void headerFooter(String text, boolean isHeader, String tagName) {
    }

    public void endSheet() {
        AnnotationUtil.validateMandatoryNameColumns(this.options, this.formatting, this.type, this.titleToIndex, this.indexToTitle);
    }
}

