/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.util;

import com.poiji.annotation.ExcelCellName;
import com.poiji.config.Formatting;
import com.poiji.exception.HeaderMissingException;
import com.poiji.option.PoijiOptions;
import com.poiji.util.ReflectUtil;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public final class AnnotationUtil {
    private AnnotationUtil() {
    }

    public static <T> void validateMandatoryNameColumns(PoijiOptions options, Formatting formatting, Class<T> modelType, Collection<String> headerNames) {
        if (options.getNamedHeaderMandatory()) {
            Collection<ExcelCellName> excelCellNames = ReflectUtil.findRecursivePoijiAnnotations(modelType, ExcelCellName.class);
            BiPredicate<String, String> comparator = String::equals;
            Set missingHeaders = excelCellNames.stream().filter(excelCellName -> headerNames.stream().noneMatch(title -> comparator.test(formatting.transform(options, excelCellName.value()), (String)title))).map(ExcelCellName::value).collect(Collectors.toSet());
            if (!missingHeaders.isEmpty()) {
                throw new HeaderMissingException("Some headers are missing in the sheet: " + missingHeaders);
            }
        }
    }
}

