/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.annotation.ExcelCell;
import com.poiji.annotation.ExcelCellName;
import com.poiji.annotation.ExcelCellRange;
import com.poiji.annotation.ExcelRow;
import com.poiji.annotation.ExcelUnknownCells;
import com.poiji.bind.Unmarshaller;
import com.poiji.bind.mapping.PoijiWorkBook;
import com.poiji.config.Casting;
import com.poiji.exception.IllegalCastException;
import com.poiji.option.PoijiOptions;
import com.poiji.util.AnnotationUtil;
import com.poiji.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

abstract class HSSFUnmarshaller
extends PoijiWorkBook
implements Unmarshaller {
    private final DataFormatter dataFormatter;
    protected final PoijiOptions options;
    private final Casting casting;
    private final Map<String, Integer> columnIndexPerTitle;
    private final Map<Integer, String> titlePerColumnIndex;
    private final Map<Integer, String> caseSensitiveTitlePerColumnIndex;
    private final int limit;
    private int internalCount;

    HSSFUnmarshaller(PoijiOptions options) {
        this.options = options;
        this.limit = options.getLimit();
        this.dataFormatter = new DataFormatter();
        this.columnIndexPerTitle = new HashMap<String, Integer>();
        this.titlePerColumnIndex = new HashMap<Integer, String>();
        this.caseSensitiveTitlePerColumnIndex = new HashMap<Integer, String>();
        this.casting = options.getCasting();
    }

    @Override
    public <T> void unmarshal(Class<T> type, Consumer<? super T> consumer) {
        Workbook workbook = this.workbook();
        Optional<String> maybeSheetName = this.getSheetName(type, this.options);
        Sheet sheet = this.getSheetToProcess(workbook, this.options, maybeSheetName.orElse(null));
        int skip = this.options.skip();
        int maxPhysicalNumberOfRows = sheet.getPhysicalNumberOfRows() + 1 - skip;
        this.loadColumnTitles(sheet, maxPhysicalNumberOfRows);
        AnnotationUtil.validateMandatoryNameColumns(this.options, type, this.columnIndexPerTitle.keySet());
        for (Row currentRow : sheet) {
            if (this.skip(currentRow, skip) || this.isRowEmpty(currentRow)) continue;
            ++this.internalCount;
            if (this.limit != 0 && this.internalCount > this.limit) {
                return;
            }
            T instance = this.deserializeRowToInstance(currentRow, type);
            consumer.accept(instance);
        }
    }

    private Sheet getSheetToProcess(Workbook workbook, PoijiOptions options, String sheetName) {
        int nonHiddenSheetIndex = 0;
        int requestedIndex = options.sheetIndex();
        Sheet sheet = null;
        if (options.ignoreHiddenSheets()) {
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                if (workbook.isSheetHidden(i) || workbook.isSheetVeryHidden(i)) continue;
                if (sheetName == null ? nonHiddenSheetIndex == requestedIndex : workbook.getSheetName(i).equalsIgnoreCase(sheetName)) {
                    return workbook.getSheetAt(i);
                }
                ++nonHiddenSheetIndex;
            }
        } else {
            sheet = sheetName == null ? workbook.getSheetAt(requestedIndex) : workbook.getSheet(sheetName);
        }
        return sheet;
    }

    private void loadColumnTitles(Sheet sheet, int maxPhysicalNumberOfRows) {
        if (maxPhysicalNumberOfRows > 0) {
            int row = this.options.getHeaderStart();
            Row firstRow = sheet.getRow(row);
            for (Cell cell : firstRow) {
                int columnIndex = cell.getColumnIndex();
                this.caseSensitiveTitlePerColumnIndex.put(columnIndex, this.getTitleNameForMap(cell.getStringCellValue(), columnIndex));
                String titleName = this.options.getCaseInsensitive() ? cell.getStringCellValue().toLowerCase() : cell.getStringCellValue();
                this.columnIndexPerTitle.put(titleName, columnIndex);
                this.titlePerColumnIndex.put(columnIndex, this.getTitleNameForMap(titleName, columnIndex));
            }
        }
    }

    private String getTitleNameForMap(String cellContent, int columnIndex) {
        String titleName = this.titlePerColumnIndex.containsValue(cellContent) || cellContent.isEmpty() ? cellContent + "@" + columnIndex : cellContent;
        return titleName;
    }

    private <T> T deserializeRowToInstance(Row currentRow, Class<T> type) {
        T instance = ReflectUtil.newInstanceOf(type);
        return this.setFieldValuesFromRowIntoInstance(currentRow, type, instance);
    }

    private <T> T tailSetFieldValue(Row currentRow, Class<? super T> type, T instance) {
        ArrayList<Integer> mappedColumnIndices = new ArrayList<Integer>();
        ArrayList<Field> unknownCells = new ArrayList<Field>();
        for (Field field2 : type.getDeclaredFields()) {
            if (field2.getAnnotation(ExcelRow.class) != null) {
                int rowNum = currentRow.getRowNum();
                Object data = this.casting.castValue(field2.getType(), String.valueOf(rowNum), rowNum, -1, this.options);
                this.setFieldData(instance, field2, data);
                continue;
            }
            if (field2.getAnnotation(ExcelCellRange.class) != null) {
                Class<?> fieldType = field2.getType();
                Object fieldInstance = ReflectUtil.newInstanceOf(fieldType);
                for (Field fieldField : fieldType.getDeclaredFields()) {
                    mappedColumnIndices.add(this.tailSetFieldValue(currentRow, fieldInstance, fieldField));
                }
                this.setFieldData(instance, field2, fieldInstance);
                continue;
            }
            if (field2.getAnnotation(ExcelUnknownCells.class) != null) {
                unknownCells.add(field2);
                continue;
            }
            mappedColumnIndices.add(this.tailSetFieldValue(currentRow, instance, field2));
        }
        Map<String, String> excelUnknownCellsMap = StreamSupport.stream(Spliterators.spliteratorUnknownSize(currentRow.cellIterator(), 16), false).filter(cell -> !mappedColumnIndices.contains(cell.getColumnIndex())).filter(cell -> !cell.toString().isEmpty()).collect(Collectors.toMap(cell -> this.caseSensitiveTitlePerColumnIndex.get(cell.getColumnIndex()), Object::toString));
        unknownCells.forEach(field -> this.setFieldData(instance, (Field)field, excelUnknownCellsMap));
        return instance;
    }

    private <T> Integer tailSetFieldValue(Row currentRow, T instance, Field field) {
        Integer column = this.getFieldColumn(field);
        if (column != null) {
            this.constructTypeValue(currentRow, instance, field, column);
        }
        return column;
    }

    private Integer getFieldColumn(Field field) {
        ExcelCell index = field.getAnnotation(ExcelCell.class);
        Integer column = null;
        if (index != null) {
            column = index.value();
        } else {
            ExcelCellName excelCellName = field.getAnnotation(ExcelCellName.class);
            if (excelCellName != null) {
                String titleName = this.options.getCaseInsensitive() ? excelCellName.value().toLowerCase() : excelCellName.value();
                column = this.columnIndexPerTitle.get(titleName);
            }
        }
        return column;
    }

    private <T> void constructTypeValue(Row currentRow, T instance, Field field, int column) {
        Cell cell = currentRow.getCell(column);
        if (cell != null) {
            String value = this.dataFormatter.formatCellValue(cell);
            Object data = this.casting.castValue(field.getType(), value, currentRow.getRowNum(), column, this.options);
            this.setFieldData(instance, field, data);
        }
    }

    private <T> void setFieldData(T instance, Field field, Object data) {
        try {
            field.setAccessible(true);
            field.set(instance, data);
        }
        catch (IllegalAccessException e) {
            throw new IllegalCastException("Unexpected cast type {" + data + "} of field" + field.getName());
        }
    }

    private <T> T setFieldValuesFromRowIntoInstance(Row currentRow, Class<? super T> subclass, T instance) {
        return subclass == null ? instance : this.tailSetFieldValue(currentRow, subclass, this.setFieldValuesFromRowIntoInstance(currentRow, subclass.getSuperclass(), instance));
    }

    private boolean skip(Row currentRow, int skip) {
        return currentRow.getRowNum() + 1 <= skip;
    }

    private boolean isRowEmpty(Row row) {
        for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
            Cell cell = row.getCell(c, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }
}

