/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.config;

import com.poiji.config.Casting;
import com.poiji.config.DefaultCastingError;
import com.poiji.option.PoijiOptions;
import com.poiji.parser.Parsers;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class DefaultCasting
implements Casting {
    private final boolean errorLoggingEnabled;
    private final List<DefaultCastingError> errors = new ArrayList<DefaultCastingError>();

    public DefaultCasting() {
        this(false);
    }

    public DefaultCasting(boolean errorLoggingEnabled) {
        this.errorLoggingEnabled = errorLoggingEnabled;
    }

    private <T> T onError(String value, String sheetName, int row, int col, Exception exception, T defaultValue) {
        this.logError(value, defaultValue, sheetName, row, col, exception);
        return defaultValue;
    }

    private void logError(String value, Object defaultValue, String sheetName, int row, int col, Exception exception) {
        if (this.errorLoggingEnabled) {
            this.errors.add(new DefaultCastingError(value, defaultValue, sheetName, row, col, exception));
        }
    }

    private int primitiveIntegerValue(String value, String sheetName, int row, int col) {
        try {
            return Parsers.integers().parse(value).intValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, 0);
        }
    }

    private Integer integerValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Parsers.integers().parse(value).intValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, options.preferNullOverDefault() ? null : Integer.valueOf(0));
        }
    }

    private long primitiveLongValue(String value, String sheetName, int row, int col) {
        try {
            return Parsers.longs().parse(value).longValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, 0L);
        }
    }

    private Long longValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Parsers.longs().parse(value).longValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, options.preferNullOverDefault() ? null : Long.valueOf(0L));
        }
    }

    private double primitiveDoubleValue(String value, String sheetName, int row, int col) {
        try {
            return Parsers.numbers().parse(value).doubleValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, 0.0);
        }
    }

    private Double doubleValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Parsers.numbers().parse(value).doubleValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, options.preferNullOverDefault() ? null : Double.valueOf(0.0));
        }
    }

    private float primitiveFloatValue(String value, String sheetName, int row, int col) {
        try {
            return Parsers.numbers().parse(value).floatValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, Float.valueOf(0.0f)).floatValue();
        }
    }

    private Float floatValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Float.valueOf(Parsers.numbers().parse(value).floatValue());
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, options.preferNullOverDefault() ? null : Float.valueOf(0.0f));
        }
    }

    private BigDecimal bigDecimalValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Parsers.bigDecimals().parse(value);
        }
        catch (IllegalStateException | NumberFormatException e) {
            return this.onError(value, sheetName, row, col, e, options.preferNullOverDefault() ? null : BigDecimal.ZERO);
        }
    }

    private Date dateValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        if (options.getDateRegex() != null && !value.matches(options.getDateRegex())) {
            return options.preferNullOverDefault() ? null : Calendar.getInstance().getTime();
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(options.datePattern());
            sdf.setLenient(options.getDateLenient());
            return sdf.parse(value);
        }
        catch (ParseException e) {
            return this.onError(value, sheetName, row, col, e, options.preferNullOverDefault() ? null : Calendar.getInstance().getTime());
        }
    }

    private LocalDate localDateValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        if (options.getDateRegex() != null && !value.matches(options.getDateRegex())) {
            return options.preferNullOverDefault() ? null : LocalDate.now();
        }
        try {
            return LocalDate.parse(value, options.dateFormatter());
        }
        catch (DateTimeParseException e) {
            return this.onError(value, sheetName, row, col, e, options.preferNullOverDefault() ? null : LocalDate.now());
        }
    }

    private LocalDateTime localDateTimeValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        if (options.getDateTimeRegex() != null && !value.matches(options.getDateTimeRegex())) {
            return options.preferNullOverDefault() ? null : LocalDateTime.now();
        }
        try {
            return LocalDateTime.parse(value, options.dateTimeFormatter());
        }
        catch (DateTimeParseException e) {
            return this.onError(value, sheetName, row, col, e, options.preferNullOverDefault() ? null : LocalDateTime.now());
        }
    }

    private Object enumValue(String value, String sheetName, int row, int col, Class type) {
        return Arrays.stream(type.getEnumConstants()).filter(o -> ((Enum)o).name().equals(value)).findFirst().orElseGet(() -> {
            IllegalArgumentException e = new IllegalArgumentException("No enumeration " + type.getSimpleName() + "." + value);
            return this.onError(value, sheetName, row, col, e, null);
        });
    }

    public Object castValue(Class<?> fieldType, String value, PoijiOptions options) {
        return this.castValue(fieldType, value, -1, -1, options);
    }

    @Override
    public Object castValue(Class<?> fieldType, String rawValue, int row, int col, PoijiOptions options) {
        String value;
        String sheetName = options.getSheetName();
        String string = value = options.trimCellValue() ? rawValue.trim() : rawValue;
        Object o = fieldType == Integer.TYPE ? Integer.valueOf(this.primitiveIntegerValue(value, sheetName, row, col)) : (fieldType == Integer.class ? this.integerValue(value, sheetName, row, col, options) : (fieldType == BigDecimal.class ? this.bigDecimalValue(value, sheetName, row, col, options) : (fieldType == Long.TYPE ? Long.valueOf(this.primitiveLongValue(value, sheetName, row, col)) : (fieldType == Long.class ? this.longValue(value, sheetName, row, col, options) : (fieldType == Double.TYPE ? Double.valueOf(this.primitiveDoubleValue(value, sheetName, row, col)) : (fieldType == Double.class ? this.doubleValue(value, sheetName, row, col, options) : (fieldType == Float.TYPE ? Float.valueOf(this.primitiveFloatValue(value, sheetName, row, col)) : (fieldType == Float.class ? this.floatValue(value, sheetName, row, col, options) : (fieldType == Boolean.TYPE || fieldType == Boolean.class ? Boolean.valueOf(value) : (fieldType == Date.class ? this.dateValue(value, sheetName, row, col, options) : (fieldType == LocalDate.class ? this.localDateValue(value, sheetName, row, col, options) : (fieldType == LocalDateTime.class ? this.localDateTimeValue(value, sheetName, row, col, options) : (fieldType.isEnum() ? this.enumValue(value, sheetName, row, col, fieldType) : (value.isEmpty() ? (options.preferNullOverDefault() ? null : value) : value))))))))))))));
        return o;
    }

    public boolean isErrorLoggingEnabled() {
        return this.errorLoggingEnabled;
    }

    public List<DefaultCastingError> getErrors() {
        if (this.errorLoggingEnabled) {
            return Collections.unmodifiableList(this.errors);
        }
        throw new IllegalStateException("logging not enabled");
    }
}

