/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.bind.Unmarshaller;
import com.poiji.bind.mapping.PoijiHandler;
import com.poiji.bind.mapping.PoijiNumberFormat;
import com.poiji.bind.mapping.SheetNameExtractor;
import com.poiji.bind.mapping.WorkBookContentHandler;
import com.poiji.bind.mapping.WorkBookSheet;
import com.poiji.bind.mapping.XSSFSheetXMLPoijiHandler;
import com.poiji.exception.LimitCrossedException;
import com.poiji.exception.PoijiException;
import com.poiji.option.PoijiOptions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

abstract class XSSFUnmarshaller
implements Unmarshaller {
    protected final PoijiOptions options;

    XSSFUnmarshaller(PoijiOptions options) {
        this.options = options;
    }

    protected <T> void unmarshal0(Class<T> type, Consumer<? super T> consumer, OPCPackage open) throws ParserConfigurationException, IOException, SAXException, OpenXML4JException {
        ReadOnlySharedStringsTable readOnlySharedStringsTable = new ReadOnlySharedStringsTable(open);
        XSSFReader workbookReader = new XSSFReader(open);
        StylesTable styles = workbookReader.getStylesTable();
        PoijiNumberFormat poijiNumberFormat = this.options.getPoijiNumberFormat();
        if (poijiNumberFormat != null) {
            poijiNumberFormat.overrideExcelNumberFormats(styles);
        }
        XMLReader reader = XMLHelper.newXMLReader();
        InputSource is = new InputSource(workbookReader.getWorkbookData());
        reader.setContentHandler(new WorkBookContentHandler(this.options));
        reader.parse(is);
        WorkBookContentHandler wbch = (WorkBookContentHandler)reader.getContentHandler();
        List<WorkBookSheet> sheets = wbch.getSheets();
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)workbookReader.getSheetsData();
        int sheetCounter = 0;
        Optional<String> maybeSheetName = SheetNameExtractor.getSheetName(type, this.options);
        if (!maybeSheetName.isPresent()) {
            int requestedIndex = this.options.sheetIndex();
            int nonHiddenSheetIndex = 0;
            while (iter.hasNext()) {
                try (InputStream stream = iter.next();){
                    WorkBookSheet wbs = sheets.get(sheetCounter);
                    if (wbs.getState().equals("visible")) {
                        if (nonHiddenSheetIndex == requestedIndex) {
                            this.processSheet(styles, reader, readOnlySharedStringsTable, type, stream, consumer);
                            return;
                        }
                        ++nonHiddenSheetIndex;
                    }
                }
                ++sheetCounter;
            }
        } else {
            String sheetName = maybeSheetName.get();
            while (iter.hasNext()) {
                try (InputStream stream = iter.next();){
                    WorkBookSheet wbs = sheets.get(sheetCounter);
                    if (wbs.getState().equals("visible") && iter.getSheetName().equalsIgnoreCase(sheetName)) {
                        this.processSheet(styles, reader, readOnlySharedStringsTable, type, stream, consumer);
                        return;
                    }
                }
                ++sheetCounter;
            }
        }
    }

    private <T> void processSheet(StylesTable styles, XMLReader reader, ReadOnlySharedStringsTable readOnlySharedStringsTable, Class<T> type, InputStream sheetInputStream, Consumer<? super T> consumer) {
        DataFormatter formatter = new DataFormatter();
        InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            PoijiHandler<? super T> poijiHandler = new PoijiHandler<T>(type, this.options, consumer);
            XSSFSheetXMLPoijiHandler contentHandler = new XSSFSheetXMLPoijiHandler((Styles)styles, null, (SharedStrings)readOnlySharedStringsTable, poijiHandler, formatter, false, this.options);
            reader.setContentHandler((ContentHandler)((Object)contentHandler));
            reader.parse(sheetSource);
        }
        catch (LimitCrossedException e) {
            IOUtils.closeQuietly((Closeable)sheetInputStream);
        }
        catch (IOException | SAXException e) {
            throw new PoijiException("Problem occurred while reading data", e);
        }
    }

    protected <T> void listOfEncryptedItems(Class<T> type, Consumer<? super T> consumer, POIFSFileSystem fs) throws IOException {
        InputStream stream = DocumentFactoryHelper.getDecryptedStream((POIFSFileSystem)fs, (String)this.options.getPassword());
        try (OPCPackage open = OPCPackage.open((InputStream)stream);){
            this.unmarshal0(type, consumer, open);
        }
        catch (IOException | ParserConfigurationException | OpenXML4JException | SAXException e) {
            IOUtils.closeQuietly((Closeable)fs);
            throw new PoijiException("Problem occurred while reading data", e);
        }
    }

    protected abstract <T> void returnFromExcelFile(Class<T> var1, Consumer<? super T> var2);

    protected abstract <T> void returnFromEncryptedFile(Class<T> var1, Consumer<? super T> var2);
}

