/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind;

import com.poiji.bind.PoijiFile;
import com.poiji.bind.PoijiInputStream;
import com.poiji.bind.Unmarshaller;
import com.poiji.bind.mapping.UnmarshallerHelper;
import com.poiji.exception.InvalidExcelFileExtension;
import com.poiji.exception.PoijiExcelType;
import com.poiji.option.PoijiOptions;
import com.poiji.util.Files;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class Poiji {
    private static final Files files = Files.getInstance();

    private Poiji() {
    }

    public static <T> List<T> fromExcel(File file, Class<T> type) {
        ArrayList list = new ArrayList();
        Poiji.fromExcel(file, type, list::add);
        return list;
    }

    public static <T> void fromExcel(File file, Class<T> type, Consumer<? super T> consumer) {
        Unmarshaller unmarshaller = Poiji.deserializer(file, PoijiOptions.PoijiOptionsBuilder.settings().build());
        unmarshaller.unmarshal(type, consumer);
    }

    public static <T> List<T> fromExcel(InputStream inputStream, PoijiExcelType excelType, Class<T> type) {
        ArrayList list = new ArrayList();
        Poiji.fromExcel(inputStream, excelType, type, list::add);
        return list;
    }

    public static <T> void fromExcel(InputStream inputStream, PoijiExcelType excelType, Class<T> type, Consumer<? super T> consumer) {
        Objects.requireNonNull(excelType);
        Unmarshaller unmarshaller = Poiji.deserializer(inputStream, excelType, PoijiOptions.PoijiOptionsBuilder.settings().build());
        unmarshaller.unmarshal(type, consumer);
    }

    public static <T> List<T> fromExcel(File file, Class<T> type, PoijiOptions options) {
        ArrayList list = new ArrayList();
        Poiji.fromExcel(file, type, options, list::add);
        return list;
    }

    public static <T> void fromExcel(File file, Class<T> type, PoijiOptions options, Consumer<? super T> consumer) {
        Unmarshaller unmarshaller = Poiji.deserializer(file, options);
        unmarshaller.unmarshal(type, consumer);
    }

    public static <T> List<T> fromExcel(InputStream inputStream, PoijiExcelType excelType, Class<T> type, PoijiOptions options) {
        Objects.requireNonNull(excelType);
        ArrayList list = new ArrayList();
        Poiji.fromExcel(inputStream, excelType, type, options, list::add);
        return list;
    }

    public static <T> void fromExcel(InputStream inputStream, PoijiExcelType excelType, Class<T> type, PoijiOptions options, Consumer<? super T> consumer) {
        Objects.requireNonNull(excelType);
        Unmarshaller unmarshaller = Poiji.deserializer(inputStream, excelType, options);
        unmarshaller.unmarshal(type, consumer);
    }

    private static Unmarshaller deserializer(File file, PoijiOptions options) {
        PoijiFile<File> poijiFile = new PoijiFile<File>(file);
        String extension = files.getExtension(file.getName());
        if (".xls".equals(extension)) {
            return UnmarshallerHelper.HSSFInstance(poijiFile, options);
        }
        if (".xlsx".equals(extension)) {
            return UnmarshallerHelper.XSSFInstance(poijiFile, options);
        }
        throw new InvalidExcelFileExtension("Invalid file extension (" + extension + "), excepted .xls or .xlsx");
    }

    private static Unmarshaller deserializer(InputStream inputStream, PoijiExcelType excelType, PoijiOptions options) {
        PoijiInputStream<InputStream> poijiInputStream = new PoijiInputStream<InputStream>(inputStream);
        if (excelType == PoijiExcelType.XLS) {
            return UnmarshallerHelper.HSSFInstance(poijiInputStream, options);
        }
        if (excelType == PoijiExcelType.XLSX) {
            return UnmarshallerHelper.XSSFInstance(poijiInputStream, options);
        }
        throw new InvalidExcelFileExtension("Invalid file extension (" + (Object)((Object)excelType) + "), excepted .xls or .xlsx");
    }
}

