/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng;

import android.graphics.BitmapFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import oupson.apng.Apng;
import oupson.apng.Frame;
import oupson.apng.chunks.IHDR;
import oupson.apng.chunks.fcTL;
import oupson.apng.exceptions.BadApng;
import oupson.apng.exceptions.BadCRC;
import oupson.apng.exceptions.NotApngException;
import oupson.apng.utils.Utils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Loupson/apng/APNGDisassembler;", "", "()V", "Companion", "apng_library_release"})
public final class APNGDisassembler {
    private static ArrayList<Byte> png;
    private static ArrayList<Byte> cover;
    private static float delay;
    private static int yOffset;
    private static int xOffset;
    private static byte[] plte;
    private static byte[] tnrs;
    private static int maxWidth;
    private static int maxHeight;
    private static Utils.Companion.BlendOp blendOp;
    private static Utils.Companion.DisposeOp disposeOp;
    private static IHDR ihdr;
    @NotNull
    private static Apng apng;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        delay = -1.0f;
        yOffset = -1;
        xOffset = -1;
        blendOp = Utils.Companion.BlendOp.APNG_BLEND_OP_SOURCE;
        disposeOp = Utils.Companion.DisposeOp.APNG_DISPOSE_OP_NONE;
        ihdr = new IHDR();
        apng = new Apng();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0018J \u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\b\u0010%\u001a\u00020$H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Loupson/apng/APNGDisassembler$Companion;", "", "()V", "apng", "Loupson/apng/Apng;", "getApng", "()Loupson/apng/Apng;", "setApng", "(Loupson/apng/Apng;)V", "blendOp", "Loupson/apng/utils/Utils$Companion$BlendOp;", "cover", "Ljava/util/ArrayList;", "", "delay", "", "disposeOp", "Loupson/apng/utils/Utils$Companion$DisposeOp;", "ihdr", "Loupson/apng/chunks/IHDR;", "maxHeight", "", "maxWidth", "plte", "", "png", "tnrs", "xOffset", "yOffset", "disassemble", "byteArray", "generateIhdr", "ihdrOfApng", "width", "height", "parseChunk", "", "reset", "apng_library_release"})
    public static final class Companion {
        @NotNull
        public final Apng getApng() {
            return apng;
        }

        public final void setApng(@NotNull Apng apng) {
            Intrinsics.checkParameterIsNotNull((Object)apng, (String)"<set-?>");
            APNGDisassembler.apng = apng;
        }

        @NotNull
        public final Apng disassemble(@NotNull byte[] byteArray) {
            Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
            this.reset();
            if (Utils.Companion.isApng(byteArray)) {
                int cursor = 8;
                while (cursor < byteArray.length) {
                    byte[] byArray = byteArray;
                    byte[] byArray2 = byteArray;
                    int n = cursor + 4;
                    Utils.Companion companion = Utils.Companion;
                    int n2 = cursor;
                    boolean bl = false;
                    byte[] byArray3 = ArraysKt.copyOfRange((byte[])byArray2, (int)cursor, (int)n);
                    int n3 = n2 + companion.parseLength(byArray3) + 12;
                    n = 0;
                    byte[] chunk = ArraysKt.copyOfRange((byte[])byArray, (int)cursor, (int)n3);
                    this.parseChunk(chunk);
                    byArray = byteArray;
                    n3 = cursor + 4;
                    companion = Utils.Companion;
                    n2 = cursor;
                    n = 0;
                    byArray3 = ArraysKt.copyOfRange((byte[])byArray, (int)cursor, (int)n3);
                    cursor = n2 + (companion.parseLength(byArray3) + 12);
                }
                return this.getApng();
            }
            throw (Throwable)new NotApngException();
        }

        private final byte[] generateIhdr(IHDR ihdrOfApng, int width, int height) {
            ArrayList ihdr = new ArrayList();
            ArrayList ihdrBody = new ArrayList();
            ihdr.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(ihdrOfApng.getBody().length)));
            ihdrBody.addAll(ArraysKt.toList((byte[])new byte[]{(byte)73, (byte)72, (byte)68, (byte)82}));
            ihdrBody.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(width)));
            ihdrBody.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(height)));
            byte[] byArray = ihdrOfApng.getBody();
            int n = 8;
            int n2 = 13;
            ArrayList arrayList = ihdrBody;
            boolean bl = false;
            byte[] byArray2 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            arrayList.addAll(ArraysKt.toList((byte[])byArray2));
            CRC32 crC32 = new CRC32();
            crC32.update(CollectionsKt.toByteArray((Collection)ihdrBody), 0, ihdrBody.size());
            ihdr.addAll(ihdrBody);
            ihdr.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)crC32.getValue())));
            return CollectionsKt.toByteArray((Collection)ihdr);
        }

        private final void parseChunk(byte[] byteArray) {
            int i = 4;
            byte[] byArray = byteArray;
            int n = byteArray.length - 4;
            int n2 = byteArray.length;
            Object object = Utils.Companion;
            int n3 = 0;
            byte[] byArray2 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            int chunkCRC = ((Utils.Companion)object).parseLength(byArray2);
            CRC32 crc = new CRC32();
            Object object2 = byteArray;
            n2 = byteArray.length - 4;
            object = crc;
            n3 = 0;
            byArray2 = ArraysKt.copyOfRange((byte[])object2, (int)i, (int)n2);
            object.update(byArray2);
            if (chunkCRC == (int)crc.getValue()) {
                int crC332;
                byte[] iend;
                Object object3 = byteArray;
                n3 = i + 4;
                boolean bl = false;
                object2 = Arrays.toString(ArraysKt.copyOfRange((byte[])object3, (int)i, (int)n3));
                if (Intrinsics.areEqual((Object)object2, (Object)Utils.Companion.getFcTL())) {
                    if (png == null) {
                        Boolean bl2;
                        Boolean bl3;
                        Object it;
                        Unit unit;
                        boolean bl4;
                        Object it2;
                        ArrayList arrayList = cover;
                        if (arrayList != null) {
                            object3 = arrayList;
                            n3 = 0;
                            bl = false;
                            it2 = object3;
                            bl4 = false;
                            ((ArrayList)it2).addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(0)));
                            byte[] iend2 = new byte[]{73, 69, 78, 68};
                            CRC32 crC32 = new CRC32();
                            crC32.update(iend2, 0, iend2.length);
                            ((ArrayList)it2).addAll(ArraysKt.toList((byte[])iend2));
                            ((ArrayList)it2).addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)crC32.getValue())));
                            Companion.getApng().setCover(BitmapFactory.decodeByteArray((byte[])CollectionsKt.toByteArray((Collection)((Collection)it2)), (int)0, (int)((ArrayList)it2).size()));
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        png = new ArrayList();
                        fcTL fcTL2 = new fcTL();
                        fcTL2.parse(byteArray);
                        delay = fcTL2.getDelay();
                        yOffset = fcTL2.getYOffset();
                        xOffset = fcTL2.getXOffset();
                        APNGDisassembler.blendOp = fcTL2.getBlendOp();
                        APNGDisassembler.disposeOp = fcTL2.getDisposeOp();
                        int width = fcTL2.getPngWidth();
                        int height = fcTL2.getPngHeight();
                        if (xOffset + width > maxWidth) {
                            throw (Throwable)new BadApng("`yOffset` + `height` must be <= `IHDR` height");
                        }
                        if (yOffset + height > maxHeight) {
                            throw (Throwable)new BadApng("`yOffset` + `height` must be <= `IHDR` height");
                        }
                        ArrayList arrayList2 = png;
                        Boolean bl5 = arrayList2 != null ? Boolean.valueOf(arrayList2.addAll(ArraysKt.toList((byte[])Utils.Companion.getPngSignature()))) : null;
                        ArrayList arrayList3 = png;
                        Boolean bl6 = arrayList3 != null ? Boolean.valueOf(arrayList3.addAll(ArraysKt.toList((byte[])this.generateIhdr(ihdr, width, height)))) : null;
                        byte[] byArray3 = plte;
                        if (byArray3 != null) {
                            it2 = byArray3;
                            bl4 = false;
                            boolean bl7 = false;
                            it = it2;
                            boolean bl8 = false;
                            ArrayList arrayList4 = png;
                            bl3 = arrayList4 != null ? Boolean.valueOf(arrayList4.addAll(ArraysKt.toList((byte[])it))) : null;
                        } else {
                            bl3 = null;
                        }
                        byte[] byArray4 = tnrs;
                        if (byArray4 != null) {
                            it2 = byArray4;
                            bl4 = false;
                            boolean bl9 = false;
                            it = it2;
                            boolean bl10 = false;
                            ArrayList arrayList5 = png;
                            bl2 = arrayList5 != null ? Boolean.valueOf(arrayList5.addAll(ArraysKt.toList((byte[])it))) : null;
                        } else {
                            bl2 = null;
                        }
                    } else {
                        Boolean bl11;
                        Boolean bl12;
                        byte[] it;
                        boolean bl13;
                        boolean bl14;
                        byte[] byArray5;
                        ArrayList arrayList = png;
                        Boolean bl15 = arrayList != null ? Boolean.valueOf(arrayList.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(0)))) : null;
                        iend = new byte[]{73, 69, 78, 68};
                        CRC32 crC32 = new CRC32();
                        crC32.update(iend, 0, iend.length);
                        ArrayList arrayList6 = png;
                        Boolean bl16 = arrayList6 != null ? Boolean.valueOf(arrayList6.addAll(ArraysKt.toList((byte[])iend))) : null;
                        ArrayList arrayList7 = png;
                        Boolean bl17 = arrayList7 != null ? Boolean.valueOf(arrayList7.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)crC32.getValue())))) : null;
                        ArrayList<Frame> arrayList8 = this.getApng().getFrames();
                        ArrayList arrayList9 = png;
                        if (arrayList9 == null) {
                            Intrinsics.throwNpe();
                        }
                        arrayList8.add(new Frame(CollectionsKt.toByteArray((Collection)arrayList9), delay, xOffset, yOffset, blendOp, disposeOp, maxWidth, maxHeight));
                        png = new ArrayList();
                        fcTL fcTL22 = new fcTL();
                        fcTL22.parse(byteArray);
                        delay = fcTL22.getDelay();
                        yOffset = fcTL22.getYOffset();
                        xOffset = fcTL22.getXOffset();
                        APNGDisassembler.blendOp = fcTL22.getBlendOp();
                        APNGDisassembler.disposeOp = fcTL22.getDisposeOp();
                        int width = fcTL22.getPngWidth();
                        int height = fcTL22.getPngHeight();
                        ArrayList arrayList10 = png;
                        Boolean bl18 = arrayList10 != null ? Boolean.valueOf(arrayList10.addAll(ArraysKt.toList((byte[])Utils.Companion.getPngSignature()))) : null;
                        ArrayList arrayList11 = png;
                        Boolean bl19 = arrayList11 != null ? Boolean.valueOf(arrayList11.addAll(ArraysKt.toList((byte[])this.generateIhdr(ihdr, width, height)))) : null;
                        byte[] byArray6 = plte;
                        if (byArray6 != null) {
                            byArray5 = byArray6;
                            bl14 = false;
                            bl13 = false;
                            it = byArray5;
                            boolean bl20 = false;
                            ArrayList arrayList12 = png;
                            bl12 = arrayList12 != null ? Boolean.valueOf(arrayList12.addAll(ArraysKt.toList((byte[])it))) : null;
                        } else {
                            bl12 = null;
                        }
                        byte[] byArray7 = tnrs;
                        if (byArray7 != null) {
                            byArray5 = byArray7;
                            bl14 = false;
                            bl13 = false;
                            it = byArray5;
                            boolean bl21 = false;
                            ArrayList arrayList13 = png;
                            bl11 = arrayList13 != null ? Boolean.valueOf(arrayList13.addAll(ArraysKt.toList((byte[])it))) : null;
                        } else {
                            bl11 = null;
                        }
                    }
                } else if (Intrinsics.areEqual((Object)object2, (Object)Utils.Companion.getIEND())) {
                    ArrayList arrayList = png;
                    Boolean bl22 = arrayList != null ? Boolean.valueOf(arrayList.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(0)))) : null;
                    iend = new byte[]{73, 69, 78, 68};
                    CRC32 crC32 = new CRC32();
                    crC32.update(iend, 0, iend.length);
                    ArrayList arrayList14 = png;
                    Boolean bl23 = arrayList14 != null ? Boolean.valueOf(arrayList14.addAll(ArraysKt.toList((byte[])iend))) : null;
                    ArrayList arrayList15 = png;
                    Boolean bl24 = arrayList15 != null ? Boolean.valueOf(arrayList15.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)crC32.getValue())))) : null;
                    ArrayList<Frame> arrayList16 = this.getApng().getFrames();
                    ArrayList arrayList17 = png;
                    if (arrayList17 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList16.add(new Frame(CollectionsKt.toByteArray((Collection)arrayList17), delay, xOffset, yOffset, blendOp, disposeOp, maxWidth, maxHeight));
                } else if (Intrinsics.areEqual((Object)object2, (Object)Utils.Companion.getIDAT())) {
                    if (png == null) {
                        Boolean bl25;
                        if (cover == null) {
                            cover = new ArrayList();
                            ArrayList arrayList = cover;
                            Boolean bl26 = arrayList != null ? Boolean.valueOf(arrayList.addAll(ArraysKt.toList((byte[])Utils.Companion.getPngSignature()))) : null;
                            ArrayList arrayList18 = cover;
                            Boolean bl27 = arrayList18 != null ? Boolean.valueOf(arrayList18.addAll(ArraysKt.toList((byte[])this.generateIhdr(ihdr, maxWidth, maxHeight)))) : null;
                        }
                        byte[] crC32 = byteArray;
                        int fcTL22 = i - 4;
                        object = Utils.Companion;
                        int n4 = 0;
                        byArray2 = ArraysKt.copyOfRange((byte[])crC32, (int)fcTL22, (int)i);
                        int bodySize = ((Utils.Companion)object).parseLength(byArray2);
                        ArrayList arrayList = cover;
                        if (arrayList != null) {
                            crC32 = byteArray;
                            fcTL22 = i - 4;
                            object = arrayList;
                            n4 = 0;
                            byArray2 = ArraysKt.copyOfRange((byte[])crC32, (int)fcTL22, (int)i);
                            bl25 = ((ArrayList)object).addAll(ArraysKt.toList((byte[])byArray2));
                        } else {
                            bl25 = null;
                        }
                        ArrayList body = new ArrayList();
                        body.addAll(ArraysKt.toList((byte[])new byte[]{73, 68, 65, 84}));
                        byte[] fcTL22 = byteArray;
                        n4 = i + 4;
                        int n5 = i + 4 + bodySize;
                        object = body;
                        boolean bl28 = false;
                        byArray2 = ArraysKt.copyOfRange((byte[])fcTL22, (int)n4, (int)n5);
                        ((ArrayList)object).addAll(ArraysKt.toList((byte[])byArray2));
                        CRC32 crC332 = new CRC32();
                        crC332.update(CollectionsKt.toByteArray((Collection)body), 0, body.size());
                        ArrayList arrayList19 = cover;
                        Boolean bl29 = arrayList19 != null ? Boolean.valueOf(arrayList19.addAll(body)) : null;
                        ArrayList arrayList20 = cover;
                        Boolean bl30 = arrayList20 != null ? Boolean.valueOf(arrayList20.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)crC332.getValue())))) : null;
                    } else {
                        Boolean bl31;
                        Object body = byteArray;
                        crC332 = i - 4;
                        object = Utils.Companion;
                        int n6 = 0;
                        byArray2 = ArraysKt.copyOfRange((byte[])body, (int)crC332, (int)i);
                        int bodySize = ((Utils.Companion)object).parseLength(byArray2);
                        ArrayList arrayList = png;
                        if (arrayList != null) {
                            body = byteArray;
                            crC332 = i - 4;
                            object = arrayList;
                            n6 = 0;
                            byArray2 = ArraysKt.copyOfRange((byte[])body, (int)crC332, (int)i);
                            bl31 = ((ArrayList)object).addAll(ArraysKt.toList((byte[])byArray2));
                        } else {
                            bl31 = null;
                        }
                        body = new ArrayList();
                        ((ArrayList)body).addAll(ArraysKt.toList((byte[])new byte[]{73, 68, 65, 84}));
                        Object crC332 = byteArray;
                        n6 = i + 4;
                        int n7 = i + 4 + bodySize;
                        object = body;
                        boolean bl32 = false;
                        byArray2 = ArraysKt.copyOfRange((byte[])crC332, (int)n6, (int)n7);
                        ((ArrayList)object).addAll(ArraysKt.toList((byte[])byArray2));
                        crC332 = new CRC32();
                        ((CRC32)crC332).update(CollectionsKt.toByteArray((Collection)((Collection)body)), 0, ((ArrayList)body).size());
                        ArrayList arrayList21 = png;
                        Boolean bl33 = arrayList21 != null ? Boolean.valueOf(arrayList21.addAll((Collection)body)) : null;
                        ArrayList arrayList22 = png;
                        Boolean bl34 = arrayList22 != null ? Boolean.valueOf(arrayList22.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)((CRC32)crC332).getValue())))) : null;
                    }
                } else if (Intrinsics.areEqual((Object)object2, (Object)Utils.Companion.getFdAT())) {
                    Object body = byteArray;
                    crC332 = i - 4;
                    object = Utils.Companion;
                    int n8 = 0;
                    byArray2 = ArraysKt.copyOfRange((byte[])body, (int)crC332, (int)i);
                    int bodySize = ((Utils.Companion)object).parseLength(byArray2);
                    ArrayList arrayList = png;
                    Boolean bl35 = arrayList != null ? Boolean.valueOf(arrayList.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(bodySize - 4)))) : null;
                    body = new ArrayList();
                    ((ArrayList)body).addAll(ArraysKt.toList((byte[])new byte[]{73, 68, 65, 84}));
                    Object crC32 = byteArray;
                    n8 = i + 8;
                    int n9 = i + 4 + bodySize;
                    object = body;
                    boolean bl36 = false;
                    byArray2 = ArraysKt.copyOfRange((byte[])crC32, (int)n8, (int)n9);
                    ((ArrayList)object).addAll(ArraysKt.toList((byte[])byArray2));
                    crC32 = new CRC32();
                    ((CRC32)crC32).update(CollectionsKt.toByteArray((Collection)((Collection)body)), 0, ((ArrayList)body).size());
                    ArrayList arrayList23 = png;
                    Boolean bl37 = arrayList23 != null ? Boolean.valueOf(arrayList23.addAll((Collection)body)) : null;
                    ArrayList arrayList24 = png;
                    Boolean bl38 = arrayList24 != null ? Boolean.valueOf(arrayList24.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)((CRC32)crC32).getValue())))) : null;
                } else if (Intrinsics.areEqual((Object)object2, (Object)Utils.Companion.getPlte())) {
                    plte = byteArray;
                } else if (Intrinsics.areEqual((Object)object2, (Object)Utils.Companion.getTnrs())) {
                    tnrs = byteArray;
                } else if (Intrinsics.areEqual((Object)object2, (Object)Utils.Companion.getIHDR())) {
                    ihdr.parse(byteArray);
                    maxWidth = ihdr.getPngWidth();
                    maxHeight = ihdr.getPngHeight();
                }
            } else {
                throw (Throwable)new BadCRC();
            }
        }

        private final void reset() {
            png = null;
            cover = null;
            delay = -1.0f;
            yOffset = -1;
            xOffset = -1;
            plte = null;
            tnrs = null;
            maxWidth = 0;
            maxHeight = 0;
            ihdr = new IHDR();
            this.setApng(new Apng());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

