/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import oupson.apng.utils.Utils$Companion$WhenMappings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Loupson/apng/utils/Utils;", "", "()V", "Companion", "apng_library_release"})
public final class Utils {
    @NotNull
    private static final byte[] pngSignature;
    private static final String fcTL;
    private static final String IEND;
    private static final String IDAT;
    private static final String fdAT;
    private static final String plte;
    private static final String tnrs;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        pngSignature = new byte[]{(byte)137, (byte)80, (byte)78, (byte)71, (byte)13, (byte)10, (byte)26, (byte)10};
        fcTL = Arrays.toString(new byte[]{102, 99, 84, 76});
        IEND = Arrays.toString(new byte[]{73, 69, 78, 68});
        IDAT = Arrays.toString(new byte[]{73, 68, 65, 84});
        fdAT = Arrays.toString(new byte[]{102, 100, 65, 84});
        plte = Arrays.toString(new byte[]{80, 76, 84, 69});
        tnrs = Arrays.toString(new byte[]{116, 82, 78, 83});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u001d B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0011J\u000e\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0011J\u000e\u0010%\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0011J\u000e\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u001cJ\u000e\u0010(\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u001cJ\u000e\u0010)\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0017R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0019\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0019\u0010\u000e\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0014\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006*"}, d2={"Loupson/apng/utils/Utils$Companion;", "", "()V", "IDAT", "", "kotlin.jvm.PlatformType", "getIDAT", "()Ljava/lang/String;", "IEND", "getIEND", "fcTL", "getFcTL", "fdAT", "getFdAT", "plte", "getPlte", "pngSignature", "", "getPngSignature", "()[B", "tnrs", "getTnrs", "convertImage", "Landroid/graphics/Bitmap;", "bitmap", "getBlend_op", "Loupson/apng/utils/Utils$Companion$blend_op;", "int", "", "blend_op", "getDispose_op", "Loupson/apng/utils/Utils$Companion$dispose_op;", "dispose_op", "isApng", "", "byteArray", "isPng", "parseLength", "to2Bytes", "i", "to4Bytes", "toByteArray", "apng_library_release"})
    public static final class Companion {
        public final boolean isPng(@NotNull byte[] byteArray) {
            Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
            byte[] byArray = byteArray;
            int n = 0;
            int n2 = 8;
            byArray = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            String string = Arrays.toString(byArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.util.Arrays.toString(this)");
            byArray = this.getPngSignature();
            String string2 = string;
            String string3 = Arrays.toString(byArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.util.Arrays.toString(this)");
            String string4 = string3;
            return Intrinsics.areEqual((Object)string2, (Object)string4);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isApng(@NotNull byte[] byteArray) {
            Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
            if (!this.isPng(byteArray)) {
                return false;
            }
            try {
                byte[] acTL = new byte[]{97, 99, 84, 76};
                byte[] IDAT2 = new byte[]{73, 68, 65, 84};
                int n = 0;
                int n2 = byteArray.length;
                while (n < n2) {
                    void i;
                    byte[] byArray = byteArray;
                    void var8_9 = i + 4;
                    byte[] it = ArraysKt.copyOfRange((byte[])byArray, (int)i, (int)var8_9);
                    if (Arrays.equals(byArray = it, acTL)) {
                        return true;
                    }
                    byArray = it;
                    if (Arrays.equals(byArray, IDAT2)) {
                        return false;
                    }
                    ++i;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }

        @NotNull
        public final byte[] getPngSignature() {
            return pngSignature;
        }

        public final int getDispose_op(@NotNull dispose_op dispose_op2) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)((Object)dispose_op2), (String)"dispose_op");
            switch (Utils$Companion$WhenMappings.$EnumSwitchMapping$0[dispose_op2.ordinal()]) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        @NotNull
        public final dispose_op getDispose_op(int n) {
            dispose_op dispose_op2;
            switch (n) {
                case 0: {
                    dispose_op2 = dispose_op.APNG_DISPOSE_OP_NONE;
                    break;
                }
                case 1: {
                    dispose_op2 = dispose_op.APNG_DISPOSE_OP_BACKGROUND;
                    break;
                }
                case 2: {
                    dispose_op2 = dispose_op.APNG_DISPOSE_OP_PREVIOUS;
                    break;
                }
                default: {
                    dispose_op2 = dispose_op.APNG_DISPOSE_OP_NONE;
                }
            }
            return dispose_op2;
        }

        public final int getBlend_op(@NotNull blend_op blend_op2) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)((Object)blend_op2), (String)"blend_op");
            switch (Utils$Companion$WhenMappings.$EnumSwitchMapping$1[blend_op2.ordinal()]) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        @NotNull
        public final blend_op getBlend_op(int n) {
            blend_op blend_op2;
            switch (n) {
                case 0: {
                    blend_op2 = blend_op.APNG_BLEND_OP_SOURCE;
                    break;
                }
                case 1: {
                    blend_op2 = blend_op.APNG_BLEND_OP_OVER;
                    break;
                }
                default: {
                    blend_op2 = blend_op.APNG_BLEND_OP_SOURCE;
                }
            }
            return blend_op2;
        }

        @NotNull
        public final byte[] toByteArray(@NotNull Bitmap bitmap) {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.convertImage(bitmap).compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos);
            byte[] byArray = bos.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"bos.toByteArray()");
            return byArray;
        }

        @NotNull
        public final Bitmap convertImage(@NotNull Bitmap bitmap) {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            Bitmap btm = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            btm.setHasAlpha(true);
            Canvas canvas = new Canvas(btm);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
            Bitmap bitmap2 = btm;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"btm");
            return bitmap2;
        }

        @NotNull
        public final byte[] to4Bytes(int i) {
            byte[] result = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
            return result;
        }

        @NotNull
        public final byte[] to2Bytes(int i) {
            byte[] result = new byte[]{(byte)(i >> 8), (byte)i};
            return result;
        }

        public final int parseLength(@NotNull byte[] byteArray) {
            byte[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
            String lengthString = "";
            byte[] byArray = $receiver$iv = byteArray;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                String string;
                byte element$iv;
                byte it = element$iv = byArray[i];
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "%02x";
                Object[] objectArray = new Object[]{it};
                StringBuilder stringBuilder = new StringBuilder().append(lengthString);
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                lengthString = stringBuilder.append(string).toString();
            }
            String string = lengthString;
            int n2 = 16;
            return (int)Long.parseLong(string, CharsKt.checkRadix((int)n2));
        }

        public final String getFcTL() {
            return fcTL;
        }

        public final String getIEND() {
            return IEND;
        }

        public final String getIDAT() {
            return IDAT;
        }

        public final String getFdAT() {
            return fdAT;
        }

        public final String getPlte() {
            return plte;
        }

        public final String getTnrs() {
            return tnrs;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Loupson/apng/utils/Utils$Companion$dispose_op;", "", "(Ljava/lang/String;I)V", "APNG_DISPOSE_OP_NONE", "APNG_DISPOSE_OP_BACKGROUND", "APNG_DISPOSE_OP_PREVIOUS", "apng_library_release"})
        public static final class dispose_op
        extends Enum<dispose_op> {
            public static final /* enum */ dispose_op APNG_DISPOSE_OP_NONE;
            public static final /* enum */ dispose_op APNG_DISPOSE_OP_BACKGROUND;
            public static final /* enum */ dispose_op APNG_DISPOSE_OP_PREVIOUS;
            private static final /* synthetic */ dispose_op[] $VALUES;

            static {
                dispose_op[] dispose_opArray = new dispose_op[3];
                dispose_op[] dispose_opArray2 = dispose_opArray;
                dispose_opArray[0] = APNG_DISPOSE_OP_NONE = new dispose_op();
                dispose_opArray[1] = APNG_DISPOSE_OP_BACKGROUND = new dispose_op();
                dispose_opArray[2] = APNG_DISPOSE_OP_PREVIOUS = new dispose_op();
                $VALUES = dispose_opArray;
            }

            public static dispose_op[] values() {
                return (dispose_op[])$VALUES.clone();
            }

            public static dispose_op valueOf(String string) {
                return Enum.valueOf(dispose_op.class, string);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Loupson/apng/utils/Utils$Companion$blend_op;", "", "(Ljava/lang/String;I)V", "APNG_BLEND_OP_SOURCE", "APNG_BLEND_OP_OVER", "apng_library_release"})
        public static final class blend_op
        extends Enum<blend_op> {
            public static final /* enum */ blend_op APNG_BLEND_OP_SOURCE;
            public static final /* enum */ blend_op APNG_BLEND_OP_OVER;
            private static final /* synthetic */ blend_op[] $VALUES;

            static {
                blend_op[] blend_opArray = new blend_op[2];
                blend_op[] blend_opArray2 = blend_opArray;
                blend_opArray[0] = APNG_BLEND_OP_SOURCE = new blend_op();
                blend_opArray[1] = APNG_BLEND_OP_OVER = new blend_op();
                $VALUES = blend_opArray;
            }

            public static blend_op[] values() {
                return (blend_op[])$VALUES.clone();
            }

            public static blend_op valueOf(String string) {
                return Enum.valueOf(blend_op.class, string);
            }
        }
    }
}

