/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oupson.apng.chunks.IDAT;
import oupson.apng.chunks.IHDR;
import oupson.apng.exceptions.NotPngException;
import oupson.apng.utils.Utils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010BG\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u0012\u0006\u0010\u0012\u001a\u00020\u000e\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00106\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00106\u001a\u0004\b7\u00103\"\u0004\b8\u00105R\u001a\u00109\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010#\"\u0004\b;\u0010%R\u001e\u0010<\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00106\u001a\u0004\b=\u00103\"\u0004\b>\u00105R\u001e\u0010?\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00106\u001a\u0004\b@\u00103\"\u0004\bA\u00105\u00a8\u0006B"}, d2={"Loupson/apng/Frame;", "", "byteArray", "", "([B)V", "delay", "", "([BF)V", "blend_op", "Loupson/apng/utils/Utils$Companion$blend_op;", "dispose_op", "Loupson/apng/utils/Utils$Companion$dispose_op;", "([BFLoupson/apng/utils/Utils$Companion$blend_op;Loupson/apng/utils/Utils$Companion$dispose_op;)V", "xOffsets", "", "yOffsets", "([BFIILoupson/apng/utils/Utils$Companion$blend_op;Loupson/apng/utils/Utils$Companion$dispose_op;)V", "maxWidth", "maxHeight", "([BFIIIILoupson/apng/utils/Utils$Companion$blend_op;Loupson/apng/utils/Utils$Companion$dispose_op;)V", "getBlend_op", "()Loupson/apng/utils/Utils$Companion$blend_op;", "setBlend_op", "(Loupson/apng/utils/Utils$Companion$blend_op;)V", "getByteArray", "()[B", "setByteArray", "getDelay", "()F", "getDispose_op", "()Loupson/apng/utils/Utils$Companion$dispose_op;", "setDispose_op", "(Loupson/apng/utils/Utils$Companion$dispose_op;)V", "height", "getHeight", "()I", "setHeight", "(I)V", "idat", "Loupson/apng/chunks/IDAT;", "getIdat", "()Loupson/apng/chunks/IDAT;", "setIdat", "(Loupson/apng/chunks/IDAT;)V", "ihdr", "Loupson/apng/chunks/IHDR;", "getIhdr", "()Loupson/apng/chunks/IHDR;", "setIhdr", "(Loupson/apng/chunks/IHDR;)V", "getMaxHeight", "()Ljava/lang/Integer;", "setMaxHeight", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getMaxWidth", "setMaxWidth", "width", "getWidth", "setWidth", "x_offsets", "getX_offsets", "setX_offsets", "y_offsets", "getY_offsets", "setY_offsets", "apng_library_release"})
public final class Frame {
    @NotNull
    private byte[] byteArray;
    private int width;
    private int height;
    @NotNull
    private IHDR ihdr;
    @NotNull
    private IDAT idat;
    private final float delay;
    @Nullable
    private Integer x_offsets;
    @Nullable
    private Integer y_offsets;
    @Nullable
    private Integer maxWidth;
    @Nullable
    private Integer maxHeight;
    @NotNull
    private Utils.Companion.blend_op blend_op;
    @NotNull
    private Utils.Companion.dispose_op dispose_op;

    @NotNull
    public final byte[] getByteArray() {
        return this.byteArray;
    }

    public final void setByteArray(@NotNull byte[] byArray) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"<set-?>");
        this.byteArray = byArray;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    @NotNull
    public final IHDR getIhdr() {
        return this.ihdr;
    }

    public final void setIhdr(@NotNull IHDR iHDR) {
        Intrinsics.checkParameterIsNotNull((Object)iHDR, (String)"<set-?>");
        this.ihdr = iHDR;
    }

    @NotNull
    public final IDAT getIdat() {
        return this.idat;
    }

    public final void setIdat(@NotNull IDAT iDAT) {
        Intrinsics.checkParameterIsNotNull((Object)iDAT, (String)"<set-?>");
        this.idat = iDAT;
    }

    public final float getDelay() {
        return this.delay;
    }

    @Nullable
    public final Integer getX_offsets() {
        return this.x_offsets;
    }

    public final void setX_offsets(@Nullable Integer n) {
        this.x_offsets = n;
    }

    @Nullable
    public final Integer getY_offsets() {
        return this.y_offsets;
    }

    public final void setY_offsets(@Nullable Integer n) {
        this.y_offsets = n;
    }

    @Nullable
    public final Integer getMaxWidth() {
        return this.maxWidth;
    }

    public final void setMaxWidth(@Nullable Integer n) {
        this.maxWidth = n;
    }

    @Nullable
    public final Integer getMaxHeight() {
        return this.maxHeight;
    }

    public final void setMaxHeight(@Nullable Integer n) {
        this.maxHeight = n;
    }

    @NotNull
    public final Utils.Companion.blend_op getBlend_op() {
        return this.blend_op;
    }

    public final void setBlend_op(@NotNull Utils.Companion.blend_op blend_op2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)blend_op2), (String)"<set-?>");
        this.blend_op = blend_op2;
    }

    @NotNull
    public final Utils.Companion.dispose_op getDispose_op() {
        return this.dispose_op;
    }

    public final void setDispose_op(@NotNull Utils.Companion.dispose_op dispose_op2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dispose_op2), (String)"<set-?>");
        this.dispose_op = dispose_op2;
    }

    public Frame(@NotNull byte[] byteArray) {
        Bitmap btm;
        Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
        if (!Utils.Companion.isPng(byteArray)) {
            throw (Throwable)new NotPngException();
        }
        Bitmap bitmap = btm = BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"btm");
        byte[] bytes = Utils.Companion.toByteArray(bitmap);
        this.byteArray = bytes;
        this.ihdr = new IHDR();
        this.ihdr.parse(bytes);
        this.width = this.ihdr.getPngWidth();
        this.height = this.ihdr.getPngHeight();
        this.idat = new IDAT();
        this.idat.parse(bytes);
        this.delay = 1000.0f;
        this.blend_op = Utils.Companion.blend_op.APNG_BLEND_OP_SOURCE;
        this.dispose_op = Utils.Companion.dispose_op.APNG_DISPOSE_OP_NONE;
    }

    public Frame(@NotNull byte[] byteArray, float delay) {
        Bitmap btm;
        Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
        if (!Utils.Companion.isPng(byteArray)) {
            throw (Throwable)new NotPngException();
        }
        Bitmap bitmap = btm = BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"btm");
        byte[] bytes = Utils.Companion.toByteArray(bitmap);
        this.byteArray = bytes;
        this.ihdr = new IHDR();
        this.ihdr.parse(bytes);
        this.width = this.ihdr.getPngWidth();
        this.height = this.ihdr.getPngHeight();
        this.idat = new IDAT();
        this.idat.parse(bytes);
        this.delay = delay;
        this.blend_op = Utils.Companion.blend_op.APNG_BLEND_OP_SOURCE;
        this.dispose_op = Utils.Companion.dispose_op.APNG_DISPOSE_OP_NONE;
    }

    public Frame(@NotNull byte[] byteArray, float delay, @NotNull Utils.Companion.blend_op blend_op2, @NotNull Utils.Companion.dispose_op dispose_op2) {
        Bitmap btm;
        Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
        Intrinsics.checkParameterIsNotNull((Object)((Object)blend_op2), (String)"blend_op");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dispose_op2), (String)"dispose_op");
        if (!Utils.Companion.isPng(byteArray)) {
            throw (Throwable)new NotPngException();
        }
        Bitmap bitmap = btm = BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"btm");
        byte[] bytes = Utils.Companion.toByteArray(bitmap);
        this.byteArray = bytes;
        this.ihdr = new IHDR();
        this.ihdr.parse(bytes);
        this.width = this.ihdr.getPngWidth();
        this.height = this.ihdr.getPngHeight();
        this.idat = new IDAT();
        this.idat.parse(bytes);
        this.delay = delay;
        this.maxWidth = -1;
        this.maxHeight = -1;
        this.blend_op = blend_op2;
        this.dispose_op = dispose_op2;
    }

    public Frame(@NotNull byte[] byteArray, float delay, int xOffsets, int yOffsets, @NotNull Utils.Companion.blend_op blend_op2, @NotNull Utils.Companion.dispose_op dispose_op2) {
        Bitmap btm;
        Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
        Intrinsics.checkParameterIsNotNull((Object)((Object)blend_op2), (String)"blend_op");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dispose_op2), (String)"dispose_op");
        if (!Utils.Companion.isPng(byteArray)) {
            throw (Throwable)new NotPngException();
        }
        Bitmap bitmap = btm = BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"btm");
        byte[] bytes = Utils.Companion.toByteArray(bitmap);
        this.byteArray = bytes;
        this.ihdr = new IHDR();
        this.ihdr.parse(bytes);
        this.width = this.ihdr.getPngWidth();
        this.height = this.ihdr.getPngHeight();
        this.idat = new IDAT();
        this.idat.parse(bytes);
        this.delay = delay;
        this.x_offsets = xOffsets;
        this.y_offsets = yOffsets;
        this.maxWidth = -1;
        this.maxHeight = -1;
        this.blend_op = blend_op2;
        this.dispose_op = dispose_op2;
    }

    public Frame(@NotNull byte[] byteArray, float delay, int xOffsets, int yOffsets, int maxWidth, int maxHeight, @NotNull Utils.Companion.blend_op blend_op2, @NotNull Utils.Companion.dispose_op dispose_op2) {
        Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
        Intrinsics.checkParameterIsNotNull((Object)((Object)blend_op2), (String)"blend_op");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dispose_op2), (String)"dispose_op");
        if (!Utils.Companion.isPng(byteArray)) {
            throw (Throwable)new NotPngException();
        }
        this.byteArray = byteArray;
        this.ihdr = new IHDR();
        this.ihdr.parse(byteArray);
        this.width = this.ihdr.getPngWidth();
        this.height = this.ihdr.getPngHeight();
        this.idat = new IDAT();
        this.idat.parse(byteArray);
        this.delay = delay;
        this.x_offsets = xOffsets;
        this.y_offsets = yOffsets;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.blend_op = blend_op2;
        this.dispose_op = dispose_op2;
    }
}

