/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng;

import android.graphics.BitmapFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import oupson.apng.Apng;
import oupson.apng.Frame;
import oupson.apng.chunks.IHDR;
import oupson.apng.chunks.fcTL;
import oupson.apng.exceptions.NotApngException;
import oupson.apng.utils.Utils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Loupson/apng/APNGDisassembler;", "", "()V", "Companion", "apng_library_release"})
public final class APNGDisassembler {
    private static ArrayList<Byte> png;
    private static ArrayList<Byte> cover;
    private static float delay;
    private static int yOffset;
    private static int xOffset;
    private static byte[] plte;
    private static byte[] tnrs;
    private static int maxWidth;
    private static int maxHeight;
    private static Utils.Companion.blend_op blend_op;
    private static Utils.Companion.dispose_op dispose_op;
    private static final IHDR ihdr;
    @NotNull
    private static Apng apng;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        delay = -1.0f;
        yOffset = -1;
        xOffset = -1;
        blend_op = Utils.Companion.blend_op.APNG_BLEND_OP_SOURCE;
        dispose_op = Utils.Companion.dispose_op.APNG_DISPOSE_OP_NONE;
        ihdr = new IHDR();
        apng = new Apng();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0018J \u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Loupson/apng/APNGDisassembler$Companion;", "", "()V", "apng", "Loupson/apng/Apng;", "getApng", "()Loupson/apng/Apng;", "setApng", "(Loupson/apng/Apng;)V", "blend_op", "Loupson/apng/utils/Utils$Companion$blend_op;", "cover", "Ljava/util/ArrayList;", "", "delay", "", "dispose_op", "Loupson/apng/utils/Utils$Companion$dispose_op;", "ihdr", "Loupson/apng/chunks/IHDR;", "maxHeight", "", "maxWidth", "plte", "", "png", "tnrs", "xOffset", "yOffset", "disassemble", "byteArray", "generateIhdr", "ihdrOfApng", "width", "height", "parseChunk", "", "apng_library_release"})
    public static final class Companion {
        @NotNull
        public final Apng getApng() {
            return apng;
        }

        public final void setApng(@NotNull Apng apng) {
            Intrinsics.checkParameterIsNotNull((Object)apng, (String)"<set-?>");
            APNGDisassembler.apng = apng;
        }

        @NotNull
        public final Apng disassemble(@NotNull byte[] byteArray) {
            Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
            if (Utils.Companion.isApng(byteArray)) {
                ihdr.parse(byteArray);
                maxWidth = ihdr.getPngWidth();
                maxHeight = ihdr.getPngHeight();
                int cursor = 8;
                while (cursor < byteArray.length) {
                    byte[] byArray = byteArray;
                    byte[] byArray2 = byteArray;
                    int n = cursor + 4;
                    Utils.Companion companion = Utils.Companion;
                    int n2 = cursor;
                    byte[] byArray3 = ArraysKt.copyOfRange((byte[])byArray2, (int)cursor, (int)n);
                    int n3 = n2 + companion.parseLength(byArray3) + 12;
                    byte[] chunk = ArraysKt.copyOfRange((byte[])byArray, (int)cursor, (int)n3);
                    this.parseChunk(chunk);
                    byArray = byteArray;
                    n3 = cursor + 4;
                    companion = Utils.Companion;
                    n2 = cursor;
                    byArray3 = ArraysKt.copyOfRange((byte[])byArray, (int)cursor, (int)n3);
                    cursor = n2 + (companion.parseLength(byArray3) + 12);
                }
                return this.getApng();
            }
            throw (Throwable)new NotApngException();
        }

        private final byte[] generateIhdr(IHDR ihdrOfApng, int width, int height) {
            ArrayList ihdr = new ArrayList();
            ArrayList ihdrBody = new ArrayList();
            ihdr.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(ihdrOfApng.getBody().length)));
            ihdrBody.addAll(ArraysKt.toList((byte[])new byte[]{(byte)73, (byte)72, (byte)68, (byte)82}));
            ihdrBody.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(width)));
            ihdrBody.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(height)));
            byte[] byArray = ihdrOfApng.getBody();
            int n = 8;
            int n2 = 13;
            ArrayList arrayList = ihdrBody;
            byte[] byArray2 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            arrayList.addAll(ArraysKt.toList((byte[])byArray2));
            CRC32 crC32 = new CRC32();
            crC32.update(CollectionsKt.toByteArray((Collection)ihdrBody), 0, ihdrBody.size());
            ihdr.addAll(ihdrBody);
            ihdr.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)crC32.getValue())));
            return CollectionsKt.toByteArray((Collection)ihdr);
        }

        private final void parseChunk(byte[] byteArray) {
            int bodySize;
            int i = 4;
            Object object = byteArray;
            int n = i + 4;
            String name = Arrays.toString(ArraysKt.copyOfRange((byte[])object, (int)i, (int)n));
            if (Intrinsics.areEqual((Object)(object = (Object)name), (Object)Utils.Companion.getFcTL())) {
                if (png == null) {
                    Boolean bl;
                    Boolean bl2;
                    Object it;
                    Unit unit;
                    Object crC32;
                    ArrayList arrayList = cover;
                    if (arrayList != null) {
                        ArrayList arrayList2;
                        ArrayList it2 = arrayList2 = arrayList;
                        it2.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(0)));
                        byte[] iend = new byte[]{73, 69, 78, 68};
                        crC32 = new CRC32();
                        ((CRC32)crC32).update(iend, 0, iend.length);
                        it2.addAll(ArraysKt.toList((byte[])iend));
                        it2.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)((CRC32)crC32).getValue())));
                        Companion.getApng().setCover(BitmapFactory.decodeByteArray((byte[])CollectionsKt.toByteArray((Collection)it2), (int)0, (int)it2.size()));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    png = new ArrayList();
                    fcTL fcTL2 = new fcTL();
                    fcTL2.parse(byteArray);
                    delay = fcTL2.getDelay();
                    yOffset = fcTL2.getY_offset();
                    xOffset = fcTL2.getX_offset();
                    blend_op = fcTL2.getBlend_op();
                    dispose_op = fcTL2.getDispose_op();
                    int width = fcTL2.getPngWidth();
                    int height = fcTL2.getPngHeight();
                    ArrayList arrayList3 = png;
                    if (arrayList3 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList3.addAll(ArraysKt.toList((byte[])Utils.Companion.getPngSignature()));
                    ArrayList arrayList4 = png;
                    if (arrayList4 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList4.addAll(ArraysKt.toList((byte[])this.generateIhdr(ihdr, width, height)));
                    byte[] byArray = plte;
                    if (byArray != null) {
                        it = crC32 = (Object)byArray;
                        ArrayList arrayList5 = png;
                        if (arrayList5 == null) {
                            Intrinsics.throwNpe();
                        }
                        bl2 = arrayList5.addAll(ArraysKt.toList((byte[])it));
                    } else {
                        bl2 = null;
                    }
                    byte[] byArray2 = tnrs;
                    if (byArray2 != null) {
                        it = crC32 = (Object)byArray2;
                        ArrayList arrayList6 = png;
                        if (arrayList6 == null) {
                            Intrinsics.throwNpe();
                        }
                        bl = arrayList6.addAll(ArraysKt.toList((byte[])it));
                    } else {
                        bl = null;
                    }
                } else {
                    Boolean bl;
                    Boolean bl3;
                    byte[] it;
                    byte[] byArray;
                    ArrayList arrayList = png;
                    if (arrayList == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(0)));
                    byte[] iend = new byte[]{73, 69, 78, 68};
                    CRC32 crC32 = new CRC32();
                    crC32.update(iend, 0, iend.length);
                    ArrayList arrayList7 = png;
                    if (arrayList7 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList7.addAll(ArraysKt.toList((byte[])iend));
                    ArrayList arrayList8 = png;
                    if (arrayList8 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList8.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)crC32.getValue())));
                    ArrayList<Frame> arrayList9 = this.getApng().getFrames();
                    ArrayList arrayList10 = png;
                    if (arrayList10 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList9.add(new Frame(CollectionsKt.toByteArray((Collection)arrayList10), delay, xOffset, yOffset, maxWidth, maxHeight, blend_op, dispose_op));
                    png = new ArrayList();
                    fcTL fcTL22 = new fcTL();
                    fcTL22.parse(byteArray);
                    delay = fcTL22.getDelay();
                    yOffset = fcTL22.getY_offset();
                    xOffset = fcTL22.getX_offset();
                    blend_op = fcTL22.getBlend_op();
                    dispose_op = fcTL22.getDispose_op();
                    int width = fcTL22.getPngWidth();
                    int height = fcTL22.getPngHeight();
                    ArrayList arrayList11 = png;
                    if (arrayList11 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList11.addAll(ArraysKt.toList((byte[])Utils.Companion.getPngSignature()));
                    ArrayList arrayList12 = png;
                    if (arrayList12 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList12.addAll(ArraysKt.toList((byte[])this.generateIhdr(ihdr, width, height)));
                    byte[] byArray3 = plte;
                    if (byArray3 != null) {
                        it = byArray = byArray3;
                        ArrayList arrayList13 = png;
                        if (arrayList13 == null) {
                            Intrinsics.throwNpe();
                        }
                        bl3 = arrayList13.addAll(ArraysKt.toList((byte[])it));
                    } else {
                        bl3 = null;
                    }
                    byte[] byArray4 = tnrs;
                    if (byArray4 != null) {
                        it = byArray = byArray4;
                        ArrayList arrayList14 = png;
                        if (arrayList14 == null) {
                            Intrinsics.throwNpe();
                        }
                        bl = arrayList14.addAll(ArraysKt.toList((byte[])it));
                    } else {
                        bl = null;
                    }
                }
            } else if (Intrinsics.areEqual((Object)object, (Object)Utils.Companion.getIEND())) {
                ArrayList arrayList = png;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                arrayList.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(0)));
                byte[] iend = new byte[]{73, 69, 78, 68};
                CRC32 crC32 = new CRC32();
                crC32.update(iend, 0, iend.length);
                ArrayList arrayList15 = png;
                if (arrayList15 == null) {
                    Intrinsics.throwNpe();
                }
                arrayList15.addAll(ArraysKt.toList((byte[])iend));
                ArrayList arrayList16 = png;
                if (arrayList16 == null) {
                    Intrinsics.throwNpe();
                }
                arrayList16.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)crC32.getValue())));
                ArrayList<Frame> arrayList17 = this.getApng().getFrames();
                ArrayList arrayList18 = png;
                if (arrayList18 == null) {
                    Intrinsics.throwNpe();
                }
                arrayList17.add(new Frame(CollectionsKt.toByteArray((Collection)arrayList18), delay, xOffset, yOffset, maxWidth, maxHeight, blend_op, dispose_op));
            } else if (Intrinsics.areEqual((Object)object, (Object)Utils.Companion.getIDAT())) {
                if (png == null) {
                    if (cover == null) {
                        cover = new ArrayList();
                        ArrayList arrayList = cover;
                        if (arrayList == null) {
                            Intrinsics.throwNpe();
                        }
                        arrayList.addAll(ArraysKt.toList((byte[])Utils.Companion.getPngSignature()));
                        ArrayList arrayList19 = cover;
                        if (arrayList19 == null) {
                            Intrinsics.throwNpe();
                        }
                        arrayList19.addAll(ArraysKt.toList((byte[])this.generateIhdr(ihdr, maxWidth, maxHeight)));
                    }
                    byte[] crC32 = byteArray;
                    int fcTL22 = i - 4;
                    ArrayList arrayList = Utils.Companion;
                    byte[] byArray = ArraysKt.copyOfRange((byte[])crC32, (int)fcTL22, (int)i);
                    bodySize = ((Utils.Companion)((Object)arrayList)).parseLength(byArray);
                    ArrayList arrayList20 = cover;
                    if (arrayList20 == null) {
                        Intrinsics.throwNpe();
                    }
                    crC32 = byteArray;
                    fcTL22 = i - 4;
                    arrayList = arrayList20;
                    byArray = ArraysKt.copyOfRange((byte[])crC32, (int)fcTL22, (int)i);
                    arrayList.addAll(ArraysKt.toList((byte[])byArray));
                    ArrayList body = new ArrayList();
                    body.addAll(ArraysKt.toList((byte[])new byte[]{73, 68, 65, 84}));
                    byte[] fcTL22 = byteArray;
                    int n2 = i + 4;
                    int n3 = i + 4 + bodySize;
                    arrayList = body;
                    byArray = ArraysKt.copyOfRange((byte[])fcTL22, (int)n2, (int)n3);
                    arrayList.addAll(ArraysKt.toList((byte[])byArray));
                    CRC32 crC332 = new CRC32();
                    crC332.update(CollectionsKt.toByteArray((Collection)body), 0, body.size());
                    ArrayList arrayList21 = cover;
                    if (arrayList21 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList21.addAll(body);
                    ArrayList arrayList22 = cover;
                    if (arrayList22 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList22.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)crC332.getValue())));
                } else {
                    Object body = byteArray;
                    int crC332 = i - 4;
                    Object object2 = Utils.Companion;
                    byte[] byArray = ArraysKt.copyOfRange((byte[])body, (int)crC332, (int)i);
                    bodySize = ((Utils.Companion)object2).parseLength(byArray);
                    ArrayList arrayList = png;
                    if (arrayList == null) {
                        Intrinsics.throwNpe();
                    }
                    body = byteArray;
                    crC332 = i - 4;
                    object2 = arrayList;
                    byArray = ArraysKt.copyOfRange((byte[])body, (int)crC332, (int)i);
                    ((ArrayList)object2).addAll(ArraysKt.toList((byte[])byArray));
                    body = new ArrayList();
                    ((ArrayList)body).addAll(ArraysKt.toList((byte[])new byte[]{73, 68, 65, 84}));
                    Object crC332 = byteArray;
                    int n4 = i + 4;
                    int n5 = i + 4 + bodySize;
                    object2 = body;
                    byArray = ArraysKt.copyOfRange((byte[])crC332, (int)n4, (int)n5);
                    ((ArrayList)object2).addAll(ArraysKt.toList((byte[])byArray));
                    crC332 = new CRC32();
                    ((CRC32)crC332).update(CollectionsKt.toByteArray((Collection)((Collection)body)), 0, ((ArrayList)body).size());
                    ArrayList arrayList23 = png;
                    if (arrayList23 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList23.addAll((Collection)body);
                    ArrayList arrayList24 = png;
                    if (arrayList24 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList24.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)((CRC32)crC332).getValue())));
                }
            } else if (Intrinsics.areEqual((Object)object, (Object)Utils.Companion.getFdAT())) {
                Object body = byteArray;
                int crC342 = i - 4;
                Object object3 = Utils.Companion;
                byte[] byArray = ArraysKt.copyOfRange((byte[])body, (int)crC342, (int)i);
                bodySize = ((Utils.Companion)object3).parseLength(byArray);
                ArrayList arrayList = png;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                arrayList.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes(bodySize - 4)));
                body = new ArrayList();
                ((ArrayList)body).addAll(ArraysKt.toList((byte[])new byte[]{73, 68, 65, 84}));
                Object crC342 = byteArray;
                int n6 = i + 8;
                int n7 = i + 4 + bodySize;
                object3 = body;
                byArray = ArraysKt.copyOfRange((byte[])crC342, (int)n6, (int)n7);
                ((ArrayList)object3).addAll(ArraysKt.toList((byte[])byArray));
                crC342 = new CRC32();
                ((CRC32)crC342).update(CollectionsKt.toByteArray((Collection)((Collection)body)), 0, ((ArrayList)body).size());
                ArrayList arrayList25 = png;
                if (arrayList25 == null) {
                    Intrinsics.throwNpe();
                }
                arrayList25.addAll((Collection)body);
                ArrayList arrayList26 = png;
                if (arrayList26 == null) {
                    Intrinsics.throwNpe();
                }
                arrayList26.addAll(ArraysKt.toList((byte[])Utils.Companion.to4Bytes((int)((CRC32)crC342).getValue())));
            } else if (Intrinsics.areEqual((Object)object, (Object)Utils.Companion.getPlte())) {
                plte = byteArray;
            } else if (Intrinsics.areEqual((Object)object, (Object)Utils.Companion.getTnrs())) {
                tnrs = byteArray;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

