/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.widget.ImageView;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.anko.AnkoAsyncContext;
import org.jetbrains.anko.AsyncKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oupson.apng.APNGDisassembler;
import oupson.apng.ApngAnimator;
import oupson.apng.BitmapDrawable;
import oupson.apng.Frame;
import oupson.apng.Loader;
import oupson.apng.Utils;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010F\u001a\u00020G2\u0016\u0010H\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bH\u0002J\u000e\u0010I\u001a\u00020G2\u0006\u0010J\u001a\u00020KJ\u000e\u0010I\u001a\u00020G2\u0006\u0010L\u001a\u00020MJ\u000e\u0010I\u001a\u00020G2\u0006\u0010N\u001a\u00020OJ\u000e\u0010P\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-J\u000e\u0010Q\u001a\u00020G2\u0006\u0010R\u001a\u00020SJ\u0006\u0010T\u001a\u00020GJ\u0006\u0010U\u001a\u00020GJ\u000e\u0010V\u001a\u00020G2\u0006\u0010C\u001a\u00020\"J\u0006\u0010W\u001a\u00020\u000eR*\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R!\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0006j\b\u0012\u0004\u0012\u00020\u0017`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\nR\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R$\u00104\u001a\u0002032\u0006\u00102\u001a\u000203@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001c\u00108\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010$\"\u0004\bE\u0010&\u00a8\u0006X"}, d2={"Loupson/apng/ApngAnimator;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "Frames", "Ljava/util/ArrayList;", "Loupson/apng/Frame;", "Lkotlin/collections/ArrayList;", "getFrames", "()Ljava/util/ArrayList;", "setFrames", "(Ljava/util/ArrayList;)V", "activeAnimation", "Landroid/graphics/drawable/AnimationDrawable;", "getActiveAnimation", "()Landroid/graphics/drawable/AnimationDrawable;", "setActiveAnimation", "(Landroid/graphics/drawable/AnimationDrawable;)V", "anim", "getAnim", "setAnim", "background", "Landroid/graphics/Bitmap;", "getBackground", "()Landroid/graphics/Bitmap;", "setBackground", "(Landroid/graphics/Bitmap;)V", "bitmapBuffer", "getBitmapBuffer", "setBitmapBuffer", "getContext", "()Landroid/content/Context;", "counter", "", "getCounter", "()I", "setCounter", "(I)V", "currentDrawable", "getCurrentDrawable", "setCurrentDrawable", "generatedFrame", "getGeneratedFrame", "imageView", "Landroid/widget/ImageView;", "getImageView", "()Landroid/widget/ImageView;", "setImageView", "(Landroid/widget/ImageView;)V", "value", "", "isPlaying", "()Z", "setPlaying", "(Z)V", "lastFrame", "getLastFrame", "()Loupson/apng/Frame;", "setLastFrame", "(Loupson/apng/Frame;)V", "myHandler", "Landroid/os/Handler;", "getMyHandler", "()Landroid/os/Handler;", "setMyHandler", "(Landroid/os/Handler;)V", "speed", "getSpeed", "setSpeed", "draw", "", "extractedFrame", "load", "file", "Ljava/io/File;", "byteArray", "", "string", "", "loadInto", "loadUrl", "url", "Ljava/net/URL;", "pause", "play", "setFrameSpeed", "toAnimationDrawable", "apng_library_release"})
public final class ApngAnimator {
    private boolean isPlaying;
    @NotNull
    private ArrayList<Frame> Frames;
    @NotNull
    private Handler myHandler;
    private int counter;
    @NotNull
    private final ArrayList<Bitmap> generatedFrame;
    private int speed;
    @Nullable
    private Frame lastFrame;
    @Nullable
    private Bitmap bitmapBuffer;
    @Nullable
    private Bitmap background;
    @Nullable
    private ImageView imageView;
    @Nullable
    private AnimationDrawable anim;
    @Nullable
    private AnimationDrawable activeAnimation;
    private int currentDrawable;
    @NotNull
    private final Context context;

    public final boolean isPlaying() {
        return this.isPlaying;
    }

    private final void setPlaying(boolean value) {
        this.isPlaying = value;
    }

    @NotNull
    public final ArrayList<Frame> getFrames() {
        return this.Frames;
    }

    public final void setFrames(@NotNull ArrayList<Frame> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.Frames = arrayList;
    }

    @NotNull
    public final Handler getMyHandler() {
        return this.myHandler;
    }

    public final void setMyHandler(@NotNull Handler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"<set-?>");
        this.myHandler = handler;
    }

    public final int getCounter() {
        return this.counter;
    }

    public final void setCounter(int n) {
        this.counter = n;
    }

    @NotNull
    public final ArrayList<Bitmap> getGeneratedFrame() {
        return this.generatedFrame;
    }

    public final int getSpeed() {
        return this.speed;
    }

    public final void setSpeed(int n) {
        this.speed = n;
    }

    @Nullable
    public final Frame getLastFrame() {
        return this.lastFrame;
    }

    public final void setLastFrame(@Nullable Frame frame) {
        this.lastFrame = frame;
    }

    @Nullable
    public final Bitmap getBitmapBuffer() {
        return this.bitmapBuffer;
    }

    public final void setBitmapBuffer(@Nullable Bitmap bitmap) {
        this.bitmapBuffer = bitmap;
    }

    @Nullable
    public final Bitmap getBackground() {
        return this.background;
    }

    public final void setBackground(@Nullable Bitmap bitmap) {
        this.background = bitmap;
    }

    @Nullable
    public final ImageView getImageView() {
        return this.imageView;
    }

    public final void setImageView(@Nullable ImageView imageView) {
        this.imageView = imageView;
    }

    @Nullable
    public final AnimationDrawable getAnim() {
        return this.anim;
    }

    public final void setAnim(@Nullable AnimationDrawable animationDrawable) {
        this.anim = animationDrawable;
    }

    @Nullable
    public final AnimationDrawable getActiveAnimation() {
        return this.activeAnimation;
    }

    public final void setActiveAnimation(@Nullable AnimationDrawable animationDrawable) {
        this.activeAnimation = animationDrawable;
    }

    public final int getCurrentDrawable() {
        return this.currentDrawable;
    }

    public final void setCurrentDrawable(int n) {
        this.currentDrawable = n;
    }

    @NotNull
    public final ApngAnimator loadInto(@NotNull ImageView imageView) {
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        this.imageView = imageView;
        return this;
    }

    public final void load(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ApngAnimator>, Unit>(this, file){
            final /* synthetic */ ApngAnimator this$0;
            final /* synthetic */ File $file;

            public final void invoke(@NotNull AnkoAsyncContext<ApngAnimator> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                ArrayList<Frame> extractedFrame = new APNGDisassembler(FilesKt.readBytes((File)this.$file)).getPngList();
                ApngAnimator.access$draw(this.this$0, extractedFrame);
                this.this$0.setAnim(this.this$0.toAnimationDrawable());
                this.this$0.setActiveAnimation(this.this$0.getAnim());
                AsyncKt.uiThread($receiver, (Function1)((Function1)new Function1<ApngAnimator, Unit>(this){
                    final /* synthetic */ load.1 this$0;

                    public final void invoke(@NotNull ApngAnimator it) {
                        block2: {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            ImageView imageView = this.this$0.this$0.getImageView();
                            if (imageView != null) {
                                imageView.setImageBitmap(this.this$0.this$0.getGeneratedFrame().get(0));
                            }
                            ImageView imageView2 = this.this$0.this$0.getImageView();
                            if (imageView2 != null) {
                                imageView2.setImageDrawable((Drawable)this.this$0.this$0.getActiveAnimation());
                            }
                            AnimationDrawable animationDrawable = this.this$0.this$0.getActiveAnimation();
                            if (animationDrawable == null) break block2;
                            animationDrawable.start();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = apngAnimator;
                this.$file = file;
                super(1);
            }
        }), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void draw(ArrayList<Frame> extractedFrame) {
        this.Frames = extractedFrame;
        Integer n = this.Frames.get(0).getMaxWidth();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        int n2 = n;
        Integer n3 = this.Frames.get(0).getMaxHeight();
        if (n3 == null) {
            Intrinsics.throwNpe();
        }
        this.bitmapBuffer = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int n4 = 0;
        int n5 = this.Frames.size();
        while (n4 < n5) {
            void i;
            Frame it = this.Frames.get((int)i);
            Integer n6 = this.Frames.get(0).getMaxWidth();
            if (n6 == null) {
                Intrinsics.throwNpe();
            }
            int n7 = n6;
            Integer n8 = this.Frames.get(0).getMaxHeight();
            if (n8 == null) {
                Intrinsics.throwNpe();
            }
            Bitmap btm = Bitmap.createBitmap((int)n7, (int)n8, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(btm);
            Bitmap current = BitmapFactory.decodeByteArray((byte[])it.getByteArray(), (int)0, (int)it.getByteArray().length).copy(Bitmap.Config.ARGB_8888, true);
            canvas.drawBitmap(this.bitmapBuffer, 0.0f, 0.0f, null);
            if (it.getBlend_op() == Utils.Companion.blend_op.APNG_BLEND_OP_SOURCE) {
                Integer n9 = it.getX_offsets();
                if (n9 == null) {
                    Intrinsics.throwNpe();
                }
                float f = n9.intValue();
                Integer n10 = it.getY_offsets();
                if (n10 == null) {
                    Intrinsics.throwNpe();
                }
                float f2 = n10.intValue();
                Integer n11 = it.getX_offsets();
                if (n11 == null) {
                    Intrinsics.throwNpe();
                }
                float f3 = n11.intValue();
                Bitmap bitmap = current;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"current");
                float f4 = f3 + (float)bitmap.getWidth();
                Integer n12 = it.getY_offsets();
                if (n12 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawRect(f, f2, f4, (float)n12.intValue() + (float)current.getHeight(), (Paint)((Function0)draw.1.INSTANCE).invoke());
            }
            Integer n13 = it.getX_offsets();
            if (n13 == null) {
                Intrinsics.throwNpe();
            }
            float f = n13.intValue();
            Integer n14 = it.getY_offsets();
            if (n14 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawBitmap(current, f, (float)n14.intValue(), null);
            this.generatedFrame.add(btm);
            if (this.Frames.get((int)i).getDispose_op() != Utils.Companion.dispose_op.APNG_DISPOSE_OP_PREVIOUS) {
                if (it.getDispose_op() == Utils.Companion.dispose_op.APNG_DISPOSE_OP_BACKGROUND) {
                    Integer n15 = this.Frames.get(0).getMaxWidth();
                    if (n15 == null) {
                        Intrinsics.throwNpe();
                    }
                    int n16 = n15;
                    Integer n17 = this.Frames.get(0).getMaxHeight();
                    if (n17 == null) {
                        Intrinsics.throwNpe();
                    }
                    Bitmap res = Bitmap.createBitmap((int)n16, (int)n17, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas can = new Canvas(res);
                    can.drawBitmap(btm, 0.0f, 0.0f, null);
                    Integer n18 = it.getX_offsets();
                    if (n18 == null) {
                        Intrinsics.throwNpe();
                    }
                    float f5 = n18.intValue();
                    Integer n19 = it.getY_offsets();
                    if (n19 == null) {
                        Intrinsics.throwNpe();
                    }
                    float f6 = n19.intValue();
                    Integer n20 = it.getX_offsets();
                    if (n20 == null) {
                        Intrinsics.throwNpe();
                    }
                    float f7 = (float)n20.intValue() + (float)it.getWidth();
                    Integer n21 = it.getY_offsets();
                    if (n21 == null) {
                        Intrinsics.throwNpe();
                    }
                    can.drawRect(f5, f6, f7, (float)n21.intValue() + (float)it.getHeight(), (Paint)((Function0)draw.2.INSTANCE).invoke());
                    this.bitmapBuffer = res;
                } else {
                    this.bitmapBuffer = btm;
                }
            }
            ++i;
        }
    }

    public final void loadUrl(@NotNull URL url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        AsyncKt.doAsync((Object)this, (Function1)loadUrl.1.INSTANCE, (Function1)((Function1)new Function1<AnkoAsyncContext<ApngAnimator>, Unit>(this, url){
            final /* synthetic */ ApngAnimator this$0;
            final /* synthetic */ URL $url;

            public final void invoke(@NotNull AnkoAsyncContext<ApngAnimator> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                ArrayList<Frame> extractedFrame = new APNGDisassembler(new Loader().load(this.this$0.getContext(), this.$url)).getPngList();
                ApngAnimator.access$draw(this.this$0, extractedFrame);
                this.this$0.setAnim(this.this$0.toAnimationDrawable());
                this.this$0.setActiveAnimation(this.this$0.getAnim());
                AsyncKt.uiThread($receiver, (Function1)((Function1)new Function1<ApngAnimator, Unit>(this){
                    final /* synthetic */ loadUrl.2 this$0;

                    public final void invoke(@NotNull ApngAnimator it) {
                        block2: {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            ImageView imageView = this.this$0.this$0.getImageView();
                            if (imageView != null) {
                                imageView.setImageBitmap(this.this$0.this$0.getGeneratedFrame().get(0));
                            }
                            ImageView imageView2 = this.this$0.this$0.getImageView();
                            if (imageView2 != null) {
                                imageView2.setImageDrawable((Drawable)this.this$0.this$0.getActiveAnimation());
                            }
                            AnimationDrawable animationDrawable = this.this$0.this$0.getActiveAnimation();
                            if (animationDrawable == null) break block2;
                            animationDrawable.start();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = apngAnimator;
                this.$url = uRL;
                super(1);
            }
        }));
    }

    public final void load(@NotNull byte[] byteArray) {
        Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ApngAnimator>, Unit>(this, byteArray){
            final /* synthetic */ ApngAnimator this$0;
            final /* synthetic */ byte[] $byteArray;

            public final void invoke(@NotNull AnkoAsyncContext<ApngAnimator> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                ArrayList<Frame> extractedFrame = new APNGDisassembler(this.$byteArray).getPngList();
                ApngAnimator.access$draw(this.this$0, extractedFrame);
                this.this$0.setAnim(this.this$0.toAnimationDrawable());
                this.this$0.setActiveAnimation(this.this$0.getAnim());
                AsyncKt.uiThread($receiver, (Function1)((Function1)new Function1<ApngAnimator, Unit>(this){
                    final /* synthetic */ load.2 this$0;

                    public final void invoke(@NotNull ApngAnimator it) {
                        block2: {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            ImageView imageView = this.this$0.this$0.getImageView();
                            if (imageView != null) {
                                imageView.setImageBitmap(this.this$0.this$0.getGeneratedFrame().get(0));
                            }
                            ImageView imageView2 = this.this$0.this$0.getImageView();
                            if (imageView2 != null) {
                                imageView2.setImageDrawable((Drawable)this.this$0.this$0.getActiveAnimation());
                            }
                            AnimationDrawable animationDrawable = this.this$0.this$0.getActiveAnimation();
                            if (animationDrawable == null) break block2;
                            animationDrawable.start();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = apngAnimator;
                this.$byteArray = byArray;
                super(1);
            }
        }), (int)1, null);
    }

    public final void load(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"http", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)string, (CharSequence)"https", (boolean)false, (int)2, null)) {
            URL url = new URL(string);
            this.loadUrl(url);
        } else if (new File(string).exists()) {
            this.load(new File(string));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void pause() {
        this.setPlaying(false);
        AnimationDrawable animResume = new AnimationDrawable();
        AnimationDrawable animationDrawable = this.activeAnimation;
        if (animationDrawable != null) {
            animationDrawable.stop();
        }
        AnimationDrawable animationDrawable2 = this.activeAnimation;
        if (animationDrawable2 == null) {
            Intrinsics.throwNpe();
        }
        Drawable currentFrame = animationDrawable2.getCurrent();
        int n = 0;
        AnimationDrawable animationDrawable3 = this.anim;
        Integer n2 = animationDrawable3 != null ? Integer.valueOf(animationDrawable3.getNumberOfFrames()) : null;
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        int n3 = n2;
        while (n < n3) {
            void i;
            Drawable checkFrame;
            AnimationDrawable animationDrawable4 = this.activeAnimation;
            if (animationDrawable4 == null) {
                Intrinsics.throwNpe();
            }
            if ((checkFrame = animationDrawable4.getFrame((int)i)) == currentFrame) {
                Drawable frame;
                int k;
                void frameIndex;
                void var7_7 = frameIndex = i;
                AnimationDrawable animationDrawable5 = this.activeAnimation;
                if (animationDrawable5 == null) {
                    Intrinsics.throwNpe();
                }
                int n4 = animationDrawable5.getNumberOfFrames();
                while (var7_7 < n4) {
                    AnimationDrawable animationDrawable6 = this.activeAnimation;
                    if (animationDrawable6 == null) {
                        Intrinsics.throwNpe();
                    }
                    frame = animationDrawable6.getFrame(k);
                    AnimationDrawable animationDrawable7 = this.activeAnimation;
                    Integer n5 = animationDrawable7 != null ? Integer.valueOf(animationDrawable7.getDuration(k)) : null;
                    if (n5 == null) {
                        Intrinsics.throwNpe();
                    }
                    animResume.addFrame(frame, n5.intValue());
                    ++k;
                }
                n4 = frameIndex;
                for (k = 0; k < n4; ++k) {
                    AnimationDrawable animationDrawable8 = this.activeAnimation;
                    if (animationDrawable8 == null) {
                        Intrinsics.throwNpe();
                    }
                    frame = animationDrawable8.getFrame(k);
                    AnimationDrawable animationDrawable9 = this.activeAnimation;
                    Integer n6 = animationDrawable9 != null ? Integer.valueOf(animationDrawable9.getDuration(k)) : null;
                    if (n6 == null) {
                        Intrinsics.throwNpe();
                    }
                    animResume.addFrame(frame, n6.intValue());
                }
                this.activeAnimation = animResume;
                ImageView imageView = this.imageView;
                if (imageView != null) {
                    imageView.setImageDrawable((Drawable)this.activeAnimation);
                }
                ImageView imageView2 = this.imageView;
                if (imageView2 != null) {
                    imageView2.invalidate();
                }
                break;
            }
            ++i;
        }
    }

    public final void play() {
        block0: {
            this.setPlaying(true);
            AnimationDrawable animationDrawable = this.activeAnimation;
            if (animationDrawable == null) break block0;
            animationDrawable.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnimationDrawable toAnimationDrawable() {
        AnimationDrawable animDrawable = new AnimationDrawable();
        int n = 0;
        int n2 = this.generatedFrame.size();
        while (n < n2) {
            void i;
            Bitmap bitmap = this.generatedFrame.get((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"generatedFrame[i]");
            animDrawable.addFrame((Drawable)new BitmapDrawable(bitmap), (int)this.Frames.get((int)i).getDelay());
            ++i;
        }
        return animDrawable;
    }

    public final void setFrameSpeed(int speed) {
        this.speed = speed;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public ApngAnimator(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.isPlaying = true;
        this.Frames = new ArrayList();
        this.myHandler = new Handler();
        this.generatedFrame = new ArrayList();
        this.speed = 1;
    }

    public static final /* synthetic */ void access$draw(ApngAnimator $this, @NotNull ArrayList extractedFrame) {
        $this.draw(extractedFrame);
    }
}

