/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng.encoder;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import oupson.apng.exceptions.BadParameterException;
import oupson.apng.exceptions.InvalidFrameSizeException;
import oupson.apng.utils.Utils;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 B2\u00020\u0001:\u0001BB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010!\u001a\u00020\u0005J\u0006\u0010\"\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\u0014J\u0006\u0010%\u001a\u00020\u0014J\u0006\u0010&\u001a\u00020\u0014J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0014J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0014J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0005J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0006\u0010/\u001a\u00020\u001dJ8\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u0005H\u0002JB\u0010:\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\n2\b\b\u0002\u00102\u001a\u0002032\b\b\u0002\u00108\u001a\u00020\u00052\b\b\u0002\u00109\u001a\u00020\u00052\b\b\u0002\u00106\u001a\u0002072\b\b\u0002\u00104\u001a\u000205H\u0007JB\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020<2\b\b\u0002\u00102\u001a\u0002032\b\b\u0002\u00108\u001a\u00020\u00052\b\b\u0002\u00109\u001a\u00020\u00052\b\b\u0002\u00106\u001a\u0002072\b\b\u0002\u00104\u001a\u000205H\u0007J\b\u0010=\u001a\u00020\u001dH\u0002J\u0010\u0010>\u001a\u00020\u00142\u0006\u0010?\u001a\u00020\nH\u0002J\u0010\u0010@\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020\u0005H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Loupson/apng/encoder/ApngEncoder;", "", "outputStream", "Ljava/io/OutputStream;", "width", "", "height", "numberOfFrames", "(Ljava/io/OutputStream;III)V", "bitmapBuffer", "Landroid/graphics/Bitmap;", "bytesPerPixel", "compressionLevel", "crc", "Ljava/util/zip/CRC32;", "crcValue", "", "currentFrame", "currentSeq", "encodeAlpha", "", "filter", "firstFrameInAnim", "leftBytes", "", "optimise", "priorRow", "repetitionCount", "filterSub", "", "pixels", "startPos", "filterUp", "getCompressionLevel", "getFilter", "getRepetitionCount", "isAlphaEncoded", "isFirstFrameInAnim", "isOptimisingApng", "setCompressionLevel", "setEncodeAlpha", "setFilter", "setIsFirstFrameInAnim", "setOptimiseApng", "setRepetitionCount", "writeACTL", "num", "writeEnd", "writeFCTL", "btm", "delay", "", "disposeOp", "Loupson/apng/utils/Utils$Companion$DisposeOp;", "blendOp", "Loupson/apng/utils/Utils$Companion$BlendOp;", "xOffsets", "yOffsets", "writeFrame", "inputStream", "Ljava/io/InputStream;", "writeHeader", "writeImageData", "image", "writeInt4", "n", "Companion", "apng_library_release"})
public final class ApngEncoder {
    private int currentFrame;
    private int currentSeq;
    private CRC32 crc;
    private long crcValue;
    private int bytesPerPixel;
    private int compressionLevel;
    private int filter;
    private boolean encodeAlpha;
    private byte[] priorRow;
    private byte[] leftBytes;
    private int repetitionCount;
    private boolean firstFrameInAnim;
    private boolean optimise;
    private Bitmap bitmapBuffer;
    private final OutputStream outputStream;
    private final int width;
    private final int height;
    private static final String TAG = "ApngEncoder";
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    public static final int FILTER_UP = 2;
    public static final int FILTER_LAST = 2;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ApngEncoder setEncodeAlpha(boolean encodeAlpha) {
        if (this.optimise && !encodeAlpha) {
            throw (Throwable)new BadParameterException("If encodeAlpha is false, then optimise must be false");
        }
        this.encodeAlpha = encodeAlpha;
        return this;
    }

    public final boolean isAlphaEncoded() {
        return this.encodeAlpha;
    }

    @NotNull
    public final ApngEncoder setFilter(int filter) throws BadParameterException {
        if (filter > 2) {
            throw (Throwable)new BadParameterException("Invalid filter value");
        }
        this.filter = filter;
        return this;
    }

    public final int getFilter() {
        return this.filter;
    }

    @NotNull
    public final ApngEncoder setRepetitionCount(int repetitionCount) {
        this.repetitionCount = repetitionCount;
        return this;
    }

    public final int getRepetitionCount() {
        return this.repetitionCount;
    }

    @NotNull
    public final ApngEncoder setCompressionLevel(int compressionLevel) throws BadParameterException {
        int n = compressionLevel;
        if (0 > n || 9 < n) {
            throw (Throwable)new BadParameterException("Invalid compression level : " + compressionLevel + ", expected a number in range 0..9");
        }
        this.compressionLevel = compressionLevel;
        return this;
    }

    public final int getCompressionLevel() {
        return this.compressionLevel;
    }

    @NotNull
    public final ApngEncoder setIsFirstFrameInAnim(boolean firstFrameInAnim) {
        this.firstFrameInAnim = firstFrameInAnim;
        return this;
    }

    public final boolean isFirstFrameInAnim() {
        return this.firstFrameInAnim;
    }

    @NotNull
    public final ApngEncoder setOptimiseApng(boolean optimise) {
        if (optimise && !this.encodeAlpha) {
            throw (Throwable)new BadParameterException("If optimise is set to true, then encodeAlpha must be true");
        }
        this.optimise = optimise;
        return this;
    }

    public final boolean isOptimisingApng() {
        return this.optimise;
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream, float delay, int xOffsets, int yOffsets, @NotNull Utils.Companion.BlendOp blendOp, @NotNull Utils.Companion.DisposeOp disposeOp) throws NullPointerException, InvalidFrameSizeException, IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)((Object)blendOp), (String)"blendOp");
        Intrinsics.checkNotNullParameter((Object)((Object)disposeOp), (String)"disposeOp");
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        Intrinsics.checkNotNull((Object)bitmap);
        Bitmap btm = bitmap;
        this.writeFrame(btm, delay, xOffsets, yOffsets, blendOp, disposeOp);
        btm.recycle();
    }

    public static /* synthetic */ void writeFrame$default(ApngEncoder apngEncoder, InputStream inputStream, float f, int n, int n2, Utils.Companion.BlendOp blendOp, Utils.Companion.DisposeOp disposeOp, int n3, Object object) throws NullPointerException, InvalidFrameSizeException, IOException {
        if ((n3 & 2) != 0) {
            f = 1000.0f;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x10) != 0) {
            blendOp = Utils.Companion.BlendOp.APNG_BLEND_OP_SOURCE;
        }
        if ((n3 & 0x20) != 0) {
            disposeOp = Utils.Companion.DisposeOp.APNG_DISPOSE_OP_NONE;
        }
        apngEncoder.writeFrame(inputStream, f, n, n2, blendOp, disposeOp);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream, float delay, int xOffsets, int yOffsets, @NotNull Utils.Companion.BlendOp blendOp) throws NullPointerException, InvalidFrameSizeException, IOException {
        ApngEncoder.writeFrame$default(this, inputStream, delay, xOffsets, yOffsets, blendOp, null, 32, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream, float delay, int xOffsets, int yOffsets) throws NullPointerException, InvalidFrameSizeException, IOException {
        ApngEncoder.writeFrame$default(this, inputStream, delay, xOffsets, yOffsets, null, null, 48, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream, float delay, int xOffsets) throws NullPointerException, InvalidFrameSizeException, IOException {
        ApngEncoder.writeFrame$default(this, inputStream, delay, xOffsets, 0, null, null, 56, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream, float delay) throws NullPointerException, InvalidFrameSizeException, IOException {
        ApngEncoder.writeFrame$default(this, inputStream, delay, 0, 0, null, null, 60, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull InputStream inputStream) throws NullPointerException, InvalidFrameSizeException, IOException {
        ApngEncoder.writeFrame$default(this, inputStream, 0.0f, 0, 0, null, null, 62, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap btm, float delay, int xOffsets, int yOffsets, @NotNull Utils.Companion.BlendOp blendOp, @NotNull Utils.Companion.DisposeOp disposeOp) throws InvalidFrameSizeException, IOException {
        Intrinsics.checkNotNullParameter((Object)btm, (String)"btm");
        Intrinsics.checkNotNullParameter((Object)((Object)blendOp), (String)"blendOp");
        Intrinsics.checkNotNullParameter((Object)((Object)disposeOp), (String)"disposeOp");
        if (this.currentFrame == 0 && (btm.getWidth() != this.width || btm.getHeight() != this.height)) {
            throw (Throwable)new InvalidFrameSizeException(btm.getWidth(), btm.getHeight(), this.width, this.height, this.currentFrame == 0);
        }
        Bitmap frameBtm = btm;
        int frameXOffsets = xOffsets;
        int frameYOffsets = yOffsets;
        Utils.Companion.BlendOp frameBlendOp = blendOp;
        if (this.optimise && this.currentFrame != 0 || this.currentFrame == 0 && this.firstFrameInAnim) {
            if (this.bitmapBuffer == null) {
                this.bitmapBuffer = btm.copy(btm.getConfig(), false);
            } else {
                Bitmap bitmap = this.bitmapBuffer;
                Intrinsics.checkNotNull((Object)bitmap);
                Utils.Companion.DiffResult diff = Utils.Companion.getDiffBitmap(bitmap, btm);
                frameBtm = diff.getBitmap();
                frameXOffsets = diff.getOffsetX();
                frameYOffsets = diff.getOffsetY();
                frameBlendOp = diff.getBlendOp();
                this.bitmapBuffer = btm.copy(btm.getConfig(), false);
            }
        }
        if (frameBtm.getWidth() > this.width || frameBtm.getHeight() > this.height) {
            throw (Throwable)new InvalidFrameSizeException(frameBtm.getWidth(), frameBtm.getHeight(), this.width, this.height, this.currentFrame == 0);
        }
        if (this.firstFrameInAnim || this.currentFrame != 0) {
            this.writeFCTL(frameBtm, delay, disposeOp, frameBlendOp, frameXOffsets, frameYOffsets);
        }
        this.writeImageData(frameBtm);
        int n = this.currentFrame;
        this.currentFrame = n + 1;
    }

    public static /* synthetic */ void writeFrame$default(ApngEncoder apngEncoder, Bitmap bitmap, float f, int n, int n2, Utils.Companion.BlendOp blendOp, Utils.Companion.DisposeOp disposeOp, int n3, Object object) throws InvalidFrameSizeException, IOException {
        if ((n3 & 2) != 0) {
            f = 1000.0f;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x10) != 0) {
            blendOp = Utils.Companion.BlendOp.APNG_BLEND_OP_SOURCE;
        }
        if ((n3 & 0x20) != 0) {
            disposeOp = Utils.Companion.DisposeOp.APNG_DISPOSE_OP_NONE;
        }
        apngEncoder.writeFrame(bitmap, f, n, n2, blendOp, disposeOp);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap btm, float delay, int xOffsets, int yOffsets, @NotNull Utils.Companion.BlendOp blendOp) throws InvalidFrameSizeException, IOException {
        ApngEncoder.writeFrame$default(this, btm, delay, xOffsets, yOffsets, blendOp, null, 32, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap btm, float delay, int xOffsets, int yOffsets) throws InvalidFrameSizeException, IOException {
        ApngEncoder.writeFrame$default(this, btm, delay, xOffsets, yOffsets, null, null, 48, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap btm, float delay, int xOffsets) throws InvalidFrameSizeException, IOException {
        ApngEncoder.writeFrame$default(this, btm, delay, xOffsets, 0, null, null, 56, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap btm, float delay) throws InvalidFrameSizeException, IOException {
        ApngEncoder.writeFrame$default(this, btm, delay, 0, 0, null, null, 60, null);
    }

    @JvmOverloads
    public final void writeFrame(@NotNull Bitmap btm) throws InvalidFrameSizeException, IOException {
        ApngEncoder.writeFrame$default(this, btm, 0.0f, 0, 0, null, null, 62, null);
    }

    public final void writeEnd() throws IOException {
        this.outputStream.write(new byte[]{0, 0, 0, 0});
        byte[] iend = Utils.Companion.getIEND();
        this.crc.reset();
        this.crc.update(iend, 0, iend.length);
        this.outputStream.write(iend);
        this.outputStream.write(Utils.Companion.uIntToByteArray((int)this.crc.getValue()));
    }

    private final void writeHeader() throws IOException {
        this.writeInt4(13);
        ByteArrayOutputStream header = new ByteArrayOutputStream(17);
        header.write(Utils.Companion.getIHDR());
        header.write(Utils.Companion.uIntToByteArray(this.width));
        header.write(Utils.Companion.uIntToByteArray(this.height));
        header.write(8);
        header.write(this.encodeAlpha ? 6 : 2);
        header.write(0);
        header.write(0);
        header.write(0);
        byte[] headerBytes = header.toByteArray();
        this.outputStream.write(headerBytes);
        this.crc.reset();
        this.crc.update(headerBytes);
        this.crcValue = this.crc.getValue();
        this.writeInt4((int)this.crcValue);
    }

    private final void writeInt4(int n) throws IOException {
        this.outputStream.write(Utils.Companion.uIntToByteArray(n));
    }

    private final void writeACTL(int num) throws IOException {
        this.outputStream.write(new byte[]{0, 0, 0, 8});
        ByteArrayOutputStream acTL2 = new ByteArrayOutputStream(12);
        acTL2.write(Utils.Companion.getAcTL());
        acTL2.write(Utils.Companion.uIntToByteArray(num));
        acTL2.write(Utils.Companion.uIntToByteArray(this.repetitionCount));
        byte[] acTLBytes = acTL2.toByteArray();
        this.outputStream.write(acTLBytes);
        this.crc.reset();
        this.crc.update(acTLBytes, 0, acTLBytes.length);
        this.outputStream.write(Utils.Companion.uIntToByteArray((int)this.crc.getValue()));
    }

    private final void writeFCTL(Bitmap btm, float delay, Utils.Companion.DisposeOp disposeOp, Utils.Companion.BlendOp blendOp, int xOffsets, int yOffsets) throws IOException {
        this.outputStream.write(new byte[]{0, 0, 0, 26});
        ByteArrayOutputStream fcTL2 = new ByteArrayOutputStream(30);
        fcTL2.write(Utils.Companion.getFcTL());
        int n = this.currentSeq;
        this.currentSeq = n + 1;
        fcTL2.write(Utils.Companion.uIntToByteArray(n));
        fcTL2.write(Utils.Companion.uIntToByteArray(btm.getWidth()));
        fcTL2.write(Utils.Companion.uIntToByteArray(btm.getHeight()));
        fcTL2.write(Utils.Companion.uIntToByteArray(xOffsets));
        fcTL2.write(Utils.Companion.uIntToByteArray(yOffsets));
        fcTL2.write(Utils.Companion.uShortToByteArray((short)delay));
        fcTL2.write(Utils.Companion.uShortToByteArray((short)1000));
        fcTL2.write(Utils.Companion.encodeDisposeOp(disposeOp));
        fcTL2.write(Utils.Companion.encodeBlendOp(blendOp));
        byte[] fcTLBytes = fcTL2.toByteArray();
        this.crc.reset();
        this.crc.update(fcTLBytes, 0, fcTLBytes.length);
        this.outputStream.write(fcTLBytes);
        this.outputStream.write(Utils.Companion.uIntToByteArray((int)this.crc.getValue()));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean writeImageData(Bitmap image) {
        int startRow = 0;
        int nRows = 0;
        byte[] scanLines = null;
        int scanPos = 0;
        int startPos = 0;
        byte[] compressedLines = null;
        int nCompressed = 0;
        this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        Deflater scrunch = new Deflater(this.compressionLevel);
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream(1024);
        DeflaterOutputStream compBytes = new DeflaterOutputStream((OutputStream)outBytes, scrunch);
        try {
            int n;
            for (int rowsLeft = image.getHeight(); rowsLeft > 0; rowsLeft -= nRows) {
                int n2 = Short.MAX_VALUE / (image.getWidth() * (this.bytesPerPixel + 1));
                n = 0;
                nRows = Math.min(n2, rowsLeft);
                n2 = 1;
                n = 0;
                nRows = Math.max(nRows, n2);
                int[] pixels = new int[image.getWidth() * nRows];
                image.getPixels(pixels, 0, image.getWidth(), 0, startRow, image.getWidth(), nRows);
                scanLines = new byte[image.getWidth() * nRows * this.bytesPerPixel + nRows];
                if (this.filter == 1) {
                    this.leftBytes = new byte[16];
                }
                if (this.filter == 2) {
                    this.priorRow = new byte[image.getWidth() * this.bytesPerPixel];
                }
                scanPos = 0;
                startPos = 1;
                n = 0;
                int n3 = image.getWidth() * nRows;
                while (n < n3) {
                    void i;
                    if (i % image.getWidth() == false) {
                        scanLines[scanPos++] = (byte)this.filter;
                        startPos = scanPos;
                    }
                    scanLines[scanPos++] = (byte)(pixels[i] >> 16 & 0xFF);
                    scanLines[scanPos++] = (byte)(pixels[i] >> 8 & 0xFF);
                    scanLines[scanPos++] = (byte)(pixels[i] & 0xFF);
                    if (this.encodeAlpha) {
                        scanLines[scanPos++] = (byte)(pixels[i] >> 24 & 0xFF);
                    }
                    if (i % image.getWidth() == image.getWidth() - 1 && this.filter != 0) {
                        if (this.filter == 1) {
                            this.filterSub(scanLines, startPos, image.getWidth());
                        }
                        if (this.filter == 2) {
                            this.filterUp(scanLines, startPos, image.getWidth());
                        }
                    }
                    ++i;
                }
                compBytes.write(scanLines, 0, scanPos);
                startRow += nRows;
            }
            compBytes.close();
            byte[] byArray = outBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outBytes.toByteArray()");
            compressedLines = byArray;
            nCompressed = compressedLines.length;
            this.crc.reset();
            this.writeInt4(nCompressed + (this.currentFrame == 0 ? 0 : 4));
            if (this.currentFrame == 0) {
                this.outputStream.write(Utils.Companion.getIDAT());
                this.crc.update(Utils.Companion.getIDAT());
            } else {
                n = this.currentSeq;
                this.currentSeq = n + 1;
                byte[] fdat = ArraysKt.plus((byte[])Utils.Companion.getFdAT(), (byte[])Utils.Companion.uIntToByteArray(n));
                this.outputStream.write(fdat);
                this.crc.update(fdat);
            }
            this.outputStream.write(compressedLines);
            this.crc.update(compressedLines, 0, nCompressed);
            this.crcValue = this.crc.getValue();
            this.writeInt4((int)this.crcValue);
            scrunch.finish();
            scrunch.end();
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error while writing IDAT/fdAT chunks", (Throwable)e);
            return false;
        }
    }

    private final void filterSub(byte[] pixels, int startPos, int width) {
        int offset = this.bytesPerPixel;
        int actualStart = startPos + offset;
        int nBytes = width * this.bytesPerPixel;
        int leftInsert = offset;
        int leftExtract = 0;
        for (int i = actualStart; i < startPos + nBytes; ++i) {
            Intrinsics.checkNotNull((Object)this.leftBytes);
            this.leftBytes[leftInsert] = pixels[i];
            byte by = pixels[i];
            Intrinsics.checkNotNull((Object)this.leftBytes);
            pixels[i] = (byte)((by - this.leftBytes[leftExtract]) % 256);
            leftInsert = (leftInsert + 1) % 15;
            leftExtract = (leftExtract + 1) % 15;
        }
    }

    private final void filterUp(byte[] pixels, int startPos, int width) {
        int nBytes = width * this.bytesPerPixel;
        byte currentByte = 0;
        for (int i = 0; i < nBytes; ++i) {
            currentByte = pixels[startPos + i];
            byte by = pixels[startPos + i];
            Intrinsics.checkNotNull((Object)this.priorRow);
            pixels[startPos + i] = (byte)((by - this.priorRow[i]) % 256);
            Intrinsics.checkNotNull((Object)this.priorRow);
            this.priorRow[i] = currentByte;
        }
    }

    public ApngEncoder(@NotNull OutputStream outputStream, int width, int height, int numberOfFrames) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.outputStream = outputStream;
        this.width = width;
        this.height = height;
        this.crc = new CRC32();
        this.encodeAlpha = true;
        this.firstFrameInAnim = true;
        this.optimise = true;
        this.outputStream.write(Utils.Companion.getPngSignature());
        this.writeHeader();
        this.writeACTL(numberOfFrames);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Loupson/apng/encoder/ApngEncoder$Companion;", "", "()V", "FILTER_LAST", "", "FILTER_NONE", "FILTER_SUB", "FILTER_UP", "TAG", "", "apng_library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

