/*
 * Decompiled with CFR 0.152.
 */
package com.werb.pickphotoview.util;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import androidx.core.content.FileProvider;
import com.werb.pickphotoview.util.PickConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PickUtils {
    private static PickUtils mInstance = null;
    private Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PickUtils getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<PickUtils> clazz = PickUtils.class;
        synchronized (PickUtils.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PickUtils(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private PickUtils(Context context) {
        this.context = context;
    }

    public int getWidthPixels() {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        Configuration cf = this.context.getResources().getConfiguration();
        int ori = cf.orientation;
        if (ori == 2) {
            return displayMetrics.heightPixels;
        }
        if (ori == 1) {
            return displayMetrics.widthPixels;
        }
        return 0;
    }

    public int getHeightPixels() {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        Configuration cf = this.context.getResources().getConfiguration();
        int ori = cf.orientation;
        if (ori == 2) {
            return displayMetrics.widthPixels;
        }
        if (ori == 1) {
            return displayMetrics.heightPixels;
        }
        return 0;
    }

    public int dp2px(float dpValue) {
        float scale = this.context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public int px2dp(float pxValue) {
        float scale = this.context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    private int computeScale(BitmapFactory.Options options, int dstw, int dsth) {
        int inSampleSize = 1;
        if (dstw == 0 || dsth == 0) {
            return inSampleSize;
        }
        int width = options.outWidth;
        int height = options.outHeight;
        if (width > dstw || height > dsth) {
            int heightRatio = Math.round((float)height / (float)dsth);
            int widthRatio = Math.round((float)width / (float)dstw);
            inSampleSize = Math.min(heightRatio, widthRatio);
        }
        return inSampleSize;
    }

    public Bitmap loadBitmap(String path, int maxWidth, int maxHeight) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            try {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                options.inSampleSize = this.computeScale(options, maxWidth, maxHeight);
                options.inJustDecodeBounds = false;
                Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                return this.matrixBitmap(bitmap);
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
        return null;
    }

    private Bitmap matrixBitmap(Bitmap bitmap) {
        Matrix matrix = new Matrix();
        float scaleX = (float)this.getWidthPixels() / (float)bitmap.getWidth();
        float scaleY = (float)this.getHeightPixels() / (float)bitmap.getHeight();
        float originalScale = Math.min(scaleX, scaleY);
        matrix.setScale(originalScale, originalScale);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
    }

    public Uri getUri(File file) {
        try {
            if (Build.VERSION.SDK_INT > 23) {
                String authority = this.context.getApplicationInfo().packageName + ".provider";
                Log.d((String)PickConfig.INSTANCE.getTAG(), (String)("authority:" + authority));
                return FileProvider.getUriForFile((Context)this.context.getApplicationContext(), (String)authority, (File)file);
            }
            return Uri.fromFile((File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getSavePhotoDir(Context context) {
        return context.getPackageName() + File.separator + "Photo";
    }

    private File createDir(String directory) {
        File createDir = new File(Environment.getExternalStorageDirectory() + File.separator + directory);
        if (!createDir.exists()) {
            if (createDir.mkdirs()) {
                return createDir;
            }
        } else {
            return createDir;
        }
        return null;
    }

    public File getPhotoFile(Context context) {
        File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        if (!dir.exists()) {
            dir = this.createDir(this.getSavePhotoDir(context));
        }
        return new File(dir, "capture.jpg");
    }

    private String getPhotoFileName() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("'IMG'_yyyyMMdd_HHmmss");
        return dateFormat.format(date) + ".jpg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilePath(Context context) {
        File oldFile = this.getPhotoFile(context);
        File dir = this.createDir(this.getSavePhotoDir(context));
        File newFile = new File(dir, this.getPhotoFileName());
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int byteread;
            in = new FileInputStream(oldFile);
            out = new FileOutputStream(newFile);
            byte[] buffer = new byte[1024];
            while ((byteread = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (oldFile.exists()) {
                    oldFile.delete();
                }
                return newFile.getPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

