/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.hardware;

import java.net.NetworkInterface;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.platform.linux.LinuxNetworks;
import oshi.hardware.platform.mac.MacNetworks;
import oshi.hardware.platform.unix.freebsd.FreeBsdNetworks;
import oshi.hardware.platform.unix.solaris.SolarisNetworks;
import oshi.hardware.platform.windows.WindowsNetworks;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.util.PropertiesUtil;

public class NetworkIF
extends AbstractOshiJsonObject {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(NetworkIF.class);
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.hardware.NetworkIF networkIf = new oshi.hardware.NetworkIF();

    public NetworkInterface getNetworkInterface() {
        return this.networkIf.getNetworkInterface();
    }

    public void setNetworkInterface(NetworkInterface networkInterface) {
        this.networkIf.setNetworkInterface(networkInterface);
    }

    public String getName() {
        return this.networkIf.getName();
    }

    public String getDisplayName() {
        return this.networkIf.getDisplayName();
    }

    public int getMTU() {
        return this.networkIf.getMTU();
    }

    public String getMacaddr() {
        return this.networkIf.getMacaddr();
    }

    public String[] getIPv4addr() {
        return this.networkIf.getIPv4addr();
    }

    public String[] getIPv6addr() {
        return this.networkIf.getIPv6addr();
    }

    public long getBytesRecv() {
        return this.networkIf.getBytesRecv();
    }

    public void setBytesRecv(long bytesRecv) {
        this.networkIf.setBytesRecv(bytesRecv);
    }

    public long getBytesSent() {
        return this.networkIf.getBytesSent();
    }

    public void setBytesSent(long bytesSent) {
        this.networkIf.setBytesSent(bytesSent);
    }

    public long getPacketsRecv() {
        return this.networkIf.getPacketsRecv();
    }

    public void setPacketsRecv(long packetsRecv) {
        this.networkIf.setPacketsRecv(packetsRecv);
    }

    public long getPacketsSent() {
        return this.networkIf.getPacketsSent();
    }

    public void setPacketsSent(long packetsSent) {
        this.networkIf.setPacketsSent(packetsSent);
    }

    public long getInErrors() {
        return this.networkIf.getInErrors();
    }

    public void setInErrors(long inErrors) {
        this.networkIf.setInErrors(inErrors);
    }

    public long getOutErrors() {
        return this.networkIf.getOutErrors();
    }

    public void setOutErrors(long outErrors) {
        this.networkIf.setOutErrors(outErrors);
    }

    public long getSpeed() {
        return this.networkIf.getSpeed();
    }

    public void setSpeed(long speed) {
        this.networkIf.setSpeed(speed);
    }

    public long getTimeStamp() {
        return this.networkIf.getTimeStamp();
    }

    public void setTimeStamp(long timeStamp) {
        this.networkIf.setTimeStamp(timeStamp);
    }

    public void updateNetworkStats() {
        switch (SystemInfo.getCurrentPlatformEnum()) {
            case WINDOWS: {
                WindowsNetworks.updateNetworkStats(this.networkIf);
                break;
            }
            case LINUX: {
                LinuxNetworks.updateNetworkStats(this.networkIf);
                break;
            }
            case MACOSX: {
                MacNetworks.updateNetworkStats(this.networkIf);
                break;
            }
            case SOLARIS: {
                SolarisNetworks.updateNetworkStats(this.networkIf);
                break;
            }
            case FREEBSD: {
                FreeBsdNetworks.updateNetworkStats(this.networkIf);
                break;
            }
            default: {
                LOG.error("Unsupported platform. No update performed.");
            }
        }
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.name")) {
            json.add("name", this.getName());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.displayName")) {
            json.add("displayName", this.getDisplayName());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.mac")) {
            json.add("mac", this.getMacaddr());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.ipv4")) {
            JsonArrayBuilder ipv4ArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (String ipv4 : this.getIPv4addr()) {
                ipv4ArrayBuilder.add(ipv4);
            }
            json.add("ipv4", (JsonValue)ipv4ArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.ipv6")) {
            JsonArrayBuilder ipv6ArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (String ipv6 : this.getIPv6addr()) {
                ipv6ArrayBuilder.add(ipv6);
            }
            json.add("ipv6", (JsonValue)ipv6ArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.mtu")) {
            json.add("mtu", this.getMTU());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.bytesRecv")) {
            json.add("bytesRecv", this.getBytesRecv());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.bytesSent")) {
            json.add("bytesSent", this.getBytesSent());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.packetsRecv")) {
            json.add("packetsRecv", this.getPacketsRecv());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.packetsSent")) {
            json.add("packetsSent", this.getPacketsSent());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.inErrors")) {
            json.add("inErrors", this.getInErrors());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.outErrors")) {
            json.add("outErrors", this.getOutErrors());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.speed")) {
            json.add("speed", this.getSpeed());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks.timeStamp")) {
            json.add("timeStamp", this.getSpeed());
        }
        return json.build();
    }
}

