/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.windows.WindowsBaseboard;
import oshi.hardware.platform.windows.WindowsFirmware;
import oshi.util.platform.windows.WmiUtil;

final class WindowsComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;
    private static final WmiUtil.WmiQuery<CsProductProperty> IDENTIFYINGNUMBER_QUERY = WmiUtil.createQuery("Win32_Csproduct", CsProductProperty.class);
    private String systemSerialNumber = "";

    WindowsComputerSystem() {
        this.init();
    }

    private void init() {
        WmiUtil.WmiQuery<ComputerSystemProperty> computerSystemQuery = WmiUtil.createQuery("Win32_ComputerSystem", ComputerSystemProperty.class);
        WmiUtil.WmiResult<ComputerSystemProperty> win32ComputerSystem = WmiUtil.queryWMI(computerSystemQuery);
        if (win32ComputerSystem.getResultCount() > 0) {
            this.setManufacturer((String)win32ComputerSystem.get(ComputerSystemProperty.MANUFACTURER).get(0));
            this.setModel((String)win32ComputerSystem.get(ComputerSystemProperty.MODEL).get(0));
        }
        this.setSerialNumber(this.getSystemSerialNumber());
        this.setFirmware(new WindowsFirmware());
        this.setBaseboard(new WindowsBaseboard());
    }

    private String getSystemSerialNumber() {
        WmiUtil.WmiResult<CsProductProperty> identifyingNumber;
        if (!"".equals(this.systemSerialNumber)) {
            return this.systemSerialNumber;
        }
        WmiUtil.WmiQuery<BiosProperty> serialNumberQuery = WmiUtil.createQuery("Win32_BIOS where PrimaryBIOS=true", BiosProperty.class);
        WmiUtil.WmiResult<BiosProperty> serialNumber = WmiUtil.queryWMI(serialNumberQuery);
        if (serialNumber.getResultCount() > 0) {
            this.systemSerialNumber = (String)serialNumber.get(BiosProperty.SERIALNUMBER).get(0);
        }
        if (!"".equals(this.systemSerialNumber) && (identifyingNumber = WmiUtil.queryWMI(IDENTIFYINGNUMBER_QUERY)).getResultCount() > 0) {
            this.systemSerialNumber = (String)identifyingNumber.get(CsProductProperty.IDENTIFYINGNUMBER).get(0);
        }
        if (!"".equals(this.systemSerialNumber)) {
            this.systemSerialNumber = "unknown";
        }
        return this.systemSerialNumber;
    }

    static enum CsProductProperty implements WmiUtil.WmiProperty
    {
        IDENTIFYINGNUMBER(WmiUtil.ValueType.STRING);

        private WmiUtil.ValueType type;

        private CsProductProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }

    static enum BiosProperty implements WmiUtil.WmiProperty
    {
        SERIALNUMBER(WmiUtil.ValueType.STRING);

        private WmiUtil.ValueType type;

        private BiosProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }

    static enum ComputerSystemProperty implements WmiUtil.WmiProperty
    {
        MANUFACTURER(WmiUtil.ValueType.STRING),
        MODEL(WmiUtil.ValueType.STRING);

        private WmiUtil.ValueType type;

        private ComputerSystemProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }
}

