/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.hardware.impl;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import oshi.json.hardware.CentralProcessor;
import oshi.json.hardware.ComputerSystem;
import oshi.json.hardware.Display;
import oshi.json.hardware.GlobalMemory;
import oshi.json.hardware.HWDiskStore;
import oshi.json.hardware.HWPartition;
import oshi.json.hardware.HardwareAbstractionLayer;
import oshi.json.hardware.NetworkIF;
import oshi.json.hardware.PowerSource;
import oshi.json.hardware.Sensors;
import oshi.json.hardware.UsbDevice;
import oshi.json.hardware.impl.CentralProcessorImpl;
import oshi.json.hardware.impl.ComputerSystemImpl;
import oshi.json.hardware.impl.DisplayImpl;
import oshi.json.hardware.impl.GlobalMemoryImpl;
import oshi.json.hardware.impl.PowerSourceImpl;
import oshi.json.hardware.impl.SensorsImpl;
import oshi.json.hardware.impl.UsbDeviceImpl;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.json.OshiJsonObject;
import oshi.json.util.PropertiesUtil;

public class HardwareAbstractionLayerImpl
extends AbstractOshiJsonObject
implements HardwareAbstractionLayer {
    private static final long serialVersionUID = 1L;
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.hardware.HardwareAbstractionLayer hal;
    private ComputerSystem computerSystem;
    private CentralProcessor processor;
    private GlobalMemory memory;
    private Sensors sensors;

    public HardwareAbstractionLayerImpl(oshi.hardware.HardwareAbstractionLayer hardware) {
        this.hal = hardware;
    }

    @Override
    public ComputerSystem getComputerSystem() {
        if (this.computerSystem == null) {
            this.computerSystem = new ComputerSystemImpl(this.hal.getComputerSystem());
        }
        return this.computerSystem;
    }

    @Override
    public CentralProcessor getProcessor() {
        if (this.processor == null) {
            this.processor = new CentralProcessorImpl(this.hal.getProcessor());
        }
        return this.processor;
    }

    @Override
    public GlobalMemory getMemory() {
        if (this.memory == null) {
            this.memory = new GlobalMemoryImpl(this.hal.getMemory());
        }
        return this.memory;
    }

    @Override
    public PowerSource[] getPowerSources() {
        oshi.hardware.PowerSource[] ps = this.hal.getPowerSources();
        PowerSource[] powerSources = new PowerSource[ps.length];
        for (int i = 0; i < ps.length; ++i) {
            powerSources[i] = new PowerSourceImpl(ps[i]);
        }
        return powerSources;
    }

    @Override
    public HWDiskStore[] getDiskStores() {
        oshi.hardware.HWDiskStore[] ds = this.hal.getDiskStores();
        HWDiskStore[] diskStores = new HWDiskStore[ds.length];
        for (int i = 0; i < ds.length; ++i) {
            HWPartition[] partitions = new HWPartition[ds[i].getPartitions().length];
            for (int j = 0; j < partitions.length; ++j) {
                partitions[j] = new HWPartition(ds[i].getPartitions()[j].getIdentification(), ds[i].getPartitions()[j].getName(), ds[i].getPartitions()[j].getType(), ds[i].getPartitions()[j].getUuid(), ds[i].getPartitions()[j].getSize(), ds[i].getPartitions()[j].getMajor(), ds[i].getPartitions()[j].getMinor(), ds[i].getPartitions()[j].getMountPoint());
            }
            diskStores[i] = new HWDiskStore(ds[i].getName(), ds[i].getModel(), ds[i].getSerial(), ds[i].getSize(), ds[i].getReads(), ds[i].getReadBytes(), ds[i].getWrites(), ds[i].getWriteBytes(), ds[i].getTransferTime(), partitions, ds[i].getTimeStamp());
        }
        return diskStores;
    }

    @Override
    public NetworkIF[] getNetworkIFs() {
        oshi.hardware.NetworkIF[] ifs = this.hal.getNetworkIFs();
        NetworkIF[] networkIFs = new NetworkIF[ifs.length];
        for (int i = 0; i < ifs.length; ++i) {
            networkIFs[i] = new NetworkIF();
            networkIFs[i].setNetworkInterface(ifs[i].getNetworkInterface());
            networkIFs[i].setBytesRecv(ifs[i].getBytesRecv());
            networkIFs[i].setBytesSent(ifs[i].getBytesSent());
            networkIFs[i].setPacketsRecv(ifs[i].getPacketsRecv());
            networkIFs[i].setPacketsSent(ifs[i].getPacketsSent());
            networkIFs[i].setSpeed(ifs[i].getSpeed());
            networkIFs[i].setTimeStamp(ifs[i].getTimeStamp());
        }
        return networkIFs;
    }

    @Override
    public Display[] getDisplays() {
        oshi.hardware.Display[] ds = this.hal.getDisplays();
        Display[] displays = new Display[ds.length];
        for (int i = 0; i < ds.length; ++i) {
            displays[i] = new DisplayImpl(ds[i]);
        }
        return displays;
    }

    @Override
    public Sensors getSensors() {
        if (this.sensors == null) {
            this.sensors = new SensorsImpl(this.hal.getSensors());
        }
        return this.sensors;
    }

    @Override
    public UsbDevice[] getUsbDevices(boolean tree) {
        oshi.hardware.UsbDevice[] usbs = this.hal.getUsbDevices(tree);
        UsbDevice[] usbDevices = new UsbDevice[usbs.length];
        for (int i = 0; i < usbs.length; ++i) {
            usbDevices[i] = new UsbDeviceImpl(usbs[i]);
        }
        return usbDevices;
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem")) {
            json.add("computerSystem", (JsonValue)this.getComputerSystem().toJSON(properties));
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor")) {
            json.add("processor", (JsonValue)this.getProcessor().toJSON(properties));
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.memory")) {
            json.add("memory", (JsonValue)this.getMemory().toJSON(properties));
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.powerSources")) {
            JsonArrayBuilder powerSourceArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (OshiJsonObject oshiJsonObject : this.getPowerSources()) {
                powerSourceArrayBuilder.add((JsonValue)oshiJsonObject.toJSON(properties));
            }
            json.add("powerSources", (JsonValue)powerSourceArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks")) {
            JsonArrayBuilder diskStoreArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (OshiJsonObject oshiJsonObject : this.getDiskStores()) {
                diskStoreArrayBuilder.add((JsonValue)((HWDiskStore)oshiJsonObject).toJSON(properties));
            }
            json.add("disks", (JsonValue)diskStoreArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.networks")) {
            JsonArrayBuilder networkIFArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (OshiJsonObject oshiJsonObject : this.getNetworkIFs()) {
                networkIFArrayBuilder.add((JsonValue)((NetworkIF)oshiJsonObject).toJSON(properties));
            }
            json.add("networks", (JsonValue)networkIFArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.displays")) {
            JsonArrayBuilder displayArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (OshiJsonObject oshiJsonObject : this.getDisplays()) {
                displayArrayBuilder.add((JsonValue)oshiJsonObject.toJSON(properties));
            }
            json.add("displays", (JsonValue)displayArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.sensors")) {
            json.add("sensors", (JsonValue)this.getSensors().toJSON(properties));
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.usbDevices")) {
            JsonArrayBuilder usbDeviceArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (OshiJsonObject oshiJsonObject : this.getUsbDevices(PropertiesUtil.getBoolean(properties, "hardware.usbDevices.tree"))) {
                usbDeviceArrayBuilder.add((JsonValue)oshiJsonObject.toJSON(properties));
            }
            json.add("usbDevices", (JsonValue)usbDeviceArrayBuilder.build());
        }
        return json.build();
    }
}

