/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.hardware.impl;

import java.time.LocalDate;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import oshi.json.hardware.Firmware;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.util.PropertiesUtil;
import oshi.util.FormatUtil;

public class FirmwareImpl
extends AbstractOshiJsonObject
implements Firmware {
    private static final long serialVersionUID = 1L;
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.hardware.Firmware firmware;

    public FirmwareImpl(oshi.hardware.Firmware firmware) {
        this.firmware = firmware;
    }

    @Override
    public String getManufacturer() {
        return this.firmware.getManufacturer();
    }

    @Override
    public String getName() {
        return this.firmware.getName();
    }

    @Override
    public String getDescription() {
        return this.firmware.getDescription();
    }

    @Override
    public String getVersion() {
        return this.firmware.getVersion();
    }

    @Override
    public LocalDate getReleaseDate() {
        return this.firmware.getReleaseDate();
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.firmware.manufacturer")) {
            json.add("manufacturer", this.getManufacturer());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.firmware.name")) {
            json.add("name", this.getName());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.firmware.description")) {
            json.add("description", this.getDescription());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.firmware.version")) {
            json.add("version", this.getVersion());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.firmware.releaseDate")) {
            json.add("releaseDate", this.getReleaseDate() == null ? "unknown" : FormatUtil.formatDate((LocalDate)this.getReleaseDate()));
        }
        return json.build();
    }

    @Override
    public String toString() {
        return this.firmware.toString();
    }
}

