/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.windows.WindowsBaseboard;
import oshi.hardware.platform.windows.WindowsFirmware;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

final class WindowsComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;
    private final transient WbemcliUtil.WmiQuery<ComputerSystemProductProperty> identifyingNumberQuery = new WbemcliUtil.WmiQuery("Win32_ComputerSystemProduct", ComputerSystemProductProperty.class);
    private final transient WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();
    private String systemSerialNumber = "";

    WindowsComputerSystem() {
        this.init();
    }

    private void init() {
        WbemcliUtil.WmiQuery computerSystemQuery = new WbemcliUtil.WmiQuery("Win32_ComputerSystem", ComputerSystemProperty.class);
        WbemcliUtil.WmiResult win32ComputerSystem = this.wmiQueryHandler.queryWMI(computerSystemQuery);
        if (win32ComputerSystem.getResultCount() > 0) {
            this.setManufacturer(WmiUtil.getString(win32ComputerSystem, ComputerSystemProperty.MANUFACTURER, 0));
            this.setModel(WmiUtil.getString(win32ComputerSystem, ComputerSystemProperty.MODEL, 0));
        }
        this.setSerialNumber(this.getSystemSerialNumber());
        this.setFirmware(new WindowsFirmware());
        this.setBaseboard(new WindowsBaseboard());
    }

    private String getSystemSerialNumber() {
        WbemcliUtil.WmiResult<ComputerSystemProductProperty> identifyingNumber;
        if (!"".equals(this.systemSerialNumber)) {
            return this.systemSerialNumber;
        }
        WbemcliUtil.WmiQuery serialNumberQuery = new WbemcliUtil.WmiQuery("Win32_BIOS where PrimaryBIOS=true", BiosProperty.class);
        WbemcliUtil.WmiResult serialNumber = this.wmiQueryHandler.queryWMI(serialNumberQuery);
        if (serialNumber.getResultCount() > 0) {
            this.systemSerialNumber = WmiUtil.getString(serialNumber, BiosProperty.SERIALNUMBER, 0);
        }
        if ("".equals(this.systemSerialNumber) && (identifyingNumber = this.wmiQueryHandler.queryWMI(this.identifyingNumberQuery)).getResultCount() > 0) {
            this.systemSerialNumber = WmiUtil.getString(identifyingNumber, ComputerSystemProductProperty.IDENTIFYINGNUMBER, 0);
        }
        if ("".equals(this.systemSerialNumber)) {
            this.systemSerialNumber = "unknown";
        }
        return this.systemSerialNumber;
    }

    static enum ComputerSystemProductProperty {
        IDENTIFYINGNUMBER;

    }

    static enum ComputerSystemProperty {
        MANUFACTURER,
        MODEL;

    }

    static enum BiosProperty {
        SERIALNUMBER;

    }
}

