/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Pdh;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.util.Util;

public class PerfDataUtil {
    public static final PerfDataUtil INSTANCE = new PerfDataUtil();
    private static final Logger LOG = LoggerFactory.getLogger(PerfDataUtil.class);
    private static final BaseTSD.DWORD_PTR PZERO = new BaseTSD.DWORD_PTR(0L);
    private static final WinDef.DWORDByReference PDH_FMT_RAW = new WinDef.DWORDByReference(new WinDef.DWORD(16L));
    private static final Pdh PDH = Pdh.INSTANCE;
    private static final String HEX_ERROR_FMT = "0x%08X";
    private static final String LOG_COUNTER_NOT_EXISTS = "Counter does not exist: {}";
    private static final String LOG_COUNTER_RECREATE = "Removing and re-adding counter: {}";
    private static final String LOG_COUNTER_QUERY = "Querying counter: {}";
    private static final long EPOCH_DIFF = 11644473600000L;
    private static final int TZ_OFFSET = TimeZone.getDefault().getOffset(System.currentTimeMillis());
    private static final Map<PerfCounter, WinNT.HANDLEByReference> counterMap = new HashMap<PerfCounter, WinNT.HANDLEByReference>();
    private static final Map<String, WinNT.HANDLEByReference> queryMap = new HashMap<String, WinNT.HANDLEByReference>();
    private static final Set<String> disabledQueries = new HashSet<String>();

    private PerfDataUtil() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                PerfDataUtil.removeAllCounters();
            }
        });
    }

    public static PerfCounter createCounter(String object, String instance, String counter) {
        PerfDataUtil perfDataUtil = INSTANCE;
        perfDataUtil.getClass();
        return perfDataUtil.new PerfCounter(object, instance, counter);
    }

    public static boolean addCounterToQuery(PerfCounter counter) {
        WinNT.HANDLEByReference q = PerfDataUtil.openQuery(counter.object);
        if (q == null) {
            LOG.error("Failed to open a query for PDH object: {}", (Object)counter.object);
            return false;
        }
        WinNT.HANDLEByReference p = new WinNT.HANDLEByReference();
        String path = PerfDataUtil.counterPath(counter);
        if (PerfDataUtil.addCounter(q, path, p)) {
            counterMap.put(counter, p);
            return true;
        }
        return false;
    }

    public static boolean removeCounterFromQuery(PerfCounter counter) {
        if (counterMap.containsKey(counter)) {
            return 0 == PDH.PdhRemoveCounter(counterMap.get(counter).getValue());
        }
        return false;
    }

    public static long updateQuery(PerfCounter counter) {
        if (disabledQueries.contains(counter.object)) {
            return 0L;
        }
        if (!queryMap.containsKey(counter.object) || !counterMap.containsKey(counter)) {
            if (LOG.isErrorEnabled()) {
                LOG.error(LOG_COUNTER_NOT_EXISTS, (Object)PerfDataUtil.counterPath(counter));
            }
            return 0L;
        }
        long timestamp = PerfDataUtil.updateQueryTimestamp(queryMap.get(counter.object));
        if (timestamp == 0L) {
            LOG.error("Disabling future updates for {}.", (Object)counter.object);
            disabledQueries.add(counter.object);
            return 0L;
        }
        return timestamp;
    }

    public static long updateQuery(String queryKey) {
        if (disabledQueries.contains(queryKey) || !queryMap.containsKey(queryKey)) {
            return 0L;
        }
        return PerfDataUtil.updateQueryTimestamp(queryMap.get(queryKey));
    }

    public static long queryCounter(PerfCounter counter) {
        long value;
        if (!queryMap.containsKey(counter.object) || !counterMap.containsKey(counter)) {
            if (LOG.isErrorEnabled()) {
                LOG.error(LOG_COUNTER_NOT_EXISTS, (Object)PerfDataUtil.counterPath(counter));
            }
            return 0L;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(LOG_COUNTER_QUERY, (Object)PerfDataUtil.counterPath(counter));
        }
        if ((value = PerfDataUtil.queryCounter(counterMap.get(counter))) == -1073738820L) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(LOG_COUNTER_RECREATE, (Object)PerfDataUtil.counterPath(counter));
            }
            PerfDataUtil.removeCounterFromQuery(counter);
            PerfDataUtil.addCounterToQuery(counter);
        }
        return value < 0L ? 0L : value;
    }

    public static void removeAllCounters(String queryKey) {
        Iterator<Map.Entry<PerfCounter, WinNT.HANDLEByReference>> it = counterMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<PerfCounter, WinNT.HANDLEByReference> entry = it.next();
            if (!entry.getKey().object.equals(queryKey)) continue;
            PDH.PdhRemoveCounter(entry.getValue().getValue());
            it.remove();
        }
        WinNT.HANDLEByReference query = queryMap.get(queryKey);
        if (query != null) {
            PDH.PdhCloseQuery(query.getValue());
        }
        queryMap.remove(queryKey);
        disabledQueries.remove(queryKey);
    }

    private static WinNT.HANDLEByReference openQuery(String objectName) {
        if (queryMap.containsKey(objectName)) {
            return queryMap.get(objectName);
        }
        WinNT.HANDLEByReference q = new WinNT.HANDLEByReference();
        if (PerfDataUtil.openQuery(q)) {
            queryMap.put(objectName, q);
            return q;
        }
        return null;
    }

    private static String counterPath(PerfCounter counter) {
        StringBuilder sb = new StringBuilder();
        sb.append('\\').append(counter.object);
        if (counter.instance != null) {
            sb.append('(').append(counter.instance).append(')');
        }
        sb.append('\\').append(counter.counter);
        return sb.toString();
    }

    public static void removeAllCounters() {
        HashSet<String> queries = new HashSet<String>(queryMap.keySet());
        for (String query : queries) {
            PerfDataUtil.removeAllCounters(query);
        }
    }

    private static boolean openQuery(WinNT.HANDLEByReference q) {
        int pdhOpenQueryError = PDH.PdhOpenQuery(null, PZERO, q);
        if (pdhOpenQueryError != 0 && LOG.isErrorEnabled()) {
            LOG.error("Failed to open PDH Query. Error code: {}", (Object)String.format(HEX_ERROR_FMT, pdhOpenQueryError));
        }
        return pdhOpenQueryError == 0;
    }

    private static boolean addCounter(WinNT.HANDLEByReference query, String path, WinNT.HANDLEByReference p) {
        int pdhAddCounterError = PDH.PdhAddEnglishCounter(query.getValue(), path, PZERO, p);
        if (pdhAddCounterError != 0 && LOG.isWarnEnabled()) {
            LOG.warn("Failed to add PDH Counter: {}, Error code: {}", (Object)path, (Object)String.format(HEX_ERROR_FMT, pdhAddCounterError));
        }
        return pdhAddCounterError == 0;
    }

    private static long queryCounter(WinNT.HANDLEByReference counter) {
        Pdh.PDH_RAW_COUNTER counterValue = new Pdh.PDH_RAW_COUNTER();
        int ret = PDH.PdhGetRawCounterValue(counter.getValue(), PDH_FMT_RAW, counterValue);
        if (ret != 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Failed to get counter. Error code: {}", (Object)String.format(HEX_ERROR_FMT, ret));
            }
            return ret;
        }
        return counterValue.FirstValue;
    }

    private static long updateQueryTimestamp(WinNT.HANDLEByReference query) {
        WinDef.LONGLONGByReference pllTimeStamp = new WinDef.LONGLONGByReference();
        int ret = PDH.PdhCollectQueryDataWithTime(query.getValue(), pllTimeStamp);
        int retries = 0;
        while (ret == -2147481643 && retries++ < 3) {
            Util.sleep(1 << retries);
            ret = PDH.PdhCollectQueryDataWithTime(query.getValue(), pllTimeStamp);
        }
        if (ret != 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Failed to update counter. Error code: {}", (Object)String.format(HEX_ERROR_FMT, ret));
            }
            return 0L;
        }
        return PerfDataUtil.filetimeToUtcMs(pllTimeStamp.getValue().longValue(), true);
    }

    public static long filetimeToUtcMs(long filetime, boolean local) {
        return filetime / 10000L - 11644473600000L - (local ? (long)TZ_OFFSET : 0L);
    }

    public class PerfCounter {
        private String object;
        private String instance;
        private String counter;

        public PerfCounter(String objectName, String instanceName, String counterName) {
            this.object = objectName;
            this.instance = instanceName;
            this.counter = counterName;
        }
    }
}

