/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsGlobalMemory.class);
    private transient Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
    private long lastUpdate = 0L;
    private transient PerfDataUtil.PerfCounter pagesInputPerSecCounter = null;
    private transient PerfDataUtil.PerfCounter pagesOutputPerSecCounter = null;
    private transient WbemcliUtil.WmiQuery<PageSwapProperty> pageSwapsQuery = null;
    private transient PerfDataUtil.PerfCounter pagingPercentUsageCounter = null;
    private transient WbemcliUtil.WmiQuery<PagingPercentProperty> pagingPercentQuery = null;

    public WindowsGlobalMemory() {
        this.initPdhCounters();
    }

    private void initPdhCounters() {
        this.pagesInputPerSecCounter = PerfDataUtil.createCounter("Memory", null, "Pages Input/sec");
        this.pagesOutputPerSecCounter = PerfDataUtil.createCounter("Memory", null, "Pages Output/sec");
        if (!PerfDataUtil.addCounterToQuery(this.pagesInputPerSecCounter) || !PerfDataUtil.addCounterToQuery(this.pagesOutputPerSecCounter)) {
            this.pagesInputPerSecCounter = null;
            this.pagesOutputPerSecCounter = null;
            this.pageSwapsQuery = new WbemcliUtil.WmiQuery("Win32_PerfRawData_PerfOS_Memory", PageSwapProperty.class);
        }
        this.pagingPercentUsageCounter = PerfDataUtil.createCounter("Paging File", "_Total", "% Usage");
        if (!PerfDataUtil.addCounterToQuery(this.pagingPercentUsageCounter)) {
            this.pagingPercentUsageCounter = null;
            this.pagingPercentQuery = new WbemcliUtil.WmiQuery("Win32_PerfRawData_PerfOS_PagingFile", PagingPercentProperty.class);
        }
    }

    @Override
    protected void updateMeminfo() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate > 100L) {
            if (!Psapi.INSTANCE.GetPerformanceInfo(this.perfInfo, this.perfInfo.size())) {
                LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
                return;
            }
            this.pageSize = this.perfInfo.PageSize.longValue();
            this.memAvailable = this.pageSize * this.perfInfo.PhysicalAvailable.longValue();
            this.memTotal = this.pageSize * this.perfInfo.PhysicalTotal.longValue();
            this.swapTotal = this.pageSize * (this.perfInfo.CommitLimit.longValue() - this.perfInfo.PhysicalTotal.longValue());
            if (this.swapTotal > 0L) {
                if (this.pageSwapsQuery == null) {
                    PerfDataUtil.updateQuery(this.pagesInputPerSecCounter);
                    this.swapPagesIn = PerfDataUtil.queryCounter(this.pagesInputPerSecCounter);
                    this.swapPagesOut = PerfDataUtil.queryCounter(this.pagesOutputPerSecCounter);
                } else {
                    WbemcliUtil.WmiResult<PageSwapProperty> result = WmiUtil.queryWMI(this.pageSwapsQuery);
                    if (result.getResultCount() > 0) {
                        this.swapPagesIn = WmiUtil.getUint32(result, PageSwapProperty.PAGESINPUTPERSEC, 0);
                        this.swapPagesOut = WmiUtil.getUint32(result, PageSwapProperty.PAGESOUTPUTPERSEC, 0);
                    }
                }
            }
            this.lastUpdate = now;
        }
    }

    @Override
    protected void updateSwap() {
        this.updateMeminfo();
        if (this.swapTotal > 0L) {
            if (this.pagingPercentQuery == null) {
                PerfDataUtil.updateQuery(this.pagingPercentUsageCounter);
                this.swapUsed = PerfDataUtil.queryCounter(this.pagingPercentUsageCounter) * this.pageSize;
            } else {
                WbemcliUtil.WmiResult<PagingPercentProperty> result = WmiUtil.queryWMI(this.pagingPercentQuery);
                if (result.getResultCount() > 0) {
                    this.swapUsed = (long)WmiUtil.getUint32(result, PagingPercentProperty.PERCENTUSAGE, 0) * this.pageSize;
                }
            }
        }
    }

    static enum PagingPercentProperty {
        PERCENTUSAGE;

    }

    static enum PageSwapProperty {
        PAGESINPUTPERSEC,
        PAGESOUTPUTPERSEC;

    }
}

