/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import oshi.SystemInfo;
import oshi.demo.gui.OshiJPanel;
import oshi.hardware.GlobalMemory;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;

public class MemoryPanel
extends OshiJPanel {
    private static final long serialVersionUID = 1L;
    private static final String PHYSICAL_MEMORY = "Physical Memory";
    private static final String VIRTUAL_MEMORY = "Virtual Memory (Swap)";
    private static final String USED = "Used";
    private static final String AVAILABLE = "Available";
    private static final DecimalFormatSymbols ROOT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.ROOT);

    public MemoryPanel(SystemInfo si) {
        this.init(si.getHardware().getMemory());
    }

    private void init(GlobalMemory memory) {
        DefaultPieDataset physMemData = new DefaultPieDataset();
        DefaultPieDataset virtMemData = new DefaultPieDataset();
        MemoryPanel.updateDatasets(memory, (DefaultPieDataset<String>)physMemData, (DefaultPieDataset<String>)virtMemData);
        JFreeChart physMem = ChartFactory.createPieChart((String)PHYSICAL_MEMORY, (PieDataset)physMemData, (boolean)true, (boolean)true, (boolean)false);
        JFreeChart virtMem = ChartFactory.createPieChart((String)VIRTUAL_MEMORY, (PieDataset)virtMemData, (boolean)true, (boolean)true, (boolean)false);
        MemoryPanel.configurePlot(physMem);
        MemoryPanel.configurePlot(virtMem);
        physMem.setSubtitles(Collections.singletonList(new TextTitle(MemoryPanel.updatePhysTitle(memory))));
        virtMem.setSubtitles(Collections.singletonList(new TextTitle(MemoryPanel.updateVirtTitle(memory))));
        GridBagConstraints pmConstraints = new GridBagConstraints();
        pmConstraints.weightx = 1.0;
        pmConstraints.weighty = 1.0;
        pmConstraints.fill = 1;
        GridBagConstraints vmConstraints = (GridBagConstraints)pmConstraints.clone();
        vmConstraints.gridx = 1;
        GridBagConstraints textConstraints = new GridBagConstraints();
        textConstraints.gridy = 1;
        textConstraints.gridwidth = 2;
        textConstraints.fill = 1;
        JPanel memoryPanel = new JPanel();
        memoryPanel.setLayout(new GridBagLayout());
        memoryPanel.add((Component)new ChartPanel(physMem), pmConstraints);
        memoryPanel.add((Component)new ChartPanel(virtMem), vmConstraints);
        JTextArea textArea = new JTextArea(60, 20);
        textArea.setText(MemoryPanel.updateMemoryText(memory));
        memoryPanel.add((Component)textArea, textConstraints);
        this.add((Component)memoryPanel, "Center");
        Timer timer = new Timer(5000, e -> {
            MemoryPanel.updateDatasets(memory, (DefaultPieDataset<String>)physMemData, (DefaultPieDataset<String>)virtMemData);
            physMem.setSubtitles(Collections.singletonList(new TextTitle(MemoryPanel.updatePhysTitle(memory))));
            virtMem.setSubtitles(Collections.singletonList(new TextTitle(MemoryPanel.updateVirtTitle(memory))));
            textArea.setText(MemoryPanel.updateMemoryText(memory));
        });
        timer.start();
    }

    private static String updatePhysTitle(GlobalMemory memory) {
        return memory.toString();
    }

    private static String updateVirtTitle(GlobalMemory memory) {
        return memory.getVirtualMemory().toString();
    }

    private static String updateMemoryText(GlobalMemory memory) {
        StringBuilder sb = new StringBuilder();
        List<PhysicalMemory> pmList = memory.getPhysicalMemory();
        for (PhysicalMemory pm : pmList) {
            sb.append('\n').append(pm.toString());
        }
        return sb.toString();
    }

    private static void updateDatasets(GlobalMemory memory, DefaultPieDataset<String> physMemData, DefaultPieDataset<String> virtMemData) {
        physMemData.setValue((Comparable)((Object)USED), (double)memory.getTotal() - (double)memory.getAvailable());
        physMemData.setValue((Comparable)((Object)AVAILABLE), (double)memory.getAvailable());
        VirtualMemory virtualMemory = memory.getVirtualMemory();
        virtMemData.setValue((Comparable)((Object)USED), (double)virtualMemory.getSwapUsed());
        virtMemData.setValue((Comparable)((Object)AVAILABLE), (double)virtualMemory.getSwapTotal() - (double)virtualMemory.getSwapUsed());
    }

    private static void configurePlot(JFreeChart chart) {
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setSectionPaint((Comparable)((Object)USED), (Paint)Color.red);
        plot.setSectionPaint((Comparable)((Object)AVAILABLE), (Paint)Color.green);
        plot.setExplodePercent((Comparable)((Object)USED), 0.1);
        plot.setSimpleLabels(true);
        StandardPieSectionLabelGenerator labelGenerator = new StandardPieSectionLabelGenerator("{0}: {1} ({2})", (NumberFormat)new DecimalFormat("0", ROOT_SYMBOLS), (NumberFormat)new DecimalFormat("0%", ROOT_SYMBOLS));
        plot.setLabelGenerator((PieSectionLabelGenerator)labelGenerator);
    }
}

