/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo;

import java.awt.BorderLayout;
import java.awt.Container;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import oshi.SystemInfo;
import oshi.demo.gui.FileStorePanel;
import oshi.demo.gui.InterfacePanel;
import oshi.demo.gui.MemoryPanel;
import oshi.demo.gui.OsHwTextPanel;
import oshi.demo.gui.OshiJPanel;
import oshi.demo.gui.ProcessPanel;
import oshi.demo.gui.ProcessorPanel;
import oshi.demo.gui.UsbPanel;

public class OshiGui {
    private JFrame mainFrame;
    private JButton jMenu;
    private SystemInfo si = new SystemInfo();

    public static void main(String[] args) {
        OshiGui gui = new OshiGui();
        gui.init();
        SwingUtilities.invokeLater(gui::setVisible);
    }

    private void setVisible() {
        this.mainFrame.setVisible(true);
        this.mainFrame.setDefaultCloseOperation(3);
        this.jMenu.doClick();
    }

    private void init() {
        this.mainFrame = new JFrame("Operating System & Hardware Information");
        this.mainFrame.setSize(800, 500);
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setResizable(true);
        this.mainFrame.setLocationByPlatform(true);
        this.mainFrame.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        this.mainFrame.setJMenuBar(menuBar);
        this.jMenu = this.getJMenu("OS & HW Info", 'O', "Hardware & OS Summary", new OsHwTextPanel(this.si));
        menuBar.add(this.jMenu);
        menuBar.add(this.getJMenu("Memory", 'M', "Memory Summary", new MemoryPanel(this.si)));
        menuBar.add(this.getJMenu("CPU", 'C', "CPU Usage", new ProcessorPanel(this.si)));
        menuBar.add(this.getJMenu("FileStores", 'F', "FileStore Usage", new FileStorePanel(this.si)));
        menuBar.add(this.getJMenu("Processes", 'P', "Processes", new ProcessPanel(this.si)));
        menuBar.add(this.getJMenu("USB Devices", 'U', "USB Device list", new UsbPanel(this.si)));
        menuBar.add(this.getJMenu("Network", 'N', "Network Params and Interfaces", new InterfacePanel(this.si)));
    }

    private JButton getJMenu(String title, char mnemonic, String toolTip, OshiJPanel panel) {
        JButton button = new JButton(title);
        button.setMnemonic(mnemonic);
        button.setToolTipText(toolTip);
        button.addActionListener(e -> {
            Container contentPane = this.mainFrame.getContentPane();
            if (contentPane.getComponents().length <= 0 || contentPane.getComponent(0) != panel) {
                this.resetMainGui();
                this.mainFrame.getContentPane().add(panel);
                this.refreshMainGui();
            }
        });
        return button;
    }

    private void resetMainGui() {
        this.mainFrame.getContentPane().removeAll();
    }

    private void refreshMainGui() {
        this.mainFrame.revalidate();
        this.mainFrame.repaint();
    }
}

