/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.FormatUtil;
import oshi.util.platform.windows.PerfDataUtil;

@ThreadSafe
public final class PerfCounterQueryHandler
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PerfCounterQueryHandler.class);
    private Map<PerfDataUtil.PerfCounter, WinNT.HANDLEByReference> counterHandleMap = new ConcurrentHashMap<PerfDataUtil.PerfCounter, WinNT.HANDLEByReference>();
    private Map<String, WinNT.HANDLEByReference> queryHandleMap = new ConcurrentHashMap<String, WinNT.HANDLEByReference>();
    private Map<String, List<PerfDataUtil.PerfCounter>> queryCounterMap = new ConcurrentHashMap<String, List<PerfDataUtil.PerfCounter>>();

    public boolean addCounterToQuery(PerfDataUtil.PerfCounter counter) {
        return this.addCounterToQuery(counter, counter.getObject());
    }

    public boolean addCounterToQuery(PerfDataUtil.PerfCounter counter, String key) {
        WinNT.HANDLEByReference q = this.getOrOpenQuery(key);
        if (q == null) {
            LOG.error("Failed to open a query for PDH object: {}", (Object)counter.getObject());
            return false;
        }
        WinNT.HANDLEByReference p = new WinNT.HANDLEByReference();
        if (PerfDataUtil.addCounter(q, counter.getCounterPath(), p)) {
            this.counterHandleMap.put(counter, p);
            List<PerfDataUtil.PerfCounter> counterList = this.queryCounterMap.get(key);
            if (counterList != null) {
                counterList.add(counter);
            }
            return true;
        }
        return false;
    }

    public boolean removeCounterFromQuery(PerfDataUtil.PerfCounter counter) {
        return this.removeCounterFromQuery(counter, counter.getObject());
    }

    public boolean removeCounterFromQuery(PerfDataUtil.PerfCounter counter, String key) {
        List<PerfDataUtil.PerfCounter> counterList;
        WinNT.HANDLEByReference href = this.counterHandleMap.remove(counter);
        boolean success = false;
        if (href != null) {
            success = PerfDataUtil.removeCounter(href);
        }
        if ((counterList = this.queryCounterMap.get(key)) != null && counterList.remove(counter) && counterList.isEmpty()) {
            this.queryCounterMap.remove(key);
            PerfDataUtil.closeQuery(this.queryHandleMap.remove(key));
        }
        return success;
    }

    public void removeAllCountersFromQuery(String queryKey) {
        List<PerfDataUtil.PerfCounter> counterList = this.queryCounterMap.remove(queryKey);
        if (counterList == null) {
            return;
        }
        for (PerfDataUtil.PerfCounter counter : counterList) {
            WinNT.HANDLEByReference href = this.counterHandleMap.remove(counter);
            if (href == null) continue;
            PerfDataUtil.removeCounter(href);
        }
        WinNT.HANDLEByReference href = this.queryHandleMap.remove(queryKey);
        if (href != null) {
            PerfDataUtil.closeQuery(href);
        }
    }

    public void removeAllCounters() {
        for (WinNT.HANDLEByReference href : this.counterHandleMap.values()) {
            PerfDataUtil.removeCounter(href);
        }
        this.counterHandleMap.clear();
        for (WinNT.HANDLEByReference query : this.queryHandleMap.values()) {
            PerfDataUtil.closeQuery(query);
        }
        this.queryHandleMap.clear();
        this.queryCounterMap.clear();
    }

    public long updateQuery(String key) {
        if (!this.queryHandleMap.containsKey(key)) {
            LOG.error("Query key {} does not exist to update.", (Object)key);
            return 0L;
        }
        return PerfDataUtil.updateQueryTimestamp(this.queryHandleMap.get(key));
    }

    public long queryCounter(PerfDataUtil.PerfCounter counter) {
        if (!this.counterHandleMap.containsKey(counter)) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Counter {} does not exist to query.", (Object)counter.getCounterPath());
            }
            return 0L;
        }
        long value = PerfDataUtil.queryCounter(this.counterHandleMap.get(counter));
        if (value < 0L) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Error querying counter {}: {}", (Object)counter.getCounterPath(), (Object)String.format(FormatUtil.formatError((int)value), new Object[0]));
            }
            return 0L;
        }
        return value;
    }

    private WinNT.HANDLEByReference getOrOpenQuery(String key) {
        if (this.queryHandleMap.containsKey(key)) {
            return this.queryHandleMap.get(key);
        }
        WinNT.HANDLEByReference q = new WinNT.HANDLEByReference();
        if (PerfDataUtil.openQuery(q)) {
            this.queryHandleMap.put(key, q);
            List counterList = Collections.synchronizedList(new ArrayList());
            this.queryCounterMap.put(key, counterList);
            return q;
        }
        return null;
    }

    @Override
    public void close() {
        this.removeAllCounters();
    }
}

