/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.IPHlpAPI;
import com.sun.jna.platform.win32.VersionHelpers;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.Networks;
import oshi.util.ParseUtil;

@ThreadSafe
public final class WindowsNetworks
extends Networks {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsNetworks.class);
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    private static final byte CONNECTOR_PRESENT_BIT = 32;

    public static boolean updateNetworkStats(NetworkIF netIF) {
        if (IS_VISTA_OR_GREATER) {
            IPHlpAPI.MIB_IF_ROW2 ifRow = new IPHlpAPI.MIB_IF_ROW2();
            ifRow.InterfaceIndex = netIF.queryNetworkInterface().getIndex();
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry2(ifRow)) {
                LOG.error("Failed to retrieve data for interface {}, {}", (Object)netIF.queryNetworkInterface().getIndex(), (Object)netIF.getName());
                return false;
            }
            netIF.setIfType(ifRow.Type);
            netIF.setNdisPhysicalMediumType(ifRow.PhysicalMediumType);
            netIF.setConnectorPresent((ifRow.InterfaceAndOperStatusFlags & 0x20) > 0);
            netIF.setBytesSent(ifRow.OutOctets);
            netIF.setBytesRecv(ifRow.InOctets);
            netIF.setPacketsSent(ifRow.OutUcastPkts);
            netIF.setPacketsRecv(ifRow.InUcastPkts);
            netIF.setOutErrors(ifRow.OutErrors);
            netIF.setInErrors(ifRow.InErrors);
            netIF.setCollisions(ifRow.OutDiscards);
            netIF.setInDrops(ifRow.InDiscards);
            netIF.setSpeed(ifRow.ReceiveLinkSpeed);
        } else {
            IPHlpAPI.MIB_IFROW ifRow = new IPHlpAPI.MIB_IFROW();
            ifRow.dwIndex = netIF.queryNetworkInterface().getIndex();
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry(ifRow)) {
                LOG.error("Failed to retrieve data for interface {}, {}", (Object)netIF.queryNetworkInterface().getIndex(), (Object)netIF.getName());
                return false;
            }
            netIF.setIfType(ifRow.dwType);
            netIF.setBytesSent(ParseUtil.unsignedIntToLong(ifRow.dwOutOctets));
            netIF.setBytesRecv(ParseUtil.unsignedIntToLong(ifRow.dwInOctets));
            netIF.setPacketsSent(ParseUtil.unsignedIntToLong(ifRow.dwOutUcastPkts));
            netIF.setPacketsRecv(ParseUtil.unsignedIntToLong(ifRow.dwInUcastPkts));
            netIF.setOutErrors(ParseUtil.unsignedIntToLong(ifRow.dwOutErrors));
            netIF.setInErrors(ParseUtil.unsignedIntToLong(ifRow.dwInErrors));
            netIF.setCollisions(ParseUtil.unsignedIntToLong(ifRow.dwOutDiscards));
            netIF.setInDrops(ParseUtil.unsignedIntToLong(ifRow.dwInDiscards));
            netIF.setSpeed(ParseUtil.unsignedIntToLong(ifRow.dwSpeed));
        }
        netIF.setTimeStamp(System.currentTimeMillis());
        return true;
    }
}

