/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.unix.solaris.SolarisBaseboard;
import oshi.hardware.platform.unix.solaris.SolarisFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;

@Immutable
final class SolarisComputerSystem
extends AbstractComputerSystem {
    private final Supplier<SmbiosStrings> smbiosStrings = Memoizer.memoize(SolarisComputerSystem::readSmbios);

    SolarisComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        return this.smbiosStrings.get().manufacturer;
    }

    @Override
    public String getModel() {
        return this.smbiosStrings.get().model;
    }

    @Override
    public String getSerialNumber() {
        return this.smbiosStrings.get().serialNumber;
    }

    @Override
    public Firmware createFirmware() {
        return new SolarisFirmware(this.smbiosStrings.get().biosVendor, this.smbiosStrings.get().biosVersion, this.smbiosStrings.get().biosDate);
    }

    @Override
    public Baseboard createBaseboard() {
        return new SolarisBaseboard(this.smbiosStrings.get().boardManufacturer, this.smbiosStrings.get().boardModel, this.smbiosStrings.get().boardSerialNumber, this.smbiosStrings.get().boardVersion);
    }

    private static SmbiosStrings readSmbios() {
        String biosVendor = null;
        String biosVersion = null;
        String biosDate = null;
        String manufacturer = null;
        String model = null;
        String serialNumber = null;
        String boardManufacturer = null;
        String boardModel = null;
        String boardVersion = null;
        String boardSerialNumber = null;
        String vendorMarker = "Vendor:";
        String biosDateMarker = "Release Date:";
        String biosVersionMarker = "VersionString:";
        String manufacturerMarker = "Manufacturer:";
        String productMarker = "Product:";
        String serialNumMarker = "Serial Number:";
        String versionMarker = "Version:";
        int smbTypeId = -1;
        for (String checkLine : ExecutingCommand.runNative("smbios")) {
            if (checkLine.contains("SMB_TYPE_") && (smbTypeId = SolarisComputerSystem.getSmbType(checkLine)) == Integer.MAX_VALUE) break;
            switch (smbTypeId) {
                case 0: {
                    if (checkLine.contains("Vendor:")) {
                        biosVendor = checkLine.split("Vendor:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("VersionString:")) {
                        biosVersion = checkLine.split("VersionString:")[1].trim();
                        break;
                    }
                    if (!checkLine.contains("Release Date:")) break;
                    biosDate = checkLine.split("Release Date:")[1].trim();
                    break;
                }
                case 1: {
                    if (checkLine.contains("Manufacturer:")) {
                        manufacturer = checkLine.split("Manufacturer:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("Product:")) {
                        model = checkLine.split("Product:")[1].trim();
                        break;
                    }
                    if (!checkLine.contains("Serial Number:")) break;
                    serialNumber = checkLine.split("Serial Number:")[1].trim();
                    break;
                }
                case 2: {
                    if (checkLine.contains("Manufacturer:")) {
                        boardManufacturer = checkLine.split("Manufacturer:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("Product:")) {
                        boardModel = checkLine.split("Product:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("Version:")) {
                        boardVersion = checkLine.split("Version:")[1].trim();
                        break;
                    }
                    if (!checkLine.contains("Serial Number:")) break;
                    boardSerialNumber = checkLine.split("Serial Number:")[1].trim();
                    break;
                }
            }
        }
        if (Util.isBlank(serialNumber)) {
            serialNumber = SolarisComputerSystem.readSerialNumber();
        }
        return new SmbiosStrings(biosVendor, biosVersion, biosDate, manufacturer, model, serialNumber, boardManufacturer, boardModel, boardVersion, boardSerialNumber);
    }

    private static int getSmbType(String checkLine) {
        if (checkLine.contains("SMB_TYPE_BIOS")) {
            return 0;
        }
        if (checkLine.contains("SMB_TYPE_SYSTEM")) {
            return 1;
        }
        if (checkLine.contains("SMB_TYPE_BASEBOARD")) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }

    private static String readSerialNumber() {
        String serialNumber = ExecutingCommand.getFirstAnswer("sneep");
        if (serialNumber.isEmpty()) {
            String marker = "chassis-sn:";
            for (String checkLine : ExecutingCommand.runNative("prtconf -pv")) {
                if (!checkLine.contains(marker)) continue;
                serialNumber = ParseUtil.getSingleQuoteStringValue(checkLine);
                break;
            }
        }
        return serialNumber;
    }

    private static final class SmbiosStrings {
        private final String biosVendor;
        private final String biosVersion;
        private final String biosDate;
        private final String manufacturer;
        private final String model;
        private final String serialNumber;
        private final String boardManufacturer;
        private final String boardModel;
        private final String boardVersion;
        private final String boardSerialNumber;

        private SmbiosStrings(String biosVendor, String biosVersion, String biosDate, String manufacturer, String model, String serialNumber, String boardManufacturer, String boardModel, String boardVersion, String boardSerialNumber) {
            this.biosVendor = Util.isBlank(biosVendor) ? "unknown" : biosVendor;
            this.biosVersion = Util.isBlank(biosVersion) ? "unknown" : biosVersion;
            this.biosDate = Util.isBlank(biosDate) ? "unknown" : biosDate;
            this.manufacturer = Util.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.model = Util.isBlank(model) ? "unknown" : model;
            this.serialNumber = Util.isBlank(serialNumber) ? "unknown" : serialNumber;
            this.boardManufacturer = Util.isBlank(boardManufacturer) ? "unknown" : boardManufacturer;
            this.boardModel = Util.isBlank(boardModel) ? "unknown" : boardModel;
            this.boardVersion = Util.isBlank(boardVersion) ? "unknown" : boardVersion;
            this.boardSerialNumber = Util.isBlank(boardSerialNumber) ? "unknown" : boardSerialNumber;
        }
    }
}

