/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oshi.SystemInfo;
import oshi.demo.gui.OshiJPanel;
import oshi.hardware.GlobalMemory;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;

public class ProcessPanel
extends OshiJPanel {
    private static final long serialVersionUID = 1L;
    private static final String PROCESSES = "Processes";
    private static final String[] COLUMNS = new String[]{"PID", "PPID", "% CPU", "Cumulative", "% Memory", "VSZ", "RSS", "Process Name"};
    private static final float[] COLUMN_WIDTH_PERCENT = new float[]{0.075f, 0.075f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.35f};
    private transient Map<Integer, OSProcess> priorSnapshotMap = new HashMap<Integer, OSProcess>();

    public ProcessPanel(SystemInfo si) {
        this.init(si);
    }

    private void init(SystemInfo si) {
        OperatingSystem os = si.getOperatingSystem();
        GlobalMemory mem = si.getHardware().getMemory();
        JLabel procLabel = new JLabel(PROCESSES);
        this.add((Component)procLabel, "North");
        DefaultTableModel model = new DefaultTableModel(this.parseProcesses(os.getProcesses(0, OperatingSystem.ProcessSort.CPU), mem), COLUMNS);
        JTable procTable = new JTable(model);
        JScrollPane scrollV = new JScrollPane(procTable);
        scrollV.setVerticalScrollBarPolicy(20);
        this.resizeColumns(procTable.getColumnModel());
        this.add((Component)scrollV, "Center");
        Timer timer = new Timer(5000, e -> {
            int row;
            DefaultTableModel tableModel = (DefaultTableModel)procTable.getModel();
            Object[][] newData = this.parseProcesses(os.getProcesses(0, OperatingSystem.ProcessSort.CPU), mem);
            int rowCount = tableModel.getRowCount();
            for (row = 0; row < newData.length; ++row) {
                if (row < rowCount) {
                    for (int col = 0; col < newData[row].length; ++col) {
                        tableModel.setValueAt(newData[row][col], row, col);
                    }
                    continue;
                }
                tableModel.addRow(newData[row]);
            }
            for (row = rowCount - 1; row >= newData.length; --row) {
                tableModel.removeRow(row);
            }
        });
        timer.start();
    }

    private Object[][] parseProcesses(OSProcess[] procs, GlobalMemory mem) {
        HashMap<OSProcess, Double> processCpuMap = new HashMap<OSProcess, Double>();
        for (OSProcess p : procs) {
            OSProcess oSProcess = this.priorSnapshotMap.get(p.getProcessID());
            processCpuMap.put(p, p.getProcessCpuLoadBetweenTicks(oSProcess));
        }
        ArrayList procList = new ArrayList(processCpuMap.entrySet());
        procList.sort(Map.Entry.comparingByValue());
        int i = procs.length;
        Object[][] procArr = new Object[procs.length][COLUMNS.length];
        this.priorSnapshotMap.clear();
        for (Map.Entry entry : procList) {
            OSProcess p = (OSProcess)entry.getKey();
            this.priorSnapshotMap.put(p.getProcessID(), p);
            procArr[--i][0] = p.getProcessID();
            procArr[i][1] = p.getParentProcessID();
            procArr[i][2] = String.format("%.1f", 100.0 * (Double)entry.getValue());
            procArr[i][3] = String.format("%.1f", 100.0 * p.getProcessCpuLoadCumulative());
            procArr[i][4] = String.format("%.1f", 100.0 * (double)p.getResidentSetSize() / (double)mem.getTotal());
            procArr[i][5] = FormatUtil.formatBytes(p.getVirtualSize());
            procArr[i][6] = FormatUtil.formatBytes(p.getResidentSetSize());
            procArr[i][7] = p.getName();
        }
        return procArr;
    }

    private void resizeColumns(TableColumnModel tableColumnModel) {
        int tW = tableColumnModel.getTotalColumnWidth();
        int cantCols = tableColumnModel.getColumnCount();
        for (int i = 0; i < cantCols; ++i) {
            TableColumn column = tableColumnModel.getColumn(i);
            int pWidth = Math.round(COLUMN_WIDTH_PERCENT[i] * (float)tW);
            column.setPreferredWidth(pWidth);
        }
    }
}

