/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.jna.platform.windows.PowrProf;
import oshi.util.FormatUtil;

public class WindowsPowerSource
extends AbstractPowerSource {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsPowerSource.class);

    public WindowsPowerSource(String newName, double newRemainingCapacity, double newTimeRemaining) {
        super(newName, newRemainingCapacity, newTimeRemaining);
        LOG.debug("Initialized WindowsPowerSource");
    }

    public static PowerSource[] getPowerSources() {
        PowerSource[] psArray = new WindowsPowerSource[]{WindowsPowerSource.getPowerSource("System Battery")};
        return psArray;
    }

    private static WindowsPowerSource getPowerSource(String name) {
        int size = new PowrProf.SystemBatteryState().size();
        Memory mem = new Memory((long)size);
        if (0 == PowrProf.INSTANCE.CallNtPowerInformation(5, null, 0, (Pointer)mem, size)) {
            PowrProf.SystemBatteryState batteryState = new PowrProf.SystemBatteryState((Pointer)mem);
            if (batteryState.batteryPresent > 0) {
                int estimatedTime = -2;
                if (batteryState.acOnLine == 0 && batteryState.charging == 0 && batteryState.discharging > 0) {
                    estimatedTime = batteryState.estimatedTime;
                }
                long maxCapacity = FormatUtil.getUnsignedInt(batteryState.maxCapacity);
                long remainingCapacity = FormatUtil.getUnsignedInt(batteryState.remainingCapacity);
                return new WindowsPowerSource(name, (double)remainingCapacity / (double)maxCapacity, estimatedTime);
            }
        }
        return new WindowsPowerSource("Unknown", 0.0, -1.0);
    }

    @Override
    public void updateAttributes() {
        WindowsPowerSource ps = WindowsPowerSource.getPowerSource(this.name);
        this.remainingCapacity = ps.getRemainingCapacity();
        this.timeRemaining = ps.getTimeRemaining();
    }
}

