/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.hardware.platform.windows.WindowsVirtualMemory;
import oshi.util.Memoizer;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

public class WindowsGlobalMemory
extends AbstractGlobalMemory {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsGlobalMemory.class);
    private final Supplier<PerfInfo> perfInfo = Memoizer.memoize(this::readPerfInfo, Memoizer.defaultExpiration());
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    @Override
    public long getAvailable() {
        return this.perfInfo.get().available;
    }

    @Override
    public long getTotal() {
        return this.perfInfo.get().total;
    }

    @Override
    public long getPageSize() {
        return this.perfInfo.get().pageSize;
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private VirtualMemory createVirtualMemory() {
        return new WindowsVirtualMemory(this.getPageSize());
    }

    @Override
    public PhysicalMemory[] getPhysicalMemory() {
        WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();
        WbemcliUtil.WmiQuery physicalMemoryQuery = new WbemcliUtil.WmiQuery("Win32_PhysicalMemory", PhysicalMemoryProperty.class);
        WbemcliUtil.WmiResult bankMap = wmiQueryHandler.queryWMI(physicalMemoryQuery);
        PhysicalMemory[] physicalMemoryArray = new PhysicalMemory[bankMap.getResultCount()];
        for (int index = 0; index < bankMap.getResultCount(); ++index) {
            String bankLabel = WmiUtil.getString(bankMap, PhysicalMemoryProperty.BANKLABEL, index);
            long capacity = WmiUtil.getUint64(bankMap, PhysicalMemoryProperty.CAPACITY, index);
            long speed = (long)WmiUtil.getUint32(bankMap, PhysicalMemoryProperty.CONFIGUREDCLOCKSPEED, index) * 1000000L;
            String manufacturer = WmiUtil.getString(bankMap, PhysicalMemoryProperty.MANUFACTURER, index);
            int type = WmiUtil.getUint32(bankMap, PhysicalMemoryProperty.SMBIOSMEMORYTYPE, index);
            String memoryType = WindowsGlobalMemory.smBiosMemoryType(type);
            physicalMemoryArray[index] = new PhysicalMemory(bankLabel, capacity, speed, manufacturer, memoryType);
        }
        return physicalMemoryArray;
    }

    private PerfInfo readPerfInfo() {
        Psapi.PERFORMANCE_INFORMATION performanceInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(performanceInfo, performanceInfo.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return new PerfInfo(0L, 0L, 4098L);
        }
        long pageSize = performanceInfo.PageSize.longValue();
        long memAvailable = pageSize * performanceInfo.PhysicalAvailable.longValue();
        long memTotal = pageSize * performanceInfo.PhysicalTotal.longValue();
        return new PerfInfo(memTotal, memAvailable, pageSize);
    }

    private static final class PerfInfo {
        private final long total;
        private final long available;
        private final long pageSize;

        private PerfInfo(long total, long available, long pageSize) {
            this.total = total;
            this.available = available;
            this.pageSize = pageSize;
        }
    }

    static enum PhysicalMemoryProperty {
        BANKLABEL,
        CAPACITY,
        CONFIGUREDCLOCKSPEED,
        MANUFACTURER,
        SMBIOSMEMORYTYPE;

    }
}

