/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.hardware.common.AbstractVirtualMemory;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

public class SolarisVirtualMemory
extends AbstractVirtualMemory {
    private static final long serialVersionUID = 1L;
    private static final Pattern SWAPINFO = Pattern.compile(".+\\s(\\d+)K\\s+(\\d+)K$");

    @Override
    public long getSwapUsed() {
        this.updateSwapUsed();
        return this.swapUsed;
    }

    @Override
    public long getSwapTotal() {
        this.updateSwapUsed();
        return this.swapTotal;
    }

    @Override
    public long getSwapPagesIn() {
        this.swapPagesIn = 0L;
        for (String s : ExecutingCommand.runNative("kstat -p cpu_stat:::pgpgin")) {
            this.swapPagesIn += ParseUtil.parseLastLong(s, 0L);
        }
        return this.swapPagesIn;
    }

    @Override
    public long getSwapPagesOut() {
        this.swapPagesOut = 0L;
        for (String s : ExecutingCommand.runNative("kstat -p cpu_stat:::pgpgout")) {
            this.swapPagesOut += ParseUtil.parseLastLong(s, 0L);
        }
        return this.swapPagesOut;
    }

    private void updateSwapUsed() {
        String swapInfo;
        Matcher m;
        if (System.nanoTime() - this.lastSwapUsageNanos > 300000000L && (m = SWAPINFO.matcher(swapInfo = ExecutingCommand.getAnswerAt("swap -lk", 1))).matches()) {
            this.swapTotal = ParseUtil.parseLongOrDefault(m.group(1), 0L) << 10;
            this.swapUsed = this.swapTotal - (ParseUtil.parseLongOrDefault(m.group(2), 0L) << 10);
            this.lastSwapUsageNanos = System.nanoTime();
        }
    }
}

