/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.NetworkIF;
import oshi.hardware.Networks;

public abstract class AbstractNetworks
implements Networks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetworks.class);

    @Override
    public NetworkIF[] getNetworks() {
        Enumeration<NetworkInterface> interfaces;
        ArrayList<NetworkIF> result = new ArrayList<NetworkIF>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            LOG.error("Socket exception when retrieving interfaces: {}", (Throwable)ex);
            return new NetworkIF[0];
        }
        for (NetworkInterface netint : Collections.list(interfaces)) {
            try {
                if (netint.isLoopback() || netint.getHardwareAddress() == null) continue;
                NetworkIF netIF = new NetworkIF();
                netIF.setNetworkInterface(netint);
                netIF.updateAttributes();
                result.add(netIF);
            }
            catch (SocketException ex) {
                LOG.error("Socket exception when retrieving interface \"{}\": {}", (Object)netint.getName(), (Object)ex);
            }
        }
        return result.toArray(new NetworkIF[0]);
    }
}

