/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware;

import java.io.Serializable;

public interface CentralProcessor
extends Serializable {
    public String getVendor();

    public String getName();

    public long getVendorFreq();

    public long getMaxFreq();

    public long[] getCurrentFreq();

    public String getProcessorID();

    public String getIdentifier();

    public boolean isCpu64bit();

    public String getStepping();

    public String getModel();

    public String getFamily();

    public LogicalProcessor[] getLogicalProcessors();

    public double getSystemCpuLoadBetweenTicks(long[] var1);

    public long[] getSystemCpuLoadTicks();

    public double[] getSystemLoadAverage(int var1);

    public double[] getProcessorCpuLoadBetweenTicks(long[][] var1);

    public long[][] getProcessorCpuLoadTicks();

    public int getLogicalProcessorCount();

    public int getPhysicalProcessorCount();

    public int getPhysicalPackageCount();

    public long getContextSwitches();

    public long getInterrupts();

    public static class LogicalProcessor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int processorNumber;
        private int physicalProcessorNumber;
        private int physicalPackageNumber;
        private int numaNode;
        private int processorGroup;

        public LogicalProcessor(int processorNumber, int physicalProcessorNumber, int physicalPackageNumber) {
            this(processorNumber, physicalProcessorNumber, physicalPackageNumber, 0, 0);
        }

        public LogicalProcessor(int processorNumber, int physicalProcessorNumber, int physicalPackageNumber, int numaNode) {
            this(processorNumber, physicalProcessorNumber, physicalPackageNumber, numaNode, 0);
        }

        public LogicalProcessor(int processorNumber, int physicalProcessorNumber, int physicalPackageNumber, int numaNode, int processorGroup) {
            this.processorNumber = processorNumber;
            this.physicalProcessorNumber = physicalProcessorNumber;
            this.physicalPackageNumber = physicalPackageNumber;
            this.numaNode = numaNode;
            this.processorGroup = processorGroup;
        }

        public int getProcessorNumber() {
            return this.processorNumber;
        }

        public int getPhysicalProcessorNumber() {
            return this.physicalProcessorNumber;
        }

        public int getPhysicalPackageNumber() {
            return this.physicalPackageNumber;
        }

        public int getNumaNode() {
            return this.numaNode;
        }

        public int getProcessorGroup() {
            return this.processorGroup;
        }
    }

    public static enum TickType {
        USER(0),
        NICE(1),
        SYSTEM(2),
        IDLE(3),
        IOWAIT(4),
        IRQ(5),
        SOFTIRQ(6),
        STEAL(7);

        private int index;

        private TickType(int value) {
            this.index = value;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

