/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.SetupApi;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Display;
import oshi.hardware.common.AbstractDisplay;

public class WindowsDisplay
extends AbstractDisplay {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsDisplay.class);

    public WindowsDisplay(byte[] edid) {
        super(edid);
        LOG.debug("Initialized WindowsDisplay");
    }

    public static Display[] getDisplays() {
        ArrayList<WindowsDisplay> displays = new ArrayList<WindowsDisplay>();
        Guid.GUID monitorGuid = new Guid.GUID("E6F07B5F-EE97-4a90-B076-33F57BF4EAA7");
        WinNT.HANDLE hDevInfo = SetupApi.INSTANCE.SetupDiGetClassDevs(monitorGuid, null, null, 18);
        if (!hDevInfo.equals((Object)WinNT.INVALID_HANDLE_VALUE)) {
            SetupApi.SP_DEVICE_INTERFACE_DATA deviceInterfaceData = new SetupApi.SP_DEVICE_INTERFACE_DATA();
            deviceInterfaceData.cbSize = deviceInterfaceData.size();
            SetupApi.SP_DEVINFO_DATA info = new SetupApi.SP_DEVINFO_DATA();
            int memberIndex = 0;
            while (SetupApi.INSTANCE.SetupDiEnumDeviceInfo(hDevInfo, memberIndex, info)) {
                IntByReference lpcbData;
                byte[] edid;
                IntByReference pType;
                Advapi32 advapi32 = Advapi32.INSTANCE;
                WinReg.HKEY key = SetupApi.INSTANCE.SetupDiOpenDevRegKey(hDevInfo, info, 1, 0, 1, 1);
                if (advapi32.RegQueryValueEx(key, "EDID", 0, pType = new IntByReference(), edid = new byte[1], lpcbData = new IntByReference()) == 234 && advapi32.RegQueryValueEx(key, "EDID", 0, pType, edid = new byte[lpcbData.getValue()], lpcbData) == 0) {
                    WindowsDisplay display = new WindowsDisplay(edid);
                    displays.add(display);
                }
                Advapi32.INSTANCE.RegCloseKey(key);
                ++memberIndex;
            }
        }
        return displays.toArray(new Display[0]);
    }
}

